/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * ***** BEGIN LICENSE BLOCK *****
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
package {
public class Test {}
}

import com.adobe.test.Assert;

function START(summary)
{
      // print out bugnumber

     /*if ( BUGNUMBER ) {
              writeLineToLog ("BUGNUMBER: " + BUGNUMBER );
      }*/
    XML.setSettings (null);
    testcases = new Array();

    // text field for results
    tc = 0;
    /*this.addChild ( tf );
    tf.x = 30;
    tf.y = 50;
    tf.width = 200;
    tf.height = 400;*/

    //_print(summary);
    var summaryParts = summary.split(" ");
    //_print("section: " + summaryParts[0] + "!");
    //fileName = summaryParts[0];

}

function TEST(section, expected, actual)
{
    AddTestCase(section, expected, actual);
}
 

function TEST_XML(section, expected, actual)
{
  var actual_t = typeof actual;
  var expected_t = typeof expected;

  if (actual_t != "xml") {
    // force error on type mismatch
    TEST(section, new XML(), actual);
    return;
  }

  if (expected_t == "string") {

    TEST(section, expected, actual.toXMLString());
  } else if (expected_t == "number") {

    TEST(section, String(expected), actual.toXMLString());
  } else {
    reportFailure ("", 'Bad TEST_XML usage: type of expected is "+expected_t+", should be number or string');
  }
}

function reportFailure (section, msg)
{
  trace("~FAILURE: " + section + " | " + msg);
}

function AddTestCase( description, expect, actual ) {
   testcases[tc++] = Assert.expectEq(description, "|"+expect+"|", "|"+actual+"|" );
}

function myGetNamespace (obj, ns) {
    if (ns != undefined) {
        return obj.namespace(ns);
    } else {
        return obj.namespace();
    }
}




function NL()
{
  //return java.lang.System.getProperty("line.separator");
  return "\n";
}


function BUG(arg){
  // nothing here
}

function END()
{
    //test();
}

START("13.4.4.13 - XML elements()");

//TEST(1, true, XML.prototype.hasOwnProperty("elements"));

var xmlDoc = "<MLB><Team>Giants</Team><City>San Francisco</City><Team>Padres</Team><City>San Diego</City></MLB>";

// !!@ need to verify results of these test cases
// !!@ elements appears to be broken in Rhino

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements('Team').toString()", "<Team>Giants</Team>" + NL() + "<Team>Padres</Team>",
             (MYXML = new XML(xmlDoc), MYXML.elements('Team').toString()) );

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements('TEAM').toString()", "",
             (MYXML = new XML(xmlDoc), MYXML.elements('TEAM').toString()) );

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements('bogus').toString()", "",
             (MYXML = new XML(xmlDoc), MYXML.elements('bogus').toString()) );

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements()", "<Team>Giants</Team>" + NL() + "<City>San Francisco</City>" + NL() + "<Team>Padres</Team>" + NL() + "<City>San Diego</City>",
             (MYXML = new XML(xmlDoc), MYXML.elements().toString()) );
    
xmlDoc = "<MLB><Team>Giants</Team><City>San Francisco</City></MLB>";

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements('City').toString()", "San Francisco",
             (MYXML = new XML(xmlDoc), MYXML.elements('City').toString()) );

xmlDoc = "<A><MLB><Team>Giants</Team><City>San Francisco</City><Team>Padres</Team><City>San Diego</City></MLB></A>";

Assert.expectEq( "MYXML = new XML(xmlDoc), MYXML.elements('MLB')", "<MLB>" + NL() + "  <Team>Giants</Team>" + NL() + "  <City>San Francisco</City>" + NL() + "  <Team>Padres</Team>" + NL() + "  <City>San Diego</City>" + NL() + "</MLB>",
             (MYXML = new XML(xmlDoc), MYXML.elements('MLB').toString()) );


END();
