/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Binding;
import adobe.abc.GlobalOptimizer;
import adobe.abc.Method;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Type;
import adobe.abc.TypeCache;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AbcThunkGen {
    private GlobalOptimizer.InputAbc abc;
    private byte[] abcdata;
    private String name;
    private Map<Namespace, Name> namespaceNames;
    private PrintWriter out_h;
    private IndentingPrintWriter out_c;
    private Map<Integer, String> native_methods;
    private HashMap<Type, Integer> class_id_map;
    private HashMap<String, HashMap<String, Method>> unique_thunks;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("usage: AbcThunkGen [-import foo.abc] bar.abc");
            return;
        }
        byte[] abcdata = null;
        GlobalOptimizer.InputAbc ia = null;
        String filename = null;
        GlobalOptimizer go = new GlobalOptimizer();
        go.ALLOW_NATIVE_CTORS = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-import")) {
                GlobalOptimizer.InputAbc imported = new GlobalOptimizer.InputAbc(go);
                imported.readAbc(AbcThunkGen.load(args[++i]));
                continue;
            }
            if (ia != null) {
                throw new RuntimeException("only one abc file may be specified");
            }
            filename = args[i];
            abcdata = AbcThunkGen.load(filename);
            ia = new GlobalOptimizer.InputAbc(go);
            ia.readAbc(abcdata);
        }
        if (ia == null) {
            throw new RuntimeException("an abc file must be specified");
        }
        String scriptname = filename.substring(0, filename.lastIndexOf(46));
        AbcThunkGen.emitNatives(ia, abcdata, scriptname, TypeCache.instance().namespaceNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] load(String filename) throws IOException {
        try (FileInputStream in = new FileInputStream(filename);){
            byte[] before = new byte[((InputStream)in).available()];
            ((InputStream)in).read(before);
            byte[] byArray = before;
            return byArray;
        }
    }

    AbcThunkGen(GlobalOptimizer.InputAbc abc, byte[] abcdata, String name, Map<Namespace, Name> namespaceNames, PrintWriter out_h, IndentingPrintWriter out_c) {
        this.abc = abc;
        this.abcdata = abcdata;
        this.name = name;
        this.namespaceNames = namespaceNames;
        this.out_h = out_h;
        this.out_c = out_c;
        this.native_methods = new TreeMap<Integer, String>();
        this.unique_thunks = new HashMap();
        this.class_id_map = new HashMap();
        for (int i = 0; i < abc.classes.length; ++i) {
            this.class_id_map.put(abc.classes[i], i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void emitNatives(GlobalOptimizer.InputAbc abc, byte[] abcdata, String name, Map<Namespace, Name> namespaceNames) throws IOException {
        PrintWriter out_h = new PrintWriter(new FileWriter(name + ".h2"));
        IndentingPrintWriter out_c = new IndentingPrintWriter(new FileWriter(name + ".cpp2"));
        try {
            AbcThunkGen ngen = new AbcThunkGen(abc, abcdata, name, namespaceNames, out_h, out_c);
            ngen.emit();
        }
        finally {
            out_c.close();
            out_h.close();
        }
    }

    private void emit() {
        this.out_h.println("/* machine generated file -- do not edit */");
        this.out_c.println("/* machine generated file -- do not edit */");
        this.out_h.println("#define AVMTHUNK_VERSION 1");
        this.out_h.printf("const uint32_t %s_abc_class_count = %d;\n", this.name, this.abc.classes.length);
        this.out_h.printf("const uint32_t %s_abc_script_count = %d;\n", this.name, this.abc.scripts.length);
        this.out_h.printf("const uint32_t %s_abc_method_count = %d;\n", this.name, this.abc.methods.length);
        this.out_h.printf("const uint32_t %s_abc_length = %d;\n", this.name, this.abcdata.length);
        this.out_h.printf("extern const uint8_t %s_abc_data[%d];\n", this.name, this.abcdata.length);
        for (int i = 0; i < this.abc.scripts.length; ++i) {
            Type s = this.abc.scripts[i];
            for (Binding bb : s.defs.values()) {
                if (bb.method == null || !bb.method.isNative()) continue;
                this.out_h.println("const uint32_t abcscript_" + bb.getName() + " = " + i + ";");
            }
            this.emitSourceTraits("", s);
        }
        this.out_c.println("// " + this.unique_thunks.size() + " unique thunks");
        for (String sig : this.unique_thunks.keySet()) {
            this.out_c.println();
            HashMap<String, Method> users = this.unique_thunks.get(sig);
            assert (users.size() > 0);
            Method m = null;
            for (String native_name : users.keySet()) {
                this.out_c.println("// " + native_name);
                m = users.get(native_name);
            }
            String thunkname = this.name + "_" + sig;
            this.emitThunk(thunkname, m, false);
            this.emitThunk(thunkname, m, true);
            for (String native_name : users.keySet()) {
                m = users.get(native_name);
                this.out_h.printf("  const uint32_t %s = %d;\n", native_name, m.id);
                this.out_h.printf("  #define %s_thunk  %s_thunk\n", native_name, thunkname);
                this.out_h.printf("  #define %s_thunkc %s_thunkc\n", native_name, thunkname);
            }
        }
        this.out_c.println("const uint8_t " + this.name + "_abc_data[" + this.abcdata.length + "] = {");
        int n = this.abcdata.length;
        for (int i = 0; i < n; ++i) {
            int x = this.abcdata[i] & 0xFF;
            if (x < 10) {
                this.out_c.print("  ");
            } else if (x < 100) {
                this.out_c.print(' ');
            }
            this.out_c.print(x);
            if (i + 1 < n) {
                this.out_c.print(", ");
            }
            if (i % 16 != 15) continue;
            this.out_c.println();
        }
        this.out_c.println("};");
    }

    void emitSourceTraits(String prefix, Type s) {
        if (s.init != null && s.init.isNative()) {
            String native_name = prefix + s.getName();
            this.gatherThunk(native_name, s.init);
        }
        for (Binding b : s.defs.values()) {
            Namespace ns = b.getName().nsset(0);
            String id = prefix + this.propLabel(b, ns);
            Object ctype = null;
            if (b.method != null) {
                if (!b.method.isNative()) continue;
                this.emitSourceMethod(prefix, b, ns);
                continue;
            }
            if (!GlobalOptimizer.isClass(b)) continue;
            this.emitSourceClass(b, ns);
        }
    }

    static String to_cname(String nm) {
        nm = nm.replace("+", "_");
        nm = nm.replace("-", "_");
        nm = nm.replace("?", "_");
        nm = nm.replace("!", "_");
        nm = nm.replace("<", "_");
        nm = nm.replace(">", "_");
        nm = nm.replace("=", "_");
        nm = nm.replace("(", "_");
        nm = nm.replace(")", "_");
        nm = nm.replace("\"", "_");
        nm = nm.replace("'", "_");
        nm = nm.replace("*", "_");
        nm = nm.replace(" ", "_");
        nm = nm.replace(".", "_");
        nm = nm.replace("$", "_");
        nm = nm.replace(":", "_");
        nm = nm.replace("/", "_");
        return nm;
    }

    void emitSourceClass(Binding b, Namespace ns) {
        String label = this.ns_prefix(ns, true) + AbcThunkGen.to_cname(b.getName().name);
        Type c = b.type.t;
        this.out_h.println();
        this.out_h.println("const uint32_t abcclass_" + label + " = " + this.class_id_map.get(c) + ";");
        this.emitSourceTraits(label + "_", c);
        this.emitSourceTraits(label + "_", c.itype);
    }

    String ctype_i(int ctype, boolean allowObject) {
        switch (ctype) {
            case 8: {
                if (allowObject) {
                    return "AvmObject";
                }
            }
            case 1: {
                return "AvmBox";
            }
            case 0: {
                return "void";
            }
            case 2: {
                return "AvmBoolArg";
            }
            case 3: {
                return "int32_t";
            }
            case 4: {
                return "uint32_t";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "AvmString";
            }
            case 7: {
                return "AvmNamespace";
            }
        }
        assert (false);
        return "";
    }

    void emitSourceMethod(String prefix, Binding b, Namespace ns) {
        Method m = b.method;
        String native_name = prefix + this.propLabel(b, ns);
        if (GlobalOptimizer.isGetter(b)) {
            native_name = native_name + "_get";
        } else if (GlobalOptimizer.isSetter(b)) {
            native_name = native_name + "_set";
        }
        this.gatherThunk(native_name, m);
    }

    String ns_prefix(Namespace ns, boolean iscls) {
        String p;
        if (!ns.isPublic() && !ns.isInternal()) {
            if (ns.isPrivate() && !iscls) {
                return "private_";
            }
            if (ns.isProtected()) {
                return "protected_";
            }
            if (this.namespaceNames.containsKey(ns)) {
                return this.namespaceNames.get(ns) + "_";
            }
        }
        if ((p = AbcThunkGen.to_cname(ns.uri)).length() > 0) {
            p = p + "_";
        }
        return p;
    }

    String propLabel(Binding b, Namespace ns) {
        return this.ns_prefix(ns, false) + b.getName().name;
    }

    int defValCType(Object value) {
        if (value instanceof Integer) {
            return 3;
        }
        if (value instanceof Long) {
            return 4;
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (d == (double)((int)d)) {
                return 3;
            }
            if (d == (double)((long)d)) {
                return 4;
            }
            return 5;
        }
        if (value instanceof String) {
            return 6;
        }
        if (value == Boolean.TRUE) {
            return 2;
        }
        if (value == Boolean.FALSE) {
            return 2;
        }
        if (value.toString() == "undefined") {
            return 1;
        }
        if (value.toString() == "null") {
            return 1;
        }
        throw new RuntimeException("unsupported default-value type " + value.toString());
    }

    String defValStr(Object value) {
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (d == (double)((int)d)) {
                return Integer.toString((int)d, 10);
            }
            if (d == (double)((long)d)) {
                return Long.toString((long)d, 10) + "U";
            }
            if (Double.isInfinite(d)) {
                return d < 0.0 ? "kAvmThunkNegInfinity" : "kAvmThunkInfinity";
            }
            if (Double.isNaN(d)) {
                return "kAvmThunkNaN";
            }
            return value.toString();
        }
        if (value instanceof String) {
            for (int i = 0; i < this.abc.strings.length; ++i) {
                if (!this.abc.strings[i].equals(value)) continue;
                return "AvmThunkConstant_AvmString(" + Integer.toString(i, 10) + ")/* \"" + this.abc.strings[i] + "\" */";
            }
        }
        if (value == Boolean.TRUE) {
            return "true";
        }
        if (value == Boolean.FALSE) {
            return "false";
        }
        if (value.toString() == "undefined") {
            return "kAvmThunkUndefined";
        }
        if (value.toString() == "null") {
            return "kAvmThunkNull";
        }
        throw new RuntimeException("unsupported default-value type " + value.toString());
    }

    int get_optional_count(Method m) {
        int optional_count = 0;
        if (m.values != null) {
            for (Object v : m.values) {
                if (v == null) continue;
                ++optional_count;
            }
        }
        return optional_count;
    }

    String sigChar(int ctype, boolean allowObject) {
        switch (ctype) {
            case 8: {
                if (allowObject) {
                    return "o";
                }
            }
            case 1: {
                return "a";
            }
            case 0: {
                return "v";
            }
            case 2: {
                return "b";
            }
            case 3: {
                return "i";
            }
            case 4: {
                return "u";
            }
            case 5: {
                return "d";
            }
            case 6: {
                return "s";
            }
            case 7: {
                return "n";
            }
        }
        assert (false);
        return "";
    }

    String thunkSig(Method m) {
        String sig = this.sigChar(m.returns.t.ctype, false) + "2";
        sig = m.returns.t.ctype == 5 ? sig + this.sigChar(5, false) : sig + this.sigChar(1, false);
        sig = sig + "_";
        for (int i = 0; i < m.getParams().length; ++i) {
            sig = sig + this.sigChar(m.getParams()[i].t.ctype, true);
        }
        if (m.hasOptional()) {
            int param_count = m.getParams().length - 1;
            int optional_count = this.get_optional_count(m);
            for (int i = param_count - optional_count + 1; i <= param_count; ++i) {
                String dts = this.sigChar(this.defValCType(m.values[i]), true);
                String defval = AbcThunkGen.to_cname(this.defValStr(m.values[i]));
                sig = sig + "_opt" + dts + defval;
            }
        } else assert (this.get_optional_count(m) == 0);
        if (m.needsRest()) {
            sig = sig + "_rest";
        }
        return sig;
    }

    void gatherThunk(String native_name, Method m) {
        this.native_methods.put(m.id, native_name);
        String sig = this.thunkSig(m);
        if (!this.unique_thunks.containsKey(sig)) {
            this.unique_thunks.put(sig, new HashMap());
        }
        this.unique_thunks.get(sig).put(native_name, m);
    }

    void emitThunk(String name, Method m, boolean cookie) {
        String ret = this.ctype_i(m.returns.t.ctype, false);
        this.out_h.printf("extern AvmThunkRetType_%s AVMTHUNK_CALLTYPE %s_thunk%s(AvmMethodEnv env, uint32_t argc, const AvmBox* argv);\n", ret, name, cookie ? "c" : "");
        this.out_c.printf("AvmThunkRetType_%s AVMTHUNK_CALLTYPE %s_thunk%s(AvmMethodEnv env, uint32_t argc, const AvmBox* argv)\n", ret, name, cookie ? "c" : "");
        this.out_c.println("{");
        ++this.out_c.indent;
        int param_count = m.getParams().length - 1;
        assert (param_count >= 0);
        int optional_count = this.get_optional_count(m);
        assert (optional_count <= param_count);
        String argszprev = "0";
        for (int i = 0; i < m.getParams().length; ++i) {
            String cts = this.ctype_i(m.getParams()[i].t.ctype, true);
            if (i == 0) {
                this.out_c.println("const uint32_t argoff0 = 0;");
            } else {
                this.out_c.println("const uint32_t argoff" + i + " = argoff" + (i - 1) + " + " + argszprev + ";");
            }
            argszprev = "AvmThunkArgSize_" + cts;
        }
        if (m.needsRest()) {
            this.out_c.println("const uint32_t argoffV = argoff" + (m.getParams().length - 1) + " + " + argszprev + ";");
        }
        int argct = m.getParams().length + (cookie ? 1 : 0) + (m.needsRest() ? 2 : 0);
        String[] argvals = new String[argct];
        String[] argtypes = new String[argct];
        int argsidx = 0;
        for (int i = 0; i < m.getParams().length; ++i) {
            String cts = this.ctype_i(m.getParams()[i].t.ctype, true);
            String val = "AvmThunkUnbox_" + cts + "(argv[argoff" + i + "])";
            if (i > param_count - optional_count) {
                String dts = this.ctype_i(this.defValCType(m.values[i]), true);
                String defval = this.defValStr(m.values[i]);
                if (!dts.equals(cts)) {
                    defval = "AvmThunkCoerce_" + dts + "_" + cts + "(" + defval + ")";
                }
                val = "(argc < " + i + " ? " + defval + " : " + val + ")";
            }
            argvals[argsidx] = val;
            argtypes[argsidx] = cts;
            ++argsidx;
            if (i != 0 || !cookie) continue;
            argvals[argsidx] = "AVMTHUNK_GET_COOKIE(env)";
            argtypes[argsidx] = "int32_t";
            ++argsidx;
        }
        if (m.needsRest()) {
            argvals[argsidx] = "(argc <= " + param_count + " ? NULL : argv + argoffV)";
            argtypes[argsidx] = "const AvmBox*";
            argvals[++argsidx] = "(argc <= " + param_count + " ? 0 : argc - " + param_count + ")";
            argtypes[argsidx] = "uint32_t";
            ++argsidx;
        }
        if (!m.hasOptional() && !m.needsRest()) {
            this.out_c.println("(void)argc;");
        }
        this.out_c.println("AVMTHUNK_DEBUG_ENTER(env)");
        String call = "";
        if (m.returns.t.ctype != 0) {
            call = call + "const " + ret + " ret = ";
        }
        call = call + "AVMTHUNK_CALL_FUNCTION_" + (argvals.length - 1) + "(AVMTHUNK_GET_HANDLER(env), " + ret;
        this.out_c.println(call);
        ++this.out_c.indent;
        for (int i = 0; i < argvals.length; ++i) {
            this.out_c.println(", " + argtypes[i] + ", " + argvals[i]);
        }
        --this.out_c.indent;
        this.out_c.println(");");
        this.out_c.println("AVMTHUNK_DEBUG_EXIT(env)");
        this.out_c.println("return AvmToRetType_" + ret + "(ret);");
        --this.out_c.indent;
        this.out_c.println("}");
    }

    static class IndentingPrintWriter
    extends PrintWriter {
        int indent;

        IndentingPrintWriter(Writer w) {
            super(w);
        }

        @Override
        public void println() {
            for (int i = 0; i < this.indent; ++i) {
                this.print("    ");
            }
            super.println();
        }

        @Override
        public void println(String s) {
            for (int i = 0; i < this.indent; ++i) {
                this.print("    ");
            }
            super.println(s);
        }
    }
}

