# How to contribute

So, you've decided to contribute, that's great!

You can use this document to figure out how and where to start.

## Getting started

- Make sure you have a [GitHub account](https://github.com/join).
- Take a look at [existing issues](https://github.com/launchbadge/sqlx/issues).
- If you need to create an issue:
  - Make sure to clearly describe it.
  - Including steps to reproduce when it is a bug.
  - Include the version of SQLx used.
  - Include the database driver and version.
  - Include the database version.

## Making changes

- Fork the repository on GitHub.
- Create a branch on your fork.
  - You can usually base it on the `main` branch.
  - Make sure not to commit directly to `main`.
- Make commits of logical and atomic units.
- Make sure you have added the necessary tests for your changes.
- Push your changes to a topic branch in your fork of the repository.
- Submit a pull request to the original repository.

## What to work on

We try to mark issues with a suggested level of experience (in Rust/SQL/SQLx).
Where possible we try to spell out how to go about implementing the feature.

To start with, check out:
- Issues labeled as ["good first issue"](https://github.com/launchbadge/sqlx/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22).
- Issues labeled as ["Easy"](https://github.com/launchbadge/sqlx/issues?q=is%3Aopen+is%3Aissue+label%3AE-easy).

Additionally, it's always good to work on improving/adding examples and documentation.

## Communication

If you're unsure about your contribution or simply want to ask a question about anything, you can:
- Visit the [SQLx Discord server](https://discord.gg/uuruzJ7)
- Discuss something directly in the [Github issue](https://github.com/launchbadge/sqlx/issues).
