//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewanimationcurve?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewAnimationCurve(pub NSInteger);
impl UIViewAnimationCurve {
    #[doc(alias = "UIViewAnimationCurveEaseInOut")]
    pub const EaseInOut: Self = Self(0);
    #[doc(alias = "UIViewAnimationCurveEaseIn")]
    pub const EaseIn: Self = Self(1);
    #[doc(alias = "UIViewAnimationCurveEaseOut")]
    pub const EaseOut: Self = Self(2);
    #[doc(alias = "UIViewAnimationCurveLinear")]
    pub const Linear: Self = Self(3);
}

unsafe impl Encode for UIViewAnimationCurve {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIViewAnimationCurve {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontentmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewContentMode(pub NSInteger);
impl UIViewContentMode {
    #[doc(alias = "UIViewContentModeScaleToFill")]
    pub const ScaleToFill: Self = Self(0);
    #[doc(alias = "UIViewContentModeScaleAspectFit")]
    pub const ScaleAspectFit: Self = Self(1);
    #[doc(alias = "UIViewContentModeScaleAspectFill")]
    pub const ScaleAspectFill: Self = Self(2);
    #[doc(alias = "UIViewContentModeRedraw")]
    pub const Redraw: Self = Self(3);
    #[doc(alias = "UIViewContentModeCenter")]
    pub const Center: Self = Self(4);
    #[doc(alias = "UIViewContentModeTop")]
    pub const Top: Self = Self(5);
    #[doc(alias = "UIViewContentModeBottom")]
    pub const Bottom: Self = Self(6);
    #[doc(alias = "UIViewContentModeLeft")]
    pub const Left: Self = Self(7);
    #[doc(alias = "UIViewContentModeRight")]
    pub const Right: Self = Self(8);
    #[doc(alias = "UIViewContentModeTopLeft")]
    pub const TopLeft: Self = Self(9);
    #[doc(alias = "UIViewContentModeTopRight")]
    pub const TopRight: Self = Self(10);
    #[doc(alias = "UIViewContentModeBottomLeft")]
    pub const BottomLeft: Self = Self(11);
    #[doc(alias = "UIViewContentModeBottomRight")]
    pub const BottomRight: Self = Self(12);
}

unsafe impl Encode for UIViewContentMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIViewContentMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewanimationtransition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewAnimationTransition(pub NSInteger);
impl UIViewAnimationTransition {
    #[doc(alias = "UIViewAnimationTransitionNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIViewAnimationTransitionFlipFromLeft")]
    pub const FlipFromLeft: Self = Self(1);
    #[doc(alias = "UIViewAnimationTransitionFlipFromRight")]
    pub const FlipFromRight: Self = Self(2);
    #[doc(alias = "UIViewAnimationTransitionCurlUp")]
    pub const CurlUp: Self = Self(3);
    #[doc(alias = "UIViewAnimationTransitionCurlDown")]
    pub const CurlDown: Self = Self(4);
}

unsafe impl Encode for UIViewAnimationTransition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIViewAnimationTransition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewautoresizing?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewAutoresizing(pub NSUInteger);
bitflags::bitflags! {
    impl UIViewAutoresizing: NSUInteger {
        #[doc(alias = "UIViewAutoresizingNone")]
        const None = 0;
        #[doc(alias = "UIViewAutoresizingFlexibleLeftMargin")]
        const FlexibleLeftMargin = 1<<0;
        #[doc(alias = "UIViewAutoresizingFlexibleWidth")]
        const FlexibleWidth = 1<<1;
        #[doc(alias = "UIViewAutoresizingFlexibleRightMargin")]
        const FlexibleRightMargin = 1<<2;
        #[doc(alias = "UIViewAutoresizingFlexibleTopMargin")]
        const FlexibleTopMargin = 1<<3;
        #[doc(alias = "UIViewAutoresizingFlexibleHeight")]
        const FlexibleHeight = 1<<4;
        #[doc(alias = "UIViewAutoresizingFlexibleBottomMargin")]
        const FlexibleBottomMargin = 1<<5;
    }
}

unsafe impl Encode for UIViewAutoresizing {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIViewAutoresizing {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewanimationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewAnimationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl UIViewAnimationOptions: NSUInteger {
        #[doc(alias = "UIViewAnimationOptionLayoutSubviews")]
        const LayoutSubviews = 1<<0;
        #[doc(alias = "UIViewAnimationOptionAllowUserInteraction")]
        const AllowUserInteraction = 1<<1;
        #[doc(alias = "UIViewAnimationOptionBeginFromCurrentState")]
        const BeginFromCurrentState = 1<<2;
        #[doc(alias = "UIViewAnimationOptionRepeat")]
        const Repeat = 1<<3;
        #[doc(alias = "UIViewAnimationOptionAutoreverse")]
        const Autoreverse = 1<<4;
        #[doc(alias = "UIViewAnimationOptionOverrideInheritedDuration")]
        const OverrideInheritedDuration = 1<<5;
        #[doc(alias = "UIViewAnimationOptionOverrideInheritedCurve")]
        const OverrideInheritedCurve = 1<<6;
        #[doc(alias = "UIViewAnimationOptionAllowAnimatedContent")]
        const AllowAnimatedContent = 1<<7;
        #[doc(alias = "UIViewAnimationOptionShowHideTransitionViews")]
        const ShowHideTransitionViews = 1<<8;
        #[doc(alias = "UIViewAnimationOptionOverrideInheritedOptions")]
        const OverrideInheritedOptions = 1<<9;
        #[doc(alias = "UIViewAnimationOptionCurveEaseInOut")]
        const CurveEaseInOut = 0<<16;
        #[doc(alias = "UIViewAnimationOptionCurveEaseIn")]
        const CurveEaseIn = 1<<16;
        #[doc(alias = "UIViewAnimationOptionCurveEaseOut")]
        const CurveEaseOut = 2<<16;
        #[doc(alias = "UIViewAnimationOptionCurveLinear")]
        const CurveLinear = 3<<16;
        #[doc(alias = "UIViewAnimationOptionTransitionNone")]
        const TransitionNone = 0<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionFlipFromLeft")]
        const TransitionFlipFromLeft = 1<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionFlipFromRight")]
        const TransitionFlipFromRight = 2<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionCurlUp")]
        const TransitionCurlUp = 3<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionCurlDown")]
        const TransitionCurlDown = 4<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionCrossDissolve")]
        const TransitionCrossDissolve = 5<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionFlipFromTop")]
        const TransitionFlipFromTop = 6<<20;
        #[doc(alias = "UIViewAnimationOptionTransitionFlipFromBottom")]
        const TransitionFlipFromBottom = 7<<20;
        #[doc(alias = "UIViewAnimationOptionPreferredFramesPerSecondDefault")]
        const PreferredFramesPerSecondDefault = 0<<24;
        #[doc(alias = "UIViewAnimationOptionPreferredFramesPerSecond60")]
        const PreferredFramesPerSecond60 = 3<<24;
        #[doc(alias = "UIViewAnimationOptionPreferredFramesPerSecond30")]
        const PreferredFramesPerSecond30 = 7<<24;
    }
}

unsafe impl Encode for UIViewAnimationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIViewAnimationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewkeyframeanimationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewKeyframeAnimationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl UIViewKeyframeAnimationOptions: NSUInteger {
        #[doc(alias = "UIViewKeyframeAnimationOptionLayoutSubviews")]
        const LayoutSubviews = UIViewAnimationOptions::LayoutSubviews.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionAllowUserInteraction")]
        const AllowUserInteraction = UIViewAnimationOptions::AllowUserInteraction.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionBeginFromCurrentState")]
        const BeginFromCurrentState = UIViewAnimationOptions::BeginFromCurrentState.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionRepeat")]
        const Repeat = UIViewAnimationOptions::Repeat.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionAutoreverse")]
        const Autoreverse = UIViewAnimationOptions::Autoreverse.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionOverrideInheritedDuration")]
        const OverrideInheritedDuration = UIViewAnimationOptions::OverrideInheritedDuration.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionOverrideInheritedOptions")]
        const OverrideInheritedOptions = UIViewAnimationOptions::OverrideInheritedOptions.0;
        #[doc(alias = "UIViewKeyframeAnimationOptionCalculationModeLinear")]
        const CalculationModeLinear = 0<<10;
        #[doc(alias = "UIViewKeyframeAnimationOptionCalculationModeDiscrete")]
        const CalculationModeDiscrete = 1<<10;
        #[doc(alias = "UIViewKeyframeAnimationOptionCalculationModePaced")]
        const CalculationModePaced = 2<<10;
        #[doc(alias = "UIViewKeyframeAnimationOptionCalculationModeCubic")]
        const CalculationModeCubic = 3<<10;
        #[doc(alias = "UIViewKeyframeAnimationOptionCalculationModeCubicPaced")]
        const CalculationModeCubicPaced = 4<<10;
    }
}

unsafe impl Encode for UIViewKeyframeAnimationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIViewKeyframeAnimationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisystemanimation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UISystemAnimation(pub NSUInteger);
impl UISystemAnimation {
    #[doc(alias = "UISystemAnimationDelete")]
    pub const Delete: Self = Self(0);
}

unsafe impl Encode for UISystemAnimation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UISystemAnimation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewtintadjustmentmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIViewTintAdjustmentMode(pub NSInteger);
impl UIViewTintAdjustmentMode {
    #[doc(alias = "UIViewTintAdjustmentModeAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIViewTintAdjustmentModeNormal")]
    pub const Normal: Self = Self(1);
    #[doc(alias = "UIViewTintAdjustmentModeDimmed")]
    pub const Dimmed: Self = Self(2);
}

unsafe impl Encode for UIViewTintAdjustmentMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIViewTintAdjustmentMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisemanticcontentattribute?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UISemanticContentAttribute(pub NSInteger);
impl UISemanticContentAttribute {
    #[doc(alias = "UISemanticContentAttributeUnspecified")]
    pub const Unspecified: Self = Self(0);
    #[doc(alias = "UISemanticContentAttributePlayback")]
    pub const Playback: Self = Self(1);
    #[doc(alias = "UISemanticContentAttributeSpatial")]
    pub const Spatial: Self = Self(2);
    #[doc(alias = "UISemanticContentAttributeForceLeftToRight")]
    pub const ForceLeftToRight: Self = Self(3);
    #[doc(alias = "UISemanticContentAttributeForceRightToLeft")]
    pub const ForceRightToLeft: Self = Self(4);
}

unsafe impl Encode for UISemanticContentAttribute {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UISemanticContentAttribute {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicoordinatespace?language=objc)
    pub unsafe trait UICoordinateSpace: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertPoint:toCoordinateSpace:))]
        #[unsafe(method_family = none)]
        fn convertPoint_toCoordinateSpace(
            &self,
            point: CGPoint,
            coordinate_space: &ProtocolObject<dyn UICoordinateSpace>,
        ) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertPoint:fromCoordinateSpace:))]
        #[unsafe(method_family = none)]
        fn convertPoint_fromCoordinateSpace(
            &self,
            point: CGPoint,
            coordinate_space: &ProtocolObject<dyn UICoordinateSpace>,
        ) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:toCoordinateSpace:))]
        #[unsafe(method_family = none)]
        fn convertRect_toCoordinateSpace(
            &self,
            rect: CGRect,
            coordinate_space: &ProtocolObject<dyn UICoordinateSpace>,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:fromCoordinateSpace:))]
        #[unsafe(method_family = none)]
        fn convertRect_fromCoordinateSpace(
            &self,
            rect: CGRect,
            coordinate_space: &ProtocolObject<dyn UICoordinateSpace>,
        ) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        fn bounds(&self) -> CGRect;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiview?language=objc)
    #[unsafe(super(UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIResponder")]
    pub struct UIView;
);

#[cfg(all(feature = "UIResponder", feature = "objc2-quartz-core"))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UIView {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSCoding for UIView {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIAppearance for UIView {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIView {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl UICoordinateSpace for UIView {}
);

#[cfg(all(feature = "UIDynamicBehavior", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIDynamicItem for UIView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIFocusItem for UIView {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UIView {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIView {}
);

#[cfg(all(feature = "UIResponder", feature = "UITraitCollection"))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIView {}
);

#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(layerClass))]
        #[unsafe(method_family = none)]
        pub fn layerClass(mtm: MainThreadMarker) -> &'static AnyClass;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(isUserInteractionEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isUserInteractionEnabled(&self) -> bool;

        /// Setter for [`isUserInteractionEnabled`][Self::isUserInteractionEnabled].
        #[unsafe(method(setUserInteractionEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInteractionEnabled(&self, user_interaction_enabled: bool);

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub unsafe fn tag(&self) -> NSInteger;

        /// Setter for [`tag`][Self::tag].
        #[unsafe(method(setTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTag(&self, tag: NSInteger);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(layer))]
        #[unsafe(method_family = none)]
        pub fn layer(&self) -> Retained<CALayer>;

        #[unsafe(method(canBecomeFocused))]
        #[unsafe(method_family = none)]
        pub unsafe fn canBecomeFocused(&self) -> bool;

        #[unsafe(method(isFocused))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFocused(&self) -> bool;

        /// The identifier of the focus group that this view belongs to. If this is nil, subviews inherit their superview's focus group.
        #[unsafe(method(focusGroupIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusGroupIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`focusGroupIdentifier`][Self::focusGroupIdentifier].
        #[unsafe(method(setFocusGroupIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusGroupIdentifier(&self, focus_group_identifier: Option<&NSString>);

        #[cfg(feature = "UIFocus")]
        /// The priority this item has in its focus group. The higher the priority, the more likely it is to get picked when focus moves into this group.
        /// Note: this method can only be used to increase an item's priority, not decrease it. For example if an item is currently selected, the actual priority of this item will be determined by MAX(focusGroupPriority, UIFocusGroupPrioritySelected).
        #[unsafe(method(focusGroupPriority))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusGroupPriority(&self) -> UIFocusGroupPriority;

        #[cfg(feature = "UIFocus")]
        /// Setter for [`focusGroupPriority`][Self::focusGroupPriority].
        #[unsafe(method(setFocusGroupPriority:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusGroupPriority(&self, focus_group_priority: UIFocusGroupPriority);

        #[cfg(feature = "UIFocusEffect")]
        /// Describes a visual effect to apply when this item is focused. If this property is nil no effect will be applied when this view becomes focused.
        #[unsafe(method(focusEffect))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusEffect(&self) -> Option<Retained<UIFocusEffect>>;

        #[cfg(feature = "UIFocusEffect")]
        /// Setter for [`focusEffect`][Self::focusEffect].
        #[unsafe(method(setFocusEffect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusEffect(&self, focus_effect: Option<&UIFocusEffect>);

        #[unsafe(method(semanticContentAttribute))]
        #[unsafe(method_family = none)]
        pub unsafe fn semanticContentAttribute(&self) -> UISemanticContentAttribute;

        /// Setter for [`semanticContentAttribute`][Self::semanticContentAttribute].
        #[unsafe(method(setSemanticContentAttribute:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSemanticContentAttribute(
            &self,
            semantic_content_attribute: UISemanticContentAttribute,
        );

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(userInterfaceLayoutDirectionForSemanticContentAttribute:))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceLayoutDirectionForSemanticContentAttribute(
            attribute: UISemanticContentAttribute,
            mtm: MainThreadMarker,
        ) -> UIUserInterfaceLayoutDirection;

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(userInterfaceLayoutDirectionForSemanticContentAttribute:relativeToLayoutDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInterfaceLayoutDirectionForSemanticContentAttribute_relativeToLayoutDirection(
            semantic_content_attribute: UISemanticContentAttribute,
            layout_direction: UIUserInterfaceLayoutDirection,
            mtm: MainThreadMarker,
        ) -> UIUserInterfaceLayoutDirection;

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(effectiveUserInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectiveUserInterfaceLayoutDirection(
            &self,
        ) -> UIUserInterfaceLayoutDirection;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// UIViewGeometry.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub fn frame(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`frame`][Self::frame].
        #[unsafe(method(setFrame:))]
        #[unsafe(method_family = none)]
        pub fn setFrame(&self, frame: CGRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub fn bounds(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`bounds`][Self::bounds].
        #[unsafe(method(setBounds:))]
        #[unsafe(method_family = none)]
        pub fn setBounds(&self, bounds: CGRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(center))]
        #[unsafe(method_family = none)]
        pub unsafe fn center(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`center`][Self::center].
        #[unsafe(method(setCenter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCenter(&self, center: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(transform))]
        #[unsafe(method_family = none)]
        pub unsafe fn transform(&self) -> CGAffineTransform;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`transform`][Self::transform].
        #[unsafe(method(setTransform:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTransform(&self, transform: CGAffineTransform);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(transform3D))]
        #[unsafe(method_family = none)]
        pub unsafe fn transform3D(&self) -> CATransform3D;

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(not(target_os = "watchos"))]
        /// Setter for [`transform3D`][Self::transform3D].
        #[unsafe(method(setTransform3D:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTransform3D(&self, transform3_d: CATransform3D);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentScaleFactor))]
        #[unsafe(method_family = none)]
        pub fn contentScaleFactor(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentScaleFactor`][Self::contentScaleFactor].
        #[unsafe(method(setContentScaleFactor:))]
        #[unsafe(method_family = none)]
        pub fn setContentScaleFactor(&self, content_scale_factor: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(anchorPoint))]
        #[unsafe(method_family = none)]
        pub unsafe fn anchorPoint(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`anchorPoint`][Self::anchorPoint].
        #[unsafe(method(setAnchorPoint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnchorPoint(&self, anchor_point: CGPoint);

        #[unsafe(method(isMultipleTouchEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMultipleTouchEnabled(&self) -> bool;

        /// Setter for [`isMultipleTouchEnabled`][Self::isMultipleTouchEnabled].
        #[unsafe(method(setMultipleTouchEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setMultipleTouchEnabled(&self, multiple_touch_enabled: bool);

        #[unsafe(method(isExclusiveTouch))]
        #[unsafe(method_family = none)]
        pub unsafe fn isExclusiveTouch(&self) -> bool;

        /// Setter for [`isExclusiveTouch`][Self::isExclusiveTouch].
        #[unsafe(method(setExclusiveTouch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExclusiveTouch(&self, exclusive_touch: bool);

        #[cfg(all(feature = "UIEvent", feature = "objc2-core-foundation"))]
        #[unsafe(method(hitTest:withEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hitTest_withEvent(
            &self,
            point: CGPoint,
            event: Option<&UIEvent>,
        ) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIEvent", feature = "objc2-core-foundation"))]
        #[unsafe(method(pointInside:withEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pointInside_withEvent(&self, point: CGPoint, event: Option<&UIEvent>)
            -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertPoint:toView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPoint_toView(&self, point: CGPoint, view: Option<&UIView>) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertPoint:fromView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertPoint_fromView(
            &self,
            point: CGPoint,
            view: Option<&UIView>,
        ) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:toView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRect_toView(&self, rect: CGRect, view: Option<&UIView>) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:fromView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn convertRect_fromView(&self, rect: CGRect, view: Option<&UIView>) -> CGRect;

        #[unsafe(method(autoresizesSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoresizesSubviews(&self) -> bool;

        /// Setter for [`autoresizesSubviews`][Self::autoresizesSubviews].
        #[unsafe(method(setAutoresizesSubviews:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoresizesSubviews(&self, autoresizes_subviews: bool);

        #[unsafe(method(autoresizingMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn autoresizingMask(&self) -> UIViewAutoresizing;

        /// Setter for [`autoresizingMask`][Self::autoresizingMask].
        #[unsafe(method(setAutoresizingMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutoresizingMask(&self, autoresizing_mask: UIViewAutoresizing);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(sizeThatFits:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeThatFits(&self, size: CGSize) -> CGSize;

        #[unsafe(method(sizeToFit))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeToFit(&self);
    );
}

/// UIViewHierarchy.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(superview))]
        #[unsafe(method_family = none)]
        pub fn superview(&self) -> Option<Retained<UIView>>;

        #[unsafe(method(subviews))]
        #[unsafe(method_family = none)]
        pub fn subviews(&self) -> Retained<NSArray<UIView>>;

        #[cfg(feature = "UIWindow")]
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        pub fn window(&self) -> Option<Retained<UIWindow>>;

        #[unsafe(method(removeFromSuperview))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFromSuperview(&self);

        #[unsafe(method(insertSubview:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertSubview_atIndex(&self, view: &UIView, index: NSInteger);

        #[unsafe(method(exchangeSubviewAtIndex:withSubviewAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn exchangeSubviewAtIndex_withSubviewAtIndex(
            &self,
            index1: NSInteger,
            index2: NSInteger,
        );

        #[unsafe(method(addSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSubview(&self, view: &UIView);

        #[unsafe(method(insertSubview:belowSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertSubview_belowSubview(&self, view: &UIView, sibling_subview: &UIView);

        #[unsafe(method(insertSubview:aboveSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertSubview_aboveSubview(&self, view: &UIView, sibling_subview: &UIView);

        #[unsafe(method(bringSubviewToFront:))]
        #[unsafe(method_family = none)]
        pub unsafe fn bringSubviewToFront(&self, view: &UIView);

        #[unsafe(method(sendSubviewToBack:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendSubviewToBack(&self, view: &UIView);

        #[unsafe(method(didAddSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didAddSubview(&self, subview: &UIView);

        #[unsafe(method(willRemoveSubview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willRemoveSubview(&self, subview: &UIView);

        #[unsafe(method(willMoveToSuperview:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willMoveToSuperview(&self, new_superview: Option<&UIView>);

        #[unsafe(method(didMoveToSuperview))]
        #[unsafe(method_family = none)]
        pub unsafe fn didMoveToSuperview(&self);

        #[cfg(feature = "UIWindow")]
        #[unsafe(method(willMoveToWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willMoveToWindow(&self, new_window: Option<&UIWindow>);

        #[unsafe(method(didMoveToWindow))]
        #[unsafe(method_family = none)]
        pub unsafe fn didMoveToWindow(&self);

        #[unsafe(method(isDescendantOfView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDescendantOfView(&self, view: &UIView) -> bool;

        #[unsafe(method(viewWithTag:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWithTag(&self, tag: NSInteger) -> Option<Retained<UIView>>;

        #[unsafe(method(setNeedsLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsLayout(&self);

        #[unsafe(method(layoutIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutIfNeeded(&self);

        #[unsafe(method(layoutSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutSubviews(&self);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(layoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutMargins(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`layoutMargins`][Self::layoutMargins].
        #[unsafe(method(setLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLayoutMargins(&self, layout_margins: UIEdgeInsets);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(directionalLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn directionalLayoutMargins(&self) -> NSDirectionalEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`directionalLayoutMargins`][Self::directionalLayoutMargins].
        #[unsafe(method(setDirectionalLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDirectionalLayoutMargins(
            &self,
            directional_layout_margins: NSDirectionalEdgeInsets,
        );

        #[unsafe(method(preservesSuperviewLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn preservesSuperviewLayoutMargins(&self) -> bool;

        /// Setter for [`preservesSuperviewLayoutMargins`][Self::preservesSuperviewLayoutMargins].
        #[unsafe(method(setPreservesSuperviewLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreservesSuperviewLayoutMargins(
            &self,
            preserves_superview_layout_margins: bool,
        );

        #[unsafe(method(insetsLayoutMarginsFromSafeArea))]
        #[unsafe(method_family = none)]
        pub unsafe fn insetsLayoutMarginsFromSafeArea(&self) -> bool;

        /// Setter for [`insetsLayoutMarginsFromSafeArea`][Self::insetsLayoutMarginsFromSafeArea].
        #[unsafe(method(setInsetsLayoutMarginsFromSafeArea:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInsetsLayoutMarginsFromSafeArea(
            &self,
            insets_layout_margins_from_safe_area: bool,
        );

        #[unsafe(method(layoutMarginsDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutMarginsDidChange(&self);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(safeAreaInsets))]
        #[unsafe(method_family = none)]
        pub fn safeAreaInsets(&self) -> UIEdgeInsets;

        #[unsafe(method(safeAreaInsetsDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn safeAreaInsetsDidChange(&self);

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(layoutMarginsGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutMarginsGuide(&self) -> Retained<UILayoutGuide>;

        #[cfg(feature = "UILayoutGuide")]
        /// This content guide provides a layout area that you can use to place text and related content whose width should generally be constrained to a size that is easy for the user to read. This guide provides a centered region that you can place content within to get this behavior for this view.
        #[unsafe(method(readableContentGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn readableContentGuide(&self) -> Retained<UILayoutGuide>;

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(safeAreaLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn safeAreaLayoutGuide(&self) -> Retained<UILayoutGuide>;

        #[cfg(all(
            feature = "UIKeyboardLayoutGuide",
            feature = "UILayoutGuide",
            feature = "UITrackingLayoutGuide"
        ))]
        /// Follows the keyboard when on screen and docked. See UIKeyboardLayoutGuide.h for additional options.
        #[unsafe(method(keyboardLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyboardLayoutGuide(&self) -> Retained<UIKeyboardLayoutGuide>;
    );
}

/// UIViewRendering.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawRect(&self, rect: CGRect);

        #[unsafe(method(setNeedsDisplay))]
        #[unsafe(method_family = none)]
        pub fn setNeedsDisplay(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setNeedsDisplayInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsDisplayInRect(&self, rect: CGRect);

        #[unsafe(method(clipsToBounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn clipsToBounds(&self) -> bool;

        /// Setter for [`clipsToBounds`][Self::clipsToBounds].
        #[unsafe(method(setClipsToBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClipsToBounds(&self, clips_to_bounds: bool);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn alpha(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alpha`][Self::alpha].
        #[unsafe(method(setAlpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlpha(&self, alpha: CGFloat);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub unsafe fn isOpaque(&self) -> bool;

        /// Setter for [`isOpaque`][Self::isOpaque].
        #[unsafe(method(setOpaque:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOpaque(&self, opaque: bool);

        #[unsafe(method(clearsContextBeforeDrawing))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearsContextBeforeDrawing(&self) -> bool;

        /// Setter for [`clearsContextBeforeDrawing`][Self::clearsContextBeforeDrawing].
        #[unsafe(method(setClearsContextBeforeDrawing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClearsContextBeforeDrawing(&self, clears_context_before_drawing: bool);

        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);

        #[unsafe(method(contentMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentMode(&self) -> UIViewContentMode;

        /// Setter for [`contentMode`][Self::contentMode].
        #[unsafe(method(setContentMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentMode(&self, content_mode: UIViewContentMode);

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated]
        #[unsafe(method(contentStretch))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentStretch(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentStretch`][Self::contentStretch].
        #[deprecated]
        #[unsafe(method(setContentStretch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentStretch(&self, content_stretch: CGRect);

        #[unsafe(method(maskView))]
        #[unsafe(method_family = none)]
        pub unsafe fn maskView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`maskView`][Self::maskView].
        #[unsafe(method(setMaskView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaskView(&self, mask_view: Option<&UIView>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn tintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTintColor(&self, tint_color: Option<&UIColor>);

        #[unsafe(method(tintAdjustmentMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn tintAdjustmentMode(&self) -> UIViewTintAdjustmentMode;

        /// Setter for [`tintAdjustmentMode`][Self::tintAdjustmentMode].
        #[unsafe(method(setTintAdjustmentMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTintAdjustmentMode(&self, tint_adjustment_mode: UIViewTintAdjustmentMode);

        #[unsafe(method(tintColorDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn tintColorDidChange(&self);
    );
}

/// UIViewAnimation.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(setAnimationsEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationsEnabled(enabled: bool, mtm: MainThreadMarker);

        #[unsafe(method(areAnimationsEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn areAnimationsEnabled(mtm: MainThreadMarker) -> bool;

        #[cfg(feature = "block2")]
        #[unsafe(method(performWithoutAnimation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performWithoutAnimation(
            actions_without_animation: &block2::DynBlock<dyn Fn() + '_>,
            mtm: MainThreadMarker,
        );

        #[unsafe(method(inheritedAnimationDuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn inheritedAnimationDuration(mtm: MainThreadMarker) -> NSTimeInterval;
    );
}

/// UIViewAnimationWithBlocks.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "block2")]
        #[unsafe(method(animateWithDuration:delay:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateWithDuration_delay_options_animations_completion(
            duration: NSTimeInterval,
            delay: NSTimeInterval,
            options: UIViewAnimationOptions,
            animations: &block2::DynBlock<dyn Fn()>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(animateWithDuration:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateWithDuration_animations_completion(
            duration: NSTimeInterval,
            animations: &block2::DynBlock<dyn Fn()>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(animateWithDuration:animations:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateWithDuration_animations(
            duration: NSTimeInterval,
            animations: &block2::DynBlock<dyn Fn()>,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(animateWithSpringDuration:bounce:initialSpringVelocity:delay:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateWithSpringDuration_bounce_initialSpringVelocity_delay_options_animations_completion(
            duration: NSTimeInterval,
            bounce: CGFloat,
            velocity: CGFloat,
            delay: NSTimeInterval,
            options: UIViewAnimationOptions,
            animations: &block2::DynBlock<dyn Fn() + '_>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(animateWithDuration:delay:usingSpringWithDamping:initialSpringVelocity:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateWithDuration_delay_usingSpringWithDamping_initialSpringVelocity_options_animations_completion(
            duration: NSTimeInterval,
            delay: NSTimeInterval,
            damping_ratio: CGFloat,
            velocity: CGFloat,
            options: UIViewAnimationOptions,
            animations: &block2::DynBlock<dyn Fn()>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(transitionWithView:duration:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn transitionWithView_duration_options_animations_completion(
            view: &UIView,
            duration: NSTimeInterval,
            options: UIViewAnimationOptions,
            animations: Option<&block2::DynBlock<dyn Fn()>>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(transitionFromView:toView:duration:options:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn transitionFromView_toView_duration_options_completion(
            from_view: &UIView,
            to_view: &UIView,
            duration: NSTimeInterval,
            options: UIViewAnimationOptions,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performSystemAnimation:onViews:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performSystemAnimation_onViews_options_animations_completion(
            animation: UISystemAnimation,
            views: &NSArray<UIView>,
            options: UIViewAnimationOptions,
            parallel_animations: Option<&block2::DynBlock<dyn Fn()>>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        #[unsafe(method(modifyAnimationsWithRepeatCount:autoreverses:animations:))]
        #[unsafe(method_family = none)]
        pub unsafe fn modifyAnimationsWithRepeatCount_autoreverses_animations(
            count: CGFloat,
            autoreverses: bool,
            animations: &block2::DynBlock<dyn Fn() + '_>,
            mtm: MainThreadMarker,
        );
    );
}

/// UIViewKeyframeAnimations.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "block2")]
        #[unsafe(method(animateKeyframesWithDuration:delay:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animateKeyframesWithDuration_delay_options_animations_completion(
            duration: NSTimeInterval,
            delay: NSTimeInterval,
            options: UIViewKeyframeAnimationOptions,
            animations: &block2::DynBlock<dyn Fn()>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
            mtm: MainThreadMarker,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(addKeyframeWithRelativeStartTime:relativeDuration:animations:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addKeyframeWithRelativeStartTime_relativeDuration_animations(
            frame_start_time: c_double,
            frame_duration: c_double,
            animations: &block2::DynBlock<dyn Fn()>,
            mtm: MainThreadMarker,
        );
    );
}

/// UIViewGestureRecognizers.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UIGestureRecognizer")]
        #[unsafe(method(gestureRecognizers))]
        #[unsafe(method_family = none)]
        pub fn gestureRecognizers(&self) -> Option<Retained<NSArray<UIGestureRecognizer>>>;

        #[cfg(feature = "UIGestureRecognizer")]
        /// Setter for [`gestureRecognizers`][Self::gestureRecognizers].
        #[unsafe(method(setGestureRecognizers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setGestureRecognizers(
            &self,
            gesture_recognizers: Option<&NSArray<UIGestureRecognizer>>,
        );

        #[cfg(feature = "UIGestureRecognizer")]
        #[unsafe(method(addGestureRecognizer:))]
        #[unsafe(method_family = none)]
        pub fn addGestureRecognizer(&self, gesture_recognizer: &UIGestureRecognizer);

        #[cfg(feature = "UIGestureRecognizer")]
        #[unsafe(method(removeGestureRecognizer:))]
        #[unsafe(method_family = none)]
        pub fn removeGestureRecognizer(&self, gesture_recognizer: &UIGestureRecognizer);

        #[cfg(feature = "UIGestureRecognizer")]
        #[unsafe(method(gestureRecognizerShouldBegin:))]
        #[unsafe(method_family = none)]
        pub fn gestureRecognizerShouldBegin(
            &self,
            gesture_recognizer: &UIGestureRecognizer,
        ) -> bool;
    );
}

/// UIViewMotionEffects.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UIMotionEffect")]
        /// Begins applying `effect` to the receiver. The effect's emitted keyPath/value pairs will be
        /// applied to the view's presentation layer.
        ///
        /// Animates the transition to the motion effect's values using the present UIView animation
        /// context.
        #[unsafe(method(addMotionEffect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addMotionEffect(&self, effect: &UIMotionEffect);

        #[cfg(feature = "UIMotionEffect")]
        /// Stops applying `effect` to the receiver. Any affected presentation values will animate to
        /// their post-removal values using the present UIView animation context.
        #[unsafe(method(removeMotionEffect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeMotionEffect(&self, effect: &UIMotionEffect);

        #[cfg(feature = "UIMotionEffect")]
        #[unsafe(method(motionEffects))]
        #[unsafe(method_family = none)]
        pub unsafe fn motionEffects(&self) -> Retained<NSArray<UIMotionEffect>>;

        #[cfg(feature = "UIMotionEffect")]
        /// Setter for [`motionEffects`][Self::motionEffects].
        #[unsafe(method(setMotionEffects:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMotionEffects(&self, motion_effects: &NSArray<UIMotionEffect>);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilayoutconstraintaxis?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UILayoutConstraintAxis(pub NSInteger);
impl UILayoutConstraintAxis {
    #[doc(alias = "UILayoutConstraintAxisHorizontal")]
    pub const Horizontal: Self = Self(0);
    #[doc(alias = "UILayoutConstraintAxisVertical")]
    pub const Vertical: Self = Self(1);
}

unsafe impl Encode for UILayoutConstraintAxis {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UILayoutConstraintAxis {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// UIConstraintBasedLayoutInstallingConstraints.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(constraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn constraints(&self) -> Retained<NSArray<NSLayoutConstraint>>;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(addConstraint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addConstraint(&self, constraint: &NSLayoutConstraint);

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(addConstraints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addConstraints(&self, constraints: &NSArray<NSLayoutConstraint>);

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(removeConstraint:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeConstraint(&self, constraint: &NSLayoutConstraint);

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(removeConstraints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeConstraints(&self, constraints: &NSArray<NSLayoutConstraint>);
    );
}

/// UIConstraintBasedLayoutCoreMethods.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(updateConstraintsIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateConstraintsIfNeeded(&self);

        #[unsafe(method(updateConstraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateConstraints(&self);

        #[unsafe(method(needsUpdateConstraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn needsUpdateConstraints(&self) -> bool;

        #[unsafe(method(setNeedsUpdateConstraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUpdateConstraints(&self);
    );
}

/// UIConstraintBasedCompatibility.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(translatesAutoresizingMaskIntoConstraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn translatesAutoresizingMaskIntoConstraints(&self) -> bool;

        /// Setter for [`translatesAutoresizingMaskIntoConstraints`][Self::translatesAutoresizingMaskIntoConstraints].
        #[unsafe(method(setTranslatesAutoresizingMaskIntoConstraints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTranslatesAutoresizingMaskIntoConstraints(
            &self,
            translates_autoresizing_mask_into_constraints: bool,
        );

        #[unsafe(method(requiresConstraintBasedLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn requiresConstraintBasedLayout(mtm: MainThreadMarker) -> bool;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewnointrinsicmetric?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIViewNoIntrinsicMetric: CGFloat;
}

/// UIConstraintBasedLayoutLayering.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alignmentRectForFrame:))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignmentRectForFrame(&self, frame: CGRect) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frameForAlignmentRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameForAlignmentRect(&self, alignment_rect: CGRect) -> CGRect;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(alignmentRectInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignmentRectInsets(&self) -> UIEdgeInsets;

        #[deprecated = "Override -viewForFirstBaselineLayout or -viewForLastBaselineLayout as appropriate, instead"]
        #[unsafe(method(viewForBaselineLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewForBaselineLayout(&self) -> Retained<UIView>;

        #[unsafe(method(viewForFirstBaselineLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewForFirstBaselineLayout(&self) -> Retained<UIView>;

        #[unsafe(method(viewForLastBaselineLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewForLastBaselineLayout(&self) -> Retained<UIView>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(intrinsicContentSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn intrinsicContentSize(&self) -> CGSize;

        #[unsafe(method(invalidateIntrinsicContentSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidateIntrinsicContentSize(&self);

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(contentHuggingPriorityForAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentHuggingPriorityForAxis(
            &self,
            axis: UILayoutConstraintAxis,
        ) -> UILayoutPriority;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(setContentHuggingPriority:forAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentHuggingPriority_forAxis(
            &self,
            priority: UILayoutPriority,
            axis: UILayoutConstraintAxis,
        );

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(contentCompressionResistancePriorityForAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentCompressionResistancePriorityForAxis(
            &self,
            axis: UILayoutConstraintAxis,
        ) -> UILayoutPriority;

        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(setContentCompressionResistancePriority:forAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentCompressionResistancePriority_forAxis(
            &self,
            priority: UILayoutPriority,
            axis: UILayoutConstraintAxis,
        );
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilayoutfittingcompressedsize?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UILayoutFittingCompressedSize: CGSize;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilayoutfittingexpandedsize?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UILayoutFittingExpandedSize: CGSize;
}

/// UIConstraintBasedLayoutFittingSize.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(systemLayoutSizeFittingSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemLayoutSizeFittingSize(&self, target_size: CGSize) -> CGSize;

        #[cfg(all(feature = "NSLayoutConstraint", feature = "objc2-core-foundation"))]
        #[unsafe(method(systemLayoutSizeFittingSize:withHorizontalFittingPriority:verticalFittingPriority:))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemLayoutSizeFittingSize_withHorizontalFittingPriority_verticalFittingPriority(
            &self,
            target_size: CGSize,
            horizontal_fitting_priority: UILayoutPriority,
            vertical_fitting_priority: UILayoutPriority,
        ) -> CGSize;
    );
}

/// UILayoutGuideSupport.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(layoutGuides))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutGuides(&self) -> Retained<NSArray<UILayoutGuide>>;

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(addLayoutGuide:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addLayoutGuide(&self, layout_guide: &UILayoutGuide);

        #[cfg(feature = "UILayoutGuide")]
        #[unsafe(method(removeLayoutGuide:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeLayoutGuide(&self, layout_guide: &UILayoutGuide);
    );
}

/// UIViewLayoutConstraintCreation.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(leadingAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn leadingAnchor(&self) -> Retained<NSLayoutXAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(trailingAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn trailingAnchor(&self) -> Retained<NSLayoutXAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(leftAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn leftAnchor(&self) -> Retained<NSLayoutXAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(rightAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn rightAnchor(&self) -> Retained<NSLayoutXAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(topAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn topAnchor(&self) -> Retained<NSLayoutYAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(bottomAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomAnchor(&self) -> Retained<NSLayoutYAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(widthAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn widthAnchor(&self) -> Retained<NSLayoutDimension>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(heightAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn heightAnchor(&self) -> Retained<NSLayoutDimension>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(centerXAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn centerXAnchor(&self) -> Retained<NSLayoutXAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(centerYAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn centerYAnchor(&self) -> Retained<NSLayoutYAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(firstBaselineAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn firstBaselineAnchor(&self) -> Retained<NSLayoutYAxisAnchor>;

        #[cfg(feature = "NSLayoutAnchor")]
        #[unsafe(method(lastBaselineAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn lastBaselineAnchor(&self) -> Retained<NSLayoutYAxisAnchor>;
    );
}

/// UIConstraintBasedLayoutDebugging.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(constraintsAffectingLayoutForAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn constraintsAffectingLayoutForAxis(
            &self,
            axis: UILayoutConstraintAxis,
        ) -> Retained<NSArray<NSLayoutConstraint>>;

        #[unsafe(method(hasAmbiguousLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAmbiguousLayout(&self) -> bool;

        #[unsafe(method(exerciseAmbiguityInLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn exerciseAmbiguityInLayout(&self);
    );
}

/// UIConstraintBasedLayoutDebugging.
#[cfg(feature = "UILayoutGuide")]
impl UILayoutGuide {
    extern_methods!(
        #[cfg(feature = "NSLayoutConstraint")]
        #[unsafe(method(constraintsAffectingLayoutForAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn constraintsAffectingLayoutForAxis(
            &self,
            axis: UILayoutConstraintAxis,
        ) -> Retained<NSArray<NSLayoutConstraint>>;

        #[unsafe(method(hasAmbiguousLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasAmbiguousLayout(&self) -> bool;
    );
}

/// UIStateRestoration.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(restorationIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn restorationIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`restorationIdentifier`][Self::restorationIdentifier].
        #[unsafe(method(setRestorationIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRestorationIdentifier(&self, restoration_identifier: Option<&NSString>);

        #[unsafe(method(encodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder(&self, coder: &NSCoder);

        #[unsafe(method(decodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeRestorableStateWithCoder(&self, coder: &NSCoder);
    );
}

/// UISnapshotting.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[unsafe(method(snapshotViewAfterScreenUpdates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn snapshotViewAfterScreenUpdates(
            &self,
            after_updates: bool,
        ) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(resizableSnapshotViewFromRect:afterScreenUpdates:withCapInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizableSnapshotViewFromRect_afterScreenUpdates_withCapInsets(
            &self,
            rect: CGRect,
            after_updates: bool,
            cap_insets: UIEdgeInsets,
        ) -> Option<Retained<UIView>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(drawViewHierarchyInRect:afterScreenUpdates:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawViewHierarchyInRect_afterScreenUpdates(
            &self,
            rect: CGRect,
            after_updates: bool,
        ) -> bool;
    );
}

/// DeprecatedAnimations.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(beginAnimations:context:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginAnimations_context(
            animation_id: Option<&NSString>,
            context: *mut c_void,
            mtm: MainThreadMarker,
        );

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(commitAnimations))]
        #[unsafe(method_family = none)]
        pub unsafe fn commitAnimations(mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationDelegate(delegate: Option<&AnyObject>, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationWillStartSelector:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationWillStartSelector(selector: Option<Sel>, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationDidStopSelector:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationDidStopSelector(selector: Option<Sel>, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationDuration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationDuration(duration: NSTimeInterval, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationDelay:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationDelay(delay: NSTimeInterval, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationStartDate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationStartDate(start_date: &NSDate, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationCurve:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationCurve(curve: UIViewAnimationCurve, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationRepeatCount:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationRepeatCount(repeat_count: c_float, mtm: MainThreadMarker);

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationRepeatAutoreverses:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationRepeatAutoreverses(
            repeat_autoreverses: bool,
            mtm: MainThreadMarker,
        );

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationBeginsFromCurrentState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationBeginsFromCurrentState(
            from_current_state: bool,
            mtm: MainThreadMarker,
        );

        #[deprecated = "Use the block-based animation API instead"]
        #[unsafe(method(setAnimationTransition:forView:cache:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationTransition_forView_cache(
            transition: UIViewAnimationTransition,
            view: &UIView,
            cache: bool,
        );
    );
}

/// UserInterfaceStyle.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UIInterface")]
        #[unsafe(method(overrideUserInterfaceStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn overrideUserInterfaceStyle(&self) -> UIUserInterfaceStyle;

        #[cfg(feature = "UIInterface")]
        /// Setter for [`overrideUserInterfaceStyle`][Self::overrideUserInterfaceStyle].
        #[unsafe(method(setOverrideUserInterfaceStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOverrideUserInterfaceStyle(
            &self,
            override_user_interface_style: UIUserInterfaceStyle,
        );
    );
}

/// UIContentSizeCategoryLimit.
#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UIContentSizeCategory")]
        /// Specify content size category limits. Setting one or both of these properties will limit the
        /// content size category for this view (and its subviews) to a minimum or a maximum value.
        /// You can use this to limit the support content size categories on part of your view hierarchy.
        /// Setting this to nil removes the limit on the minimum or maximum.
        /// Limits will be applied immediately and when future content size category updates occur.
        ///
        /// Specifying a minimum limit that is greater than the maximum limit (or vice versa) will effectively
        /// only use the maximum limit.
        ///
        /// Example:
        ///
        /// // limit the support content size categories between .medium and .accessibilityExtraLarge (included).
        /// view.minimumContentSizeCategory = UIContentSizeCategoryMedium;
        /// view.maximumContentSizeCategory = UIContentSizeCategoryAccessibilityExtraLarge;
        #[unsafe(method(minimumContentSizeCategory))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumContentSizeCategory(&self) -> Option<Retained<UIContentSizeCategory>>;

        #[cfg(feature = "UIContentSizeCategory")]
        /// Setter for [`minimumContentSizeCategory`][Self::minimumContentSizeCategory].
        #[unsafe(method(setMinimumContentSizeCategory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMinimumContentSizeCategory(
            &self,
            minimum_content_size_category: Option<&UIContentSizeCategory>,
        );

        #[cfg(feature = "UIContentSizeCategory")]
        #[unsafe(method(maximumContentSizeCategory))]
        #[unsafe(method_family = none)]
        pub unsafe fn maximumContentSizeCategory(&self) -> Option<Retained<UIContentSizeCategory>>;

        #[cfg(feature = "UIContentSizeCategory")]
        /// Setter for [`maximumContentSizeCategory`][Self::maximumContentSizeCategory].
        #[unsafe(method(setMaximumContentSizeCategory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaximumContentSizeCategory(
            &self,
            maximum_content_size_category: Option<&UIContentSizeCategory>,
        );

        /// Will return a string with a log of all the superviews of this view, alongside with what
        /// content size category each view has and if that view has limits applied.
        /// This is for debugging purposes only.
        #[unsafe(method(appliedContentSizeCategoryLimitsDescription))]
        #[unsafe(method_family = none)]
        pub unsafe fn appliedContentSizeCategoryLimitsDescription(&self) -> Retained<NSString>;
    );
}

#[cfg(feature = "UIResponder")]
impl UIView {
    extern_methods!(
        #[cfg(feature = "UITraitCollection")]
        #[unsafe(method(traitOverrides))]
        #[unsafe(method_family = none)]
        pub unsafe fn traitOverrides(&self) -> Retained<ProtocolObject<dyn UITraitOverrides>>;

        /// Forces an immediate trait update for this view (and its view controller, if applicable) and any subviews,
        /// including any view controllers or views in its subtree. Any trait change callbacks are sent synchronously.
        #[unsafe(method(updateTraitsIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateTraitsIfNeeded(&self);
    );
}

#[cfg(all(feature = "UIResponder", feature = "UITraitCollection"))]
extern_conformance!(
    unsafe impl UITraitChangeObservable for UIView {}
);
