//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Controls the acceleration structure refit operation
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlaccelerationstructurerefitoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLAccelerationStructureRefitOptions(pub NSUInteger);
bitflags::bitflags! {
    impl MTLAccelerationStructureRefitOptions: NSUInteger {
/// Refitting shall result in updated vertex data from the provided geometry descriptor.
/// If not set, vertex buffers shall be ignored on the geometry descriptor and vertex data previously
/// encoded shall be copied.
        #[doc(alias = "MTLAccelerationStructureRefitOptionVertexData")]
        const VertexData = 1<<0;
/// Refitting shall result in updated per primitive data from the provided geometry descriptor.
/// If not set, per primitive data buffers shall be ignored on the geometry descriptor and per primitive
/// data previously encoded shall be copied.
        #[doc(alias = "MTLAccelerationStructureRefitOptionPerPrimitiveData")]
        const PerPrimitiveData = 1<<1;
    }
}

unsafe impl Encode for MTLAccelerationStructureRefitOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLAccelerationStructureRefitOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlaccelerationstructurecommandencoder?language=objc)
    #[cfg(feature = "MTLCommandEncoder")]
    pub unsafe trait MTLAccelerationStructureCommandEncoder: MTLCommandEncoder {
        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Encode an acceleration structure build into the command buffer. All bottom-level acceleration
        /// structure builds must have completed before a top-level acceleration structure build may begin. The
        /// resulting acceleration structure will not retain any references to the input vertex buffer, instance buffer, etc.
        ///
        /// The acceleration structure build will not be completed until the command buffer has been committed
        /// and finished executing. However, it is safe to encode ray tracing work against the acceleration
        /// structure as long as the command buffers are scheduled and synchronized such that the command buffer
        /// will have completed by the time the ray tracing starts.
        ///
        /// The acceleration structure and scratch buffer must be at least the size returned by the
        /// [MTLDevice accelerationStructureSizesWithDescriptor:] query.
        ///
        ///
        /// Parameter `accelerationStructure`: Acceleration structure storage to build into
        ///
        /// Parameter `descriptor`: Object describing the acceleration structure to build
        ///
        /// Parameter `scratchBuffer`: Scratch buffer to use while building the acceleration structure. The
        /// contents may be overwritten and are undefined after the build has
        /// started/completed.
        ///
        /// Parameter `scratchBufferOffset`: Offset into the scratch buffer
        #[unsafe(method(buildAccelerationStructure:descriptor:scratchBuffer:scratchBufferOffset:))]
        #[unsafe(method_family = none)]
        fn buildAccelerationStructure_descriptor_scratchBuffer_scratchBufferOffset(
            &self,
            acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            descriptor: &MTLAccelerationStructureDescriptor,
            scratch_buffer: &ProtocolObject<dyn MTLBuffer>,
            scratch_buffer_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Encode an acceleration structure refit into the command buffer. Refitting can be used to
        /// update the acceleration structure when geometry changes and is much faster than rebuilding from
        /// scratch. However, the quality of the acceleration structure and the subsequent ray tracing
        /// performance will degrade depending on how much the geometry changes.
        ///
        /// Refitting can not be used after certain changes, such as adding or removing geometry. Acceleration
        /// structures can be refit in place by specifying the same source and destination acceleration structures
        /// or by providing a nil destination acceleration structure. If the source and destination acceleration
        /// structures are not the same, they must not overlap in memory.
        ///
        /// The destination acceleration structure must be at least as large as the source acceleration structure,
        /// unless the source acceleration structure has been compacted, in which case the destination acceleration
        /// structure must be at least as large as the compacted size of the source acceleration structure.
        ///
        /// The scratch buffer must be at least the size returned by the accelerationStructureSizesWithDescriptor
        /// method of the MTLDevice.
        ///
        ///
        /// Parameter `descriptor`: Object describing the acceleration structure to build
        ///
        /// Parameter `sourceAccelerationStructure`: Acceleration structure to copy from
        ///
        /// Parameter `destinationAccelerationStructure`: Acceleration structure to copy to
        ///
        /// Parameter `scratchBuffer`: Scratch buffer to use while refitting the acceleration
        /// structure. The contents may be overwritten and are undefined
        /// after the refit has started/completed.
        ///
        /// Parameter `scratchBufferOffset`: Offset into the scratch buffer.
        #[unsafe(method(refitAccelerationStructure:descriptor:destination:scratchBuffer:scratchBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn refitAccelerationStructure_descriptor_destination_scratchBuffer_scratchBufferOffset(
            &self,
            source_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            descriptor: &MTLAccelerationStructureDescriptor,
            destination_acceleration_structure: Option<
                &ProtocolObject<dyn MTLAccelerationStructure>,
            >,
            scratch_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            scratch_buffer_offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Encode an acceleration structure refit into the command buffer. Refitting can be used to
        /// update the acceleration structure when geometry changes and is much faster than rebuilding from
        /// scratch. However, the quality of the acceleration structure and the subsequent ray tracing
        /// performance will degrade depending on how much the geometry changes.
        ///
        /// Refitting can not be used after certain changes, such as adding or removing geometry. Acceleration
        /// structures can be refit in place by specifying the same source and destination acceleration structures
        /// or by providing a nil destination acceleration structure. If the source and destination acceleration
        /// structures are not the same, they must not overlap in memory.
        ///
        /// The destination acceleration structure must be at least as large as the source acceleration structure,
        /// unless the source acceleration structure has been compacted, in which case the destination acceleration
        /// structure must be at least as large as the compacted size of the source acceleration structure.
        ///
        /// The scratch buffer must be at least the size returned by the accelerationStructureSizesWithDescriptor
        /// method of the MTLDevice.
        ///
        ///
        /// Parameter `descriptor`: Object describing the acceleration structure to build
        ///
        /// Parameter `sourceAccelerationStructure`: Acceleration structure to copy from
        ///
        /// Parameter `destinationAccelerationStructure`: Acceleration structure to copy to
        ///
        /// Parameter `scratchBuffer`: Scratch buffer to use while refitting the acceleration
        /// structure. The contents may be overwritten and are undefined
        /// after the refit has started/completed.
        ///
        /// Parameter `scratchBufferOffset`: Offset into the scratch buffer.
        ///
        /// Parameter `options`: Options specifying the elements of the acceleration structure to refit.
        #[unsafe(method(refitAccelerationStructure:descriptor:destination:scratchBuffer:scratchBufferOffset:options:))]
        #[unsafe(method_family = none)]
        unsafe fn refitAccelerationStructure_descriptor_destination_scratchBuffer_scratchBufferOffset_options(
            &self,
            source_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            descriptor: &MTLAccelerationStructureDescriptor,
            destination_acceleration_structure: Option<
                &ProtocolObject<dyn MTLAccelerationStructure>,
            >,
            scratch_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
            scratch_buffer_offset: NSUInteger,
            options: MTLAccelerationStructureRefitOptions,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Copy an acceleration structure. The source and destination acceleration structures must not
        /// overlap in memory. If this is a top level acceleration structure, references to bottom level
        /// acceleration structures will be preserved.
        ///
        /// The destination acceleration structure must be at least as large as the source acceleration structure,
        /// unless the source acceleration structure has been compacted, in which case the destination acceleration
        /// structure must be at least as large as the compacted size of the source acceleration structure.
        ///
        ///
        /// Parameter `sourceAccelerationStructure`: Acceleration structure to copy from
        ///
        /// Parameter `destinationAccelerationStructure`: Acceleration structure to copy to
        #[unsafe(method(copyAccelerationStructure:toAccelerationStructure:))]
        #[unsafe(method_family = none)]
        unsafe fn copyAccelerationStructure_toAccelerationStructure(
            &self,
            source_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            destination_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Compute the compacted size for an acceleration structure and write it into a buffer.
        ///
        /// This size is potentially smaller than the source acceleration structure. To perform compaction,
        /// read this size from the buffer once the command buffer has completed and use it to allocate a
        /// smaller acceleration structure. Then create another encoder and call the
        /// copyAndCompactAccelerationStructure method.
        ///
        ///
        /// Parameter `accelerationStructure`: Source acceleration structure
        ///
        /// Parameter `buffer`: Destination size buffer. The compacted size will be written as a 32 bit
        /// unsigned integer representing the compacted size in bytes.
        ///
        /// Parameter `offset`: Offset into the size buffer
        #[unsafe(method(writeCompactedAccelerationStructureSize:toBuffer:offset:))]
        #[unsafe(method_family = none)]
        fn writeCompactedAccelerationStructureSize_toBuffer_offset(
            &self,
            acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            offset: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLArgument",
            feature = "MTLBuffer",
            feature = "MTLResource"
        ))]
        /// Compute the compacted size for an acceleration structure and write it into a buffer.
        ///
        /// This size is potentially smaller than the source acceleration structure. To perform compaction,
        /// read this size from the buffer once the command buffer has completed and use it to allocate a
        /// smaller acceleration structure. Then create another encoder and call the
        /// copyAndCompactAccelerationStructure method.
        ///
        ///
        /// Parameter `accelerationStructure`: Source acceleration structure
        ///
        /// Parameter `buffer`: Destination size buffer. The compacted size will be written as either
        /// a 32 bit or 64 bit value depending on the sizeDataType argument
        /// unsigned integer representing the compacted size in bytes.
        ///
        /// Parameter `offset`: Offset into the size buffer
        ///
        /// Parameter `sizeDataType`: Data type of the size to write into the buffer. Must be either
        /// MTLDataTypeUInt (32 bit) or MTLDataTypeULong (64 bit)
        #[unsafe(method(writeCompactedAccelerationStructureSize:toBuffer:offset:sizeDataType:))]
        #[unsafe(method_family = none)]
        unsafe fn writeCompactedAccelerationStructureSize_toBuffer_offset_sizeDataType(
            &self,
            acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            buffer: &ProtocolObject<dyn MTLBuffer>,
            offset: NSUInteger,
            size_data_type: MTLDataType,
        );

        #[cfg(all(
            feature = "MTLAccelerationStructure",
            feature = "MTLAllocation",
            feature = "MTLResource"
        ))]
        /// Copy and compact an acceleration structure. The source and destination acceleration structures
        /// must not overlap in memory. If this is a top level acceleration structure, references to bottom level
        /// acceleration structures will be preserved.
        ///
        /// The destination acceleration structure must be at least as large as the compacted size of the source
        /// acceleration structure, which is computed by the writeCompactedAccelerationStructureSize method.
        ///
        ///
        /// Parameter `sourceAccelerationStructure`: Acceleration structure to copy and compact
        ///
        /// Parameter `destinationAccelerationStructure`: Acceleration structure to copy to
        #[unsafe(method(copyAndCompactAccelerationStructure:toAccelerationStructure:))]
        #[unsafe(method_family = none)]
        fn copyAndCompactAccelerationStructure_toAccelerationStructure(
            &self,
            source_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
            destination_acceleration_structure: &ProtocolObject<dyn MTLAccelerationStructure>,
        );

        #[cfg(feature = "MTLFence")]
        /// Update the fence to capture all GPU work so far enqueued by this encoder.
        ///
        /// The fence is updated at build submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(updateFence:))]
        #[unsafe(method_family = none)]
        unsafe fn updateFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(feature = "MTLFence")]
        /// Prevent further GPU work until the fence is reached.
        ///
        /// The fence is evaluated at build submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[unsafe(method(waitForFence:))]
        #[unsafe(method_family = none)]
        unsafe fn waitForFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that a resource may be accessed by the command encoder through an argument buffer
        ///
        ///
        /// For tracked MTLResources, this method protects against data hazards. This method must be called before encoding any acceleration structure commands which may access the resource through an argument buffer.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useResource:usage:))]
        #[unsafe(method_family = none)]
        unsafe fn useResource_usage(
            &self,
            resource: &ProtocolObject<dyn MTLResource>,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLResource"))]
        /// Declare that an array of resources may be accessed through an argument buffer by the command encoder
        ///
        /// For tracked MTL Resources, this method protects against data hazards. This method must be called before encoding any acceleration structure commands which may access the resources through an argument buffer.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useResources:count:usage:))]
        #[unsafe(method_family = none)]
        unsafe fn useResources_count_usage(
            &self,
            resources: NonNull<NonNull<ProtocolObject<dyn MTLResource>>>,
            count: NSUInteger,
            usage: MTLResourceUsage,
        );

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from a heap may be accessed as readonly by the encoder through an argument buffer
        ///
        /// For tracked MTLHeaps, this method protects against data hazards. This method must be called before encoding any acceleration structure commands which may access the resources allocated from the heap through an argument buffer. This method may cause all of the color attachments allocated from the heap to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useHeap:))]
        #[unsafe(method_family = none)]
        unsafe fn useHeap(&self, heap: &ProtocolObject<dyn MTLHeap>);

        #[cfg(all(feature = "MTLAllocation", feature = "MTLHeap"))]
        /// Declare that the resources allocated from an array of heaps may be accessed as readonly by the encoder through an argument buffer
        ///
        /// For tracked MTLHeaps, this method protects against data hazards. This method must be called before encoding any acceleration structure commands which may access the resources allocated from the heaps through an argument buffer. This method may cause all of the color attachments allocated from the heaps to become decompressed. Therefore, it is recommended that the useResource:usage: or useResources:count:usage: methods be used for color attachments instead, with a minimal (i.e. read-only) usage.
        ///
        /// Warning: Prior to iOS 13, macOS 10.15, this method does not protect against data hazards. If you are deploying to older versions of macOS or iOS, use fences to ensure data hazards are resolved.
        #[unsafe(method(useHeaps:count:))]
        #[unsafe(method_family = none)]
        unsafe fn useHeaps_count(
            &self,
            heaps: NonNull<NonNull<ProtocolObject<dyn MTLHeap>>>,
            count: NSUInteger,
        );

        #[cfg(feature = "MTLCounters")]
        /// Sample hardware counters at this point in the acceleration structure
        /// encoder and store the counter sample into the sample buffer at the specified index.
        ///
        /// Parameter `sampleBuffer`: The sample buffer to sample into
        ///
        /// Parameter `sampleIndex`: The index into the counter buffer to write the sample
        ///
        /// Parameter `barrier`: Insert a barrier before taking the sample.  Passing
        /// YES will ensure that all work encoded before this operation in the encoder is
        /// complete but does not isolate the work with respect to other encoders.  Passing
        /// NO will allow the sample to be taken concurrently with other operations in this
        /// encoder.
        /// In general, passing YES will lead to more repeatable counter results but
        /// may negatively impact performance.  Passing NO will generally be higher performance
        /// but counter results may not be repeatable.
        #[unsafe(method(sampleCountersInBuffer:atSampleIndex:withBarrier:))]
        #[unsafe(method_family = none)]
        unsafe fn sampleCountersInBuffer_atSampleIndex_withBarrier(
            &self,
            sample_buffer: &ProtocolObject<dyn MTLCounterSampleBuffer>,
            sample_index: NSUInteger,
            barrier: bool,
        );
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlaccelerationstructurepasssamplebufferattachmentdescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructurePassSampleBufferAttachmentDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLAccelerationStructurePassSampleBufferAttachmentDescriptor {}
);

unsafe impl CopyingHelper for MTLAccelerationStructurePassSampleBufferAttachmentDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLAccelerationStructurePassSampleBufferAttachmentDescriptor {}
);

impl MTLAccelerationStructurePassSampleBufferAttachmentDescriptor {
    extern_methods!(
        #[cfg(feature = "MTLCounters")]
        /// The sample buffer to store samples for the acceleration structure pass defined samples.
        /// If sampleBuffer is non-nil, the sample indices will be used to store samples into
        /// the sample buffer.  If no sample buffer is provided, no samples will be taken.
        /// If any of the sample indices are specified as MTLCounterDontSample, no sample
        /// will be taken for that action.
        #[unsafe(method(sampleBuffer))]
        #[unsafe(method_family = none)]
        pub unsafe fn sampleBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLCounterSampleBuffer>>>;

        #[cfg(feature = "MTLCounters")]
        /// Setter for [`sampleBuffer`][Self::sampleBuffer].
        #[unsafe(method(setSampleBuffer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSampleBuffer(
            &self,
            sample_buffer: Option<&ProtocolObject<dyn MTLCounterSampleBuffer>>,
        );

        /// The sample index to use to store the sample taken at the start of
        /// command encoder processing.  Setting the value to MTLCounterDontSample will cause
        /// this sample to be omitted.
        ///
        /// On devices where MTLCounterSamplingPointAtStageBoundary is unsupported,
        /// this sample index is invalid and must be set to MTLCounterDontSample or creation of an
        /// acceleration structure pass will fail.
        #[unsafe(method(startOfEncoderSampleIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn startOfEncoderSampleIndex(&self) -> NSUInteger;

        /// Setter for [`startOfEncoderSampleIndex`][Self::startOfEncoderSampleIndex].
        #[unsafe(method(setStartOfEncoderSampleIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStartOfEncoderSampleIndex(
            &self,
            start_of_encoder_sample_index: NSUInteger,
        );

        /// The sample index to use to store the sample taken at the end of
        /// command encoder processing.  Setting the value to MTLCounterDontSample will cause
        /// this sample to be omitted.
        ///
        /// On devices where MTLCounterSamplingPointAtStageBoundary is unsupported,
        /// this sample index is invalid and must be set to MTLCounterDontSample or creation of an
        /// acceleration structure pass will fail.
        #[unsafe(method(endOfEncoderSampleIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn endOfEncoderSampleIndex(&self) -> NSUInteger;

        /// Setter for [`endOfEncoderSampleIndex`][Self::endOfEncoderSampleIndex].
        #[unsafe(method(setEndOfEncoderSampleIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEndOfEncoderSampleIndex(&self, end_of_encoder_sample_index: NSUInteger);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLAccelerationStructurePassSampleBufferAttachmentDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlaccelerationstructurepasssamplebufferattachmentdescriptorarray?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructurePassSampleBufferAttachmentDescriptorArray;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLAccelerationStructurePassSampleBufferAttachmentDescriptorArray {}
);

impl MTLAccelerationStructurePassSampleBufferAttachmentDescriptorArray {
    extern_methods!(
        #[unsafe(method(objectAtIndexedSubscript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn objectAtIndexedSubscript(
            &self,
            attachment_index: NSUInteger,
        ) -> Retained<MTLAccelerationStructurePassSampleBufferAttachmentDescriptor>;

        #[unsafe(method(setObject:atIndexedSubscript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObject_atIndexedSubscript(
            &self,
            attachment: Option<&MTLAccelerationStructurePassSampleBufferAttachmentDescriptor>,
            attachment_index: NSUInteger,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLAccelerationStructurePassSampleBufferAttachmentDescriptorArray {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// MTLAccelerationStructurePassDescriptor represents a collection of attachments to be used to create a concrete acceleration structure encoder.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlaccelerationstructurepassdescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructurePassDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLAccelerationStructurePassDescriptor {}
);

unsafe impl CopyingHelper for MTLAccelerationStructurePassDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLAccelerationStructurePassDescriptor {}
);

impl MTLAccelerationStructurePassDescriptor {
    extern_methods!(
        /// Create an autoreleased default acceleration structure pass descriptor
        #[unsafe(method(accelerationStructurePassDescriptor))]
        #[unsafe(method_family = none)]
        pub unsafe fn accelerationStructurePassDescriptor(
        ) -> Retained<MTLAccelerationStructurePassDescriptor>;

        /// An array of sample buffers and associated sample indices.
        #[unsafe(method(sampleBufferAttachments))]
        #[unsafe(method_family = none)]
        pub unsafe fn sampleBufferAttachments(
            &self,
        ) -> Retained<MTLAccelerationStructurePassSampleBufferAttachmentDescriptorArray>;
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLAccelerationStructurePassDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
