//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatterkey?language=objc)
// NS_TYPED_ENUM
pub type CFDateFormatterKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatter?language=objc)
#[doc(alias = "CFDateFormatterRef")]
#[repr(C)]
pub struct CFDateFormatter {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFDateFormatter {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFDateFormatter"> for CFDateFormatter {}
);

impl CFDateFormatter {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `tmplate` might not allow `None`.
    /// - `locale` might not allow `None`.
    #[doc(alias = "CFDateFormatterCreateDateFormatFromTemplate")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub unsafe fn new_date_format_from_template(
        allocator: Option<&CFAllocator>,
        tmplate: Option<&CFString>,
        options: CFOptionFlags,
        locale: Option<&CFLocale>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFDateFormatterCreateDateFormatFromTemplate(
                allocator: Option<&CFAllocator>,
                tmplate: Option<&CFString>,
                options: CFOptionFlags,
                locale: Option<&CFLocale>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe {
            CFDateFormatterCreateDateFormatFromTemplate(allocator, tmplate, options, locale)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

unsafe impl ConcreteType for CFDateFormatter {
    #[doc(alias = "CFDateFormatterGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFDateFormatterGetTypeID() -> CFTypeID;
        }
        unsafe { CFDateFormatterGetTypeID() }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdateformatterstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFDateFormatterStyle(pub CFIndex);
impl CFDateFormatterStyle {
    #[doc(alias = "kCFDateFormatterNoStyle")]
    pub const NoStyle: Self = Self(0);
    #[doc(alias = "kCFDateFormatterShortStyle")]
    pub const ShortStyle: Self = Self(1);
    #[doc(alias = "kCFDateFormatterMediumStyle")]
    pub const MediumStyle: Self = Self(2);
    #[doc(alias = "kCFDateFormatterLongStyle")]
    pub const LongStyle: Self = Self(3);
    #[doc(alias = "kCFDateFormatterFullStyle")]
    pub const FullStyle: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFDateFormatterStyle {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFDateFormatterStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfiso8601dateformatoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFISO8601DateFormatOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFISO8601DateFormatOptions: CFOptionFlags {
        #[doc(alias = "kCFISO8601DateFormatWithYear")]
        const WithYear = 1<<0;
        #[doc(alias = "kCFISO8601DateFormatWithMonth")]
        const WithMonth = 1<<1;
        #[doc(alias = "kCFISO8601DateFormatWithWeekOfYear")]
        const WithWeekOfYear = 1<<2;
        #[doc(alias = "kCFISO8601DateFormatWithDay")]
        const WithDay = 1<<4;
        #[doc(alias = "kCFISO8601DateFormatWithTime")]
        const WithTime = 1<<5;
        #[doc(alias = "kCFISO8601DateFormatWithTimeZone")]
        const WithTimeZone = 1<<6;
        #[doc(alias = "kCFISO8601DateFormatWithSpaceBetweenDateAndTime")]
        const WithSpaceBetweenDateAndTime = 1<<7;
        #[doc(alias = "kCFISO8601DateFormatWithDashSeparatorInDate")]
        const WithDashSeparatorInDate = 1<<8;
        #[doc(alias = "kCFISO8601DateFormatWithColonSeparatorInTime")]
        const WithColonSeparatorInTime = 1<<9;
        #[doc(alias = "kCFISO8601DateFormatWithColonSeparatorInTimeZone")]
        const WithColonSeparatorInTimeZone = 1<<10;
        #[doc(alias = "kCFISO8601DateFormatWithFractionalSeconds")]
        const WithFractionalSeconds = 1<<11;
        #[doc(alias = "kCFISO8601DateFormatWithFullDate")]
        const WithFullDate = CFISO8601DateFormatOptions::WithYear.0|CFISO8601DateFormatOptions::WithMonth.0|CFISO8601DateFormatOptions::WithDay.0|CFISO8601DateFormatOptions::WithDashSeparatorInDate.0;
        #[doc(alias = "kCFISO8601DateFormatWithFullTime")]
        const WithFullTime = CFISO8601DateFormatOptions::WithTime.0|CFISO8601DateFormatOptions::WithColonSeparatorInTime.0|CFISO8601DateFormatOptions::WithTimeZone.0|CFISO8601DateFormatOptions::WithColonSeparatorInTimeZone.0;
        #[doc(alias = "kCFISO8601DateFormatWithInternetDateTime")]
        const WithInternetDateTime = CFISO8601DateFormatOptions::WithFullDate.0|CFISO8601DateFormatOptions::WithFullTime.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFISO8601DateFormatOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFISO8601DateFormatOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFDateFormatter {
    /// # Safety
    ///
    /// `allocator` might not allow `None`.
    #[doc(alias = "CFDateFormatterCreateISO8601Formatter")]
    #[inline]
    pub unsafe fn new_iso_8601_formatter(
        allocator: Option<&CFAllocator>,
        format_options: CFISO8601DateFormatOptions,
    ) -> Option<CFRetained<CFDateFormatter>> {
        extern "C-unwind" {
            fn CFDateFormatterCreateISO8601Formatter(
                allocator: Option<&CFAllocator>,
                format_options: CFISO8601DateFormatOptions,
            ) -> Option<NonNull<CFDateFormatter>>;
        }
        let ret = unsafe { CFDateFormatterCreateISO8601Formatter(allocator, format_options) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `locale` might not allow `None`.
    #[doc(alias = "CFDateFormatterCreate")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        locale: Option<&CFLocale>,
        date_style: CFDateFormatterStyle,
        time_style: CFDateFormatterStyle,
    ) -> Option<CFRetained<CFDateFormatter>> {
        extern "C-unwind" {
            fn CFDateFormatterCreate(
                allocator: Option<&CFAllocator>,
                locale: Option<&CFLocale>,
                date_style: CFDateFormatterStyle,
                time_style: CFDateFormatterStyle,
            ) -> Option<NonNull<CFDateFormatter>>;
        }
        let ret = unsafe { CFDateFormatterCreate(allocator, locale, date_style, time_style) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFDateFormatterGetLocale")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub fn locale(&self) -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFDateFormatterGetLocale(formatter: &CFDateFormatter) -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFDateFormatterGetLocale(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFDateFormatterGetDateStyle")]
    #[inline]
    pub fn date_style(&self) -> CFDateFormatterStyle {
        extern "C-unwind" {
            fn CFDateFormatterGetDateStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
        }
        unsafe { CFDateFormatterGetDateStyle(self) }
    }

    #[doc(alias = "CFDateFormatterGetTimeStyle")]
    #[inline]
    pub fn time_style(&self) -> CFDateFormatterStyle {
        extern "C-unwind" {
            fn CFDateFormatterGetTimeStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
        }
        unsafe { CFDateFormatterGetTimeStyle(self) }
    }

    #[doc(alias = "CFDateFormatterGetFormat")]
    #[inline]
    pub fn format(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFDateFormatterGetFormat(formatter: &CFDateFormatter) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFDateFormatterGetFormat(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// # Safety
    ///
    /// `format_string` might not allow `None`.
    #[doc(alias = "CFDateFormatterSetFormat")]
    #[inline]
    pub unsafe fn set_format(&self, format_string: Option<&CFString>) {
        extern "C-unwind" {
            fn CFDateFormatterSetFormat(
                formatter: &CFDateFormatter,
                format_string: Option<&CFString>,
            );
        }
        unsafe { CFDateFormatterSetFormat(self, format_string) }
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `formatter` might not allow `None`.
    /// - `date` might not allow `None`.
    #[doc(alias = "CFDateFormatterCreateStringWithDate")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn new_string_with_date(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFDateFormatter>,
        date: Option<&CFDate>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFDateFormatterCreateStringWithDate(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFDateFormatter>,
                date: Option<&CFDate>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFDateFormatterCreateStringWithDate(allocator, formatter, date) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `formatter` might not allow `None`.
    #[doc(alias = "CFDateFormatterCreateStringWithAbsoluteTime")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn new_string_with_absolute_time(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFDateFormatter>,
        at: CFAbsoluteTime,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFDateFormatterCreateStringWithAbsoluteTime(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFDateFormatter>,
                at: CFAbsoluteTime,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFDateFormatterCreateStringWithAbsoluteTime(allocator, formatter, at) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `formatter` might not allow `None`.
    /// - `string` might not allow `None`.
    /// - `rangep` must be a valid pointer.
    #[doc(alias = "CFDateFormatterCreateDateFromString")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn new_date_from_string(
        allocator: Option<&CFAllocator>,
        formatter: Option<&CFDateFormatter>,
        string: Option<&CFString>,
        rangep: *mut CFRange,
    ) -> Option<CFRetained<CFDate>> {
        extern "C-unwind" {
            fn CFDateFormatterCreateDateFromString(
                allocator: Option<&CFAllocator>,
                formatter: Option<&CFDateFormatter>,
                string: Option<&CFString>,
                rangep: *mut CFRange,
            ) -> Option<NonNull<CFDate>>;
        }
        let ret =
            unsafe { CFDateFormatterCreateDateFromString(allocator, formatter, string, rangep) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `string` might not allow `None`.
    /// - `rangep` must be a valid pointer.
    /// - `atp` must be a valid pointer.
    #[doc(alias = "CFDateFormatterGetAbsoluteTimeFromString")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn absolute_time_from_string(
        &self,
        string: Option<&CFString>,
        rangep: *mut CFRange,
        atp: *mut CFAbsoluteTime,
    ) -> bool {
        extern "C-unwind" {
            fn CFDateFormatterGetAbsoluteTimeFromString(
                formatter: &CFDateFormatter,
                string: Option<&CFString>,
                rangep: *mut CFRange,
                atp: *mut CFAbsoluteTime,
            ) -> Boolean;
        }
        let ret = unsafe { CFDateFormatterGetAbsoluteTimeFromString(self, string, rangep, atp) };
        ret != 0
    }

    /// # Safety
    ///
    /// - `key` might not allow `None`.
    /// - `value` should be of the correct type.
    /// - `value` might not allow `None`.
    #[doc(alias = "CFDateFormatterSetProperty")]
    #[inline]
    pub unsafe fn set_property(&self, key: Option<&CFString>, value: Option<&CFType>) {
        extern "C-unwind" {
            fn CFDateFormatterSetProperty(
                formatter: &CFDateFormatter,
                key: Option<&CFString>,
                value: Option<&CFType>,
            );
        }
        unsafe { CFDateFormatterSetProperty(self, key, value) }
    }

    /// # Safety
    ///
    /// `key` might not allow `None`.
    #[doc(alias = "CFDateFormatterCopyProperty")]
    #[inline]
    pub unsafe fn property(&self, key: Option<&CFDateFormatterKey>) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFDateFormatterCopyProperty(
                formatter: &CFDateFormatter,
                key: Option<&CFDateFormatterKey>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFDateFormatterCopyProperty(self, key) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterislenient?language=objc)
    pub static kCFDateFormatterIsLenient: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattertimezone?language=objc)
    pub static kCFDateFormatterTimeZone: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattercalendarname?language=objc)
    pub static kCFDateFormatterCalendarName: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdefaultformat?language=objc)
    pub static kCFDateFormatterDefaultFormat: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattertwodigitstartdate?language=objc)
    pub static kCFDateFormatterTwoDigitStartDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdefaultdate?language=objc)
    pub static kCFDateFormatterDefaultDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattercalendar?language=objc)
    pub static kCFDateFormatterCalendar: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattererasymbols?language=objc)
    pub static kCFDateFormatterEraSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattermonthsymbols?language=objc)
    pub static kCFDateFormatterMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortmonthsymbols?language=objc)
    pub static kCFDateFormatterShortMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterweekdaysymbols?language=objc)
    pub static kCFDateFormatterWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortweekdaysymbols?language=objc)
    pub static kCFDateFormatterShortWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatteramsymbol?language=objc)
    pub static kCFDateFormatterAMSymbol: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterpmsymbol?language=objc)
    pub static kCFDateFormatterPMSymbol: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterlongerasymbols?language=objc)
    pub static kCFDateFormatterLongEraSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortmonthsymbols?language=objc)
    pub static kCFDateFormatterVeryShortMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandalonemonthsymbols?language=objc)
    pub static kCFDateFormatterStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandalonemonthsymbols?language=objc)
    pub static kCFDateFormatterShortStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortstandalonemonthsymbols?language=objc)
    pub static kCFDateFormatterVeryShortStandaloneMonthSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortweekdaysymbols?language=objc)
    pub static kCFDateFormatterVeryShortWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandaloneweekdaysymbols?language=objc)
    pub static kCFDateFormatterStandaloneWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandaloneweekdaysymbols?language=objc)
    pub static kCFDateFormatterShortStandaloneWeekdaySymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterveryshortstandaloneweekdaysymbols?language=objc)
    pub static kCFDateFormatterVeryShortStandaloneWeekdaySymbols:
        Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterquartersymbols?language=objc)
    pub static kCFDateFormatterQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortquartersymbols?language=objc)
    pub static kCFDateFormatterShortQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterstandalonequartersymbols?language=objc)
    pub static kCFDateFormatterStandaloneQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattershortstandalonequartersymbols?language=objc)
    pub static kCFDateFormatterShortStandaloneQuarterSymbols: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformattergregorianstartdate?language=objc)
    pub static kCFDateFormatterGregorianStartDate: Option<&'static CFDateFormatterKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdateformatterdoesrelativedateformattingkey?language=objc)
    pub static kCFDateFormatterDoesRelativeDateFormattingKey: Option<&'static CFDateFormatterKey>;
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFDateFormatter::new_date_format_from_template`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateDateFormatFromTemplate(
    allocator: Option<&CFAllocator>,
    tmplate: Option<&CFString>,
    options: CFOptionFlags,
    locale: Option<&CFLocale>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateDateFormatFromTemplate(
            allocator: Option<&CFAllocator>,
            tmplate: Option<&CFString>,
            options: CFOptionFlags,
            locale: Option<&CFLocale>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret =
        unsafe { CFDateFormatterCreateDateFormatFromTemplate(allocator, tmplate, options, locale) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFDateFormatter::new_iso_8601_formatter`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateISO8601Formatter(
    allocator: Option<&CFAllocator>,
    format_options: CFISO8601DateFormatOptions,
) -> Option<CFRetained<CFDateFormatter>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateISO8601Formatter(
            allocator: Option<&CFAllocator>,
            format_options: CFISO8601DateFormatOptions,
        ) -> Option<NonNull<CFDateFormatter>>;
    }
    let ret = unsafe { CFDateFormatterCreateISO8601Formatter(allocator, format_options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFDateFormatter::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreate(
    allocator: Option<&CFAllocator>,
    locale: Option<&CFLocale>,
    date_style: CFDateFormatterStyle,
    time_style: CFDateFormatterStyle,
) -> Option<CFRetained<CFDateFormatter>> {
    extern "C-unwind" {
        fn CFDateFormatterCreate(
            allocator: Option<&CFAllocator>,
            locale: Option<&CFLocale>,
            date_style: CFDateFormatterStyle,
            time_style: CFDateFormatterStyle,
        ) -> Option<NonNull<CFDateFormatter>>;
    }
    let ret = unsafe { CFDateFormatterCreate(allocator, locale, date_style, time_style) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFDateFormatter::locale`"]
#[inline]
pub extern "C-unwind" fn CFDateFormatterGetLocale(
    formatter: &CFDateFormatter,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFDateFormatterGetLocale(formatter: &CFDateFormatter) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFDateFormatterGetLocale(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFDateFormatter::date_style`"]
#[inline]
pub extern "C-unwind" fn CFDateFormatterGetDateStyle(
    formatter: &CFDateFormatter,
) -> CFDateFormatterStyle {
    extern "C-unwind" {
        fn CFDateFormatterGetDateStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
    }
    unsafe { CFDateFormatterGetDateStyle(formatter) }
}

#[deprecated = "renamed to `CFDateFormatter::time_style`"]
#[inline]
pub extern "C-unwind" fn CFDateFormatterGetTimeStyle(
    formatter: &CFDateFormatter,
) -> CFDateFormatterStyle {
    extern "C-unwind" {
        fn CFDateFormatterGetTimeStyle(formatter: &CFDateFormatter) -> CFDateFormatterStyle;
    }
    unsafe { CFDateFormatterGetTimeStyle(formatter) }
}

#[deprecated = "renamed to `CFDateFormatter::format`"]
#[inline]
pub extern "C-unwind" fn CFDateFormatterGetFormat(
    formatter: &CFDateFormatter,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterGetFormat(formatter: &CFDateFormatter) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterGetFormat(formatter) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFDateFormatter::set_format`"]
    pub fn CFDateFormatterSetFormat(formatter: &CFDateFormatter, format_string: Option<&CFString>);
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFDateFormatter::new_string_with_date`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateStringWithDate(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    date: Option<&CFDate>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateStringWithDate(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            date: Option<&CFDate>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterCreateStringWithDate(allocator, formatter, date) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFDateFormatter::new_string_with_absolute_time`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateStringWithAbsoluteTime(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    at: CFAbsoluteTime,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateStringWithAbsoluteTime(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            at: CFAbsoluteTime,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFDateFormatterCreateStringWithAbsoluteTime(allocator, formatter, at) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFDateFormatter::new_date_from_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCreateDateFromString(
    allocator: Option<&CFAllocator>,
    formatter: Option<&CFDateFormatter>,
    string: Option<&CFString>,
    rangep: *mut CFRange,
) -> Option<CFRetained<CFDate>> {
    extern "C-unwind" {
        fn CFDateFormatterCreateDateFromString(
            allocator: Option<&CFAllocator>,
            formatter: Option<&CFDateFormatter>,
            string: Option<&CFString>,
            rangep: *mut CFRange,
        ) -> Option<NonNull<CFDate>>;
    }
    let ret = unsafe { CFDateFormatterCreateDateFromString(allocator, formatter, string, rangep) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFDateFormatter::absolute_time_from_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterGetAbsoluteTimeFromString(
    formatter: &CFDateFormatter,
    string: Option<&CFString>,
    rangep: *mut CFRange,
    atp: *mut CFAbsoluteTime,
) -> bool {
    extern "C-unwind" {
        fn CFDateFormatterGetAbsoluteTimeFromString(
            formatter: &CFDateFormatter,
            string: Option<&CFString>,
            rangep: *mut CFRange,
            atp: *mut CFAbsoluteTime,
        ) -> Boolean;
    }
    let ret = unsafe { CFDateFormatterGetAbsoluteTimeFromString(formatter, string, rangep, atp) };
    ret != 0
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFDateFormatter::set_property`"]
    pub fn CFDateFormatterSetProperty(
        formatter: &CFDateFormatter,
        key: Option<&CFString>,
        value: Option<&CFType>,
    );
}

#[deprecated = "renamed to `CFDateFormatter::property`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDateFormatterCopyProperty(
    formatter: &CFDateFormatter,
    key: Option<&CFDateFormatterKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFDateFormatterCopyProperty(
            formatter: &CFDateFormatter,
            key: Option<&CFDateFormatterKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFDateFormatterCopyProperty(formatter, key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
