//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// A value that uniquely identifies an audio queue property.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuepropertyid?language=objc)
pub type AudioQueuePropertyID = u32;

/// A value that uniquely identifies an audio queue parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueparameterid?language=objc)
pub type AudioQueueParameterID = u32;

/// A value for an audio queue parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueparametervalue?language=objc)
pub type AudioQueueParameterValue = f32;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudioqueue?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioQueue {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioQueue {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("OpaqueAudioQueue", &[]));
}

/// An opaque data type that represents an audio queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueref?language=objc)
pub type AudioQueueRef = *mut OpaqueAudioQueue;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudioqueuetimeline?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioQueueTimeline {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioQueueTimeline {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueAudioQueueTimeline", &[]));
}

/// An opaque data type that represents an audio queue timeline.
///
/// You can use this object to observe any overloads in the audio device associated with the
/// audio queue. A timeline object receives notifications of discontinuities in the audio
/// hardware's sample timeline--for instance, a period of silence when sound was expected.
/// Causes of discontinuities include changes in the device state or processing overloads.
/// See Technical Q
/// &
/// A: QA 1467 for a discussion of Core Audio overload warnings. These
/// warnings indicate you are taking too long to process audio data and the system has cut
/// you off. You query a timeline object by passing it as a parameter to
/// AudioQueueGetCurrentTime, which means a discontinuity has occurred.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuetimelineref?language=objc)
pub type AudioQueueTimelineRef = *mut OpaqueAudioQueueTimeline;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidbuffer?language=objc)
pub const kAudioQueueErr_InvalidBuffer: OSStatus = -66687;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_bufferempty?language=objc)
pub const kAudioQueueErr_BufferEmpty: OSStatus = -66686;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_disposalpending?language=objc)
pub const kAudioQueueErr_DisposalPending: OSStatus = -66685;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidproperty?language=objc)
pub const kAudioQueueErr_InvalidProperty: OSStatus = -66684;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidpropertysize?language=objc)
pub const kAudioQueueErr_InvalidPropertySize: OSStatus = -66683;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidparameter?language=objc)
pub const kAudioQueueErr_InvalidParameter: OSStatus = -66682;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_cannotstart?language=objc)
pub const kAudioQueueErr_CannotStart: OSStatus = -66681;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invaliddevice?language=objc)
pub const kAudioQueueErr_InvalidDevice: OSStatus = -66680;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_bufferinqueue?language=objc)
pub const kAudioQueueErr_BufferInQueue: OSStatus = -66679;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidrunstate?language=objc)
pub const kAudioQueueErr_InvalidRunState: OSStatus = -66678;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidqueuetype?language=objc)
pub const kAudioQueueErr_InvalidQueueType: OSStatus = -66677;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_permissions?language=objc)
pub const kAudioQueueErr_Permissions: OSStatus = -66676;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidpropertyvalue?language=objc)
pub const kAudioQueueErr_InvalidPropertyValue: OSStatus = -66675;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_primetimedout?language=objc)
pub const kAudioQueueErr_PrimeTimedOut: OSStatus = -66674;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_codecnotfound?language=objc)
pub const kAudioQueueErr_CodecNotFound: OSStatus = -66673;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidcodecaccess?language=objc)
pub const kAudioQueueErr_InvalidCodecAccess: OSStatus = -66672;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_queueinvalidated?language=objc)
pub const kAudioQueueErr_QueueInvalidated: OSStatus = -66671;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_toomanytaps?language=objc)
pub const kAudioQueueErr_TooManyTaps: OSStatus = -66670;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidtapcontext?language=objc)
pub const kAudioQueueErr_InvalidTapContext: OSStatus = -66669;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_recordunderrun?language=objc)
pub const kAudioQueueErr_RecordUnderrun: OSStatus = -66668;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidtaptype?language=objc)
pub const kAudioQueueErr_InvalidTapType: OSStatus = -66667;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_bufferenqueuedtwice?language=objc)
pub const kAudioQueueErr_BufferEnqueuedTwice: OSStatus = -66666;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_cannotstartyet?language=objc)
pub const kAudioQueueErr_CannotStartYet: OSStatus = -66665;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_enqueueduringreset?language=objc)
pub const kAudioQueueErr_EnqueueDuringReset: OSStatus = -66632;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueerr_invalidofflinemode?language=objc)
pub const kAudioQueueErr_InvalidOfflineMode: OSStatus = -66626;

/// value is UInt32
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_isrunning?language=objc)
pub const kAudioQueueProperty_IsRunning: AudioQueuePropertyID = 0x6171726e;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueuedeviceproperty_samplerate?language=objc)
pub const kAudioQueueDeviceProperty_SampleRate: AudioQueuePropertyID = 0x61717372;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueuedeviceproperty_numberchannels?language=objc)
pub const kAudioQueueDeviceProperty_NumberChannels: AudioQueuePropertyID = 0x61716463;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_currentdevice?language=objc)
pub const kAudioQueueProperty_CurrentDevice: AudioQueuePropertyID = 0x61716364;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_magiccookie?language=objc)
pub const kAudioQueueProperty_MagicCookie: AudioQueuePropertyID = 0x61716d63;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_maximumoutputpacketsize?language=objc)
pub const kAudioQueueProperty_MaximumOutputPacketSize: AudioQueuePropertyID = 0x786f7073;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_streamdescription?language=objc)
pub const kAudioQueueProperty_StreamDescription: AudioQueuePropertyID = 0x61716674;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_channellayout?language=objc)
pub const kAudioQueueProperty_ChannelLayout: AudioQueuePropertyID = 0x6171636c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_enablelevelmetering?language=objc)
pub const kAudioQueueProperty_EnableLevelMetering: AudioQueuePropertyID = 0x61716d65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_currentlevelmeter?language=objc)
pub const kAudioQueueProperty_CurrentLevelMeter: AudioQueuePropertyID = 0x61716d76;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_currentlevelmeterdb?language=objc)
pub const kAudioQueueProperty_CurrentLevelMeterDB: AudioQueuePropertyID = 0x61716d64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_decodebuffersizeframes?language=objc)
pub const kAudioQueueProperty_DecodeBufferSizeFrames: AudioQueuePropertyID = 0x64636266;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_convertererror?language=objc)
pub const kAudioQueueProperty_ConverterError: AudioQueuePropertyID = 0x71637665;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_enabletimepitch?language=objc)
pub const kAudioQueueProperty_EnableTimePitch: AudioQueuePropertyID = 0x715f7470;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_timepitchalgorithm?language=objc)
pub const kAudioQueueProperty_TimePitchAlgorithm: AudioQueuePropertyID = 0x71747061;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_timepitchbypass?language=objc)
pub const kAudioQueueProperty_TimePitchBypass: AudioQueuePropertyID = 0x71747062;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueuetimepitchalgorithm_spectral?language=objc)
pub const kAudioQueueTimePitchAlgorithm_Spectral: u32 = 0x73706563;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueuetimepitchalgorithm_timedomain?language=objc)
pub const kAudioQueueTimePitchAlgorithm_TimeDomain: u32 = 0x7469646f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueuetimepitchalgorithm_varispeed?language=objc)
pub const kAudioQueueTimePitchAlgorithm_Varispeed: u32 = 0x76737064;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueproperty_channelassignments?language=objc)
pub const kAudioQueueProperty_ChannelAssignments: AudioQueuePropertyID = 0x61716361;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueparam_volume?language=objc)
pub const kAudioQueueParam_Volume: AudioQueueParameterID = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueparam_playrate?language=objc)
pub const kAudioQueueParam_PlayRate: AudioQueueParameterID = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueparam_pitch?language=objc)
pub const kAudioQueueParam_Pitch: AudioQueueParameterID = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueparam_volumeramptime?language=objc)
pub const kAudioQueueParam_VolumeRampTime: AudioQueueParameterID = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudioqueueparam_pan?language=objc)
pub const kAudioQueueParam_Pan: AudioQueueParameterID = 13;

/// Flags used in conjunction with processing taps
///
/// In the flags passed to AudioQueueProcessingTapNew, either the PreEffects
/// or PostEffects flag must be set, but not both.
///
///
/// Signifies that the processing tap is inserted before any effects.
/// Passed to AudioQueueProcessingTapNew and to the callback.
///
/// Signifies that the processing tap is inserted after any effects.
/// Passed to AudioQueueProcessingTapNew and to the callback.
///
/// Signifies that the processing tap is a siphon; it does not call
/// GetSourceAudio. The callback instead receives the source audio
/// and may not modify it. Passed to AudioQueueProcessingTapNew and to the callback.
///
/// Signifies that the source audio is the beginning of a continuous stream,
/// i.e. following the beginning or resumption of playback or recording.
/// Returned from GetSourceAudio.
///
/// Signifies that the source audio is past the end of stream. This happens when
/// the audio queue is being stopped asynchronously and has finished playing
/// all of its data. Returned from GetSourceAudio and should be propagated
/// on return from the callback.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueprocessingtapflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioQueueProcessingTapFlags(pub u32);
bitflags::bitflags! {
    impl AudioQueueProcessingTapFlags: u32 {
        #[doc(alias = "kAudioQueueProcessingTap_PreEffects")]
        const PreEffects = 1<<0;
        #[doc(alias = "kAudioQueueProcessingTap_PostEffects")]
        const PostEffects = 1<<1;
        #[doc(alias = "kAudioQueueProcessingTap_Siphon")]
        const Siphon = 1<<2;
        #[doc(alias = "kAudioQueueProcessingTap_StartOfStream")]
        const StartOfStream = 1<<8;
        #[doc(alias = "kAudioQueueProcessingTap_EndOfStream")]
        const EndOfStream = 1<<9;
    }
}

unsafe impl Encode for AudioQueueProcessingTapFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioQueueProcessingTapFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Defines a buffer of audio data to be managed by an audio queue.
///
/// Each audio queue has an associated set of audio queue buffers. You can request that a
/// queue allocate buffers using the AudioQueueAllocateBuffer function and dispose of them
/// using the AudioQueueFreeBuffer function.
///
/// You may also use AudioQueueAllocateBufferWithPacketDescriptions to allocate buffers
/// with space for AudioPacketDescriptions, as used in VBR formats. The
/// mPacketDescriptionCapacity, mmPacketDescriptions, and mPacketDescriptionCount
/// fields may only be used with buffers allocated with this function.
///
///
/// The size of the buffer, in bytes. This size is set when the buffer is allocated and
/// cannot be changed.
///
/// A pointer to the audio data in the buffer. Although you can write data to this buffer,
/// you cannot make it point to another address.
///
/// The number of bytes of valid audio data in the buffer. You set this value when providing
/// data for playback; the audio queue sets this value when recording data from a recording
/// queue.
///
/// A value you may specify to identify the buffer when it is passed back in recording or
/// playback callback functions.
///
/// The maximum number of packet descriptions that can be stored in mPacketDescriptions.
///
/// An array of AudioStreamPacketDescriptions associated with the buffer.
///
/// The number of valid packet descriptions in the buffer. You set this value when providing
/// buffers for playback; the audio queue sets this value when returning buffers from
/// a recording queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuebuffer?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioQueueBuffer {
    pub mAudioDataBytesCapacity: u32,
    pub mAudioData: NonNull<c_void>,
    pub mAudioDataByteSize: u32,
    pub mUserData: *mut c_void,
    pub mPacketDescriptionCapacity: u32,
    pub mPacketDescriptions: *const AudioStreamPacketDescription,
    pub mPacketDescriptionCount: u32,
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl Encode for AudioQueueBuffer {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioQueueBuffer",
        &[
            <u32>::ENCODING,
            <NonNull<c_void>>::ENCODING,
            <u32>::ENCODING,
            <*mut c_void>::ENCODING,
            <u32>::ENCODING,
            <*const AudioStreamPacketDescription>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-audio-types")]
unsafe impl RefEncode for AudioQueueBuffer {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// An pointer to an AudioQueueBuffer.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuebufferref?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioQueueBufferRef = *mut AudioQueueBuffer;

/// Specifies a value for an audio queue parameter.
///
/// Two ways are available to supply an audio queue with parameters:
///
/// - Provide one or more parameters by calling the AudioQueueEnqueueBufferWithParameters
/// function. In this case, the parameters are applied to the specified buffer when it is
/// played.
///
/// - Assign a parameter value immediately to an audio queue by calling the
/// AudioQueueSetParameter function.
///
/// Note that the AudioQueueGetParameter function always returns the actual value of the
/// parameter.
///
/// In macOS v10.5, audio queues have one parameter available: kAudioQueueParam_Volume,
/// which controls the queue's playback volume.
///
///
/// The parameter.
///
/// The value of the specified parameter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueparameterevent?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioQueueParameterEvent {
    pub mID: AudioQueueParameterID,
    pub mValue: AudioQueueParameterValue,
}

unsafe impl Encode for AudioQueueParameterEvent {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioQueueParameterEvent",
        &[
            <AudioQueueParameterID>::ENCODING,
            <AudioQueueParameterValue>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioQueueParameterEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Specifies the current level metering information for one channel of an audio queue.
///
/// The audio channel's average RMS power.
///
/// The audio channel's peak RMS power
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuelevelmeterstate?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioQueueLevelMeterState {
    pub mAveragePower: f32,
    pub mPeakPower: f32,
}

unsafe impl Encode for AudioQueueLevelMeterState {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioQueueLevelMeterState",
        &[<f32>::ENCODING, <f32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioQueueLevelMeterState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudioqueueprocessingtap?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioQueueProcessingTap {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioQueueProcessingTap {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueAudioQueueProcessingTap", &[]));
}

/// An object for intercepting and processing audio within an audio queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueprocessingtapref?language=objc)
pub type AudioQueueProcessingTapRef = *mut OpaqueAudioQueueProcessingTap;

/// Specifies an audio device channel to which the queue will play or from which
/// it will record.
///
/// On iOS, this is a port UID obtained from AVAudioSession. On macOS, this is the UID
/// obtained from an AudioDeviceID.
///
/// The 1-based index of the channel.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuechannelassignment?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioQueueChannelAssignment {
    pub mDeviceUID: NonNull<CFString>,
    pub mChannelNumber: u32,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioQueueChannelAssignment {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioQueueChannelAssignment",
        &[<NonNull<CFString>>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioQueueChannelAssignment {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Defines a pointer to a block that is called when a playback audio
/// queue has finished taking data from a buffer.
///
/// A playback buffer callback is invoked when the audio queue has finished with the data to
/// be played and the buffer is available to your application for reuse. Your application
/// might want to immediately refill and re-enqueue the completed buffer at this time.
///
///
/// Parameter `inAQ`: The audio queue that invoked the callback.
///
/// Parameter `inBuffer`: The audio queue buffer made available by the audio queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueoutputcallbackblock?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-core-audio-types"))]
pub type AudioQueueOutputCallbackBlock =
    *mut block2::DynBlock<dyn Fn(AudioQueueRef, AudioQueueBufferRef)>;

/// Defines a pointer to a block that is called when a recording audio
/// queue has finished filling a buffer.
///
/// You specify a recording buffer callback when calling AudioQueueNewInput. Your callback
/// is invoked each time the recording audio queue has filled a buffer with input data.
/// Typically, your callback should write the audio queue buffer's data to a file or other
/// buffer, and then re-queue the audio queue buffer to receive more data.
///
///
/// Parameter `inAQ`: The audio queue that invoked the callback.
///
/// Parameter `inBuffer`: An audio queue buffer, newly filled by the audio queue, containing the new audio data
/// your callback needs to write.
///
/// Parameter `inStartTime`: A pointer to an audio time stamp structure corresponding to the first sample contained
/// in the buffer. This contains the sample time of the first sample in the buffer.
///
/// Parameter `inNumberPacketDescriptions`: The number of audio packets contained in the data provided to the callback
///
/// Parameter `inPacketDescs`: For compressed formats which require packet descriptions, the packet descriptions
/// produced by the encoder for the incoming buffer.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueinputcallbackblock?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-core-audio-types"))]
pub type AudioQueueInputCallbackBlock = *mut block2::DynBlock<
    dyn Fn(
        AudioQueueRef,
        AudioQueueBufferRef,
        NonNull<AudioTimeStamp>,
        u32,
        *const AudioStreamPacketDescription,
    ),
>;

/// Defines a pointer to a callback function that is called when a playback audio
/// queue has finished taking data from a buffer.
///
/// A playback buffer callback is invoked when the audio queue has finished with the data to
/// be played and the buffer is available to your application for reuse. Your application
/// might want to immediately refill and re-enqueue the completed buffer at this time.
///
///
/// Parameter `inUserData`: The value specified by the inUserData parameter of the AudioQueueNewOutput function.
///
/// Parameter `inAQ`: The audio queue that invoked the callback.
///
/// Parameter `inBuffer`: The audio queue buffer made available by the audio queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueoutputcallback?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioQueueOutputCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, AudioQueueRef, AudioQueueBufferRef)>;

/// Defines a pointer to a callback function that is called when a recording audio
/// queue has finished filling a buffer.
///
/// You specify a recording buffer callback when calling AudioQueueNewInput. Your callback
/// is invoked each time the recording audio queue has filled a buffer with input data.
/// Typically, your callback should write the audio queue buffer's data to a file or other
/// buffer, and then re-queue the audio queue buffer to receive more data.
///
///
/// Parameter `inUserData`: The value you've specified in the inUserData parameter of the AudioQueueNewInput
/// function.
///
/// Parameter `inAQ`: The audio queue that invoked the callback.
///
/// Parameter `inBuffer`: An audio queue buffer, newly filled by the audio queue, containing the new audio data
/// your callback needs to write.
///
/// Parameter `inStartTime`: A pointer to an audio time stamp structure corresponding to the first sample contained
/// in the buffer. This contains the sample time of the first sample in the buffer.
///
/// Parameter `inNumberPacketDescriptions`: The number of audio packets contained in the data provided to the callback
///
/// Parameter `inPacketDescs`: For compressed formats which require packet descriptions, the packet descriptions
/// produced by the encoder for the incoming buffer.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueinputcallback?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioQueueInputCallback = Option<
    unsafe extern "C-unwind" fn(
        *mut c_void,
        AudioQueueRef,
        AudioQueueBufferRef,
        NonNull<AudioTimeStamp>,
        u32,
        *const AudioStreamPacketDescription,
    ),
>;

/// Defines a pointer to a callback function that is called when a specified
/// property changes value.
///
/// You assign a property listener callback when calling AudioQueueAddPropertyListener.
///
///
/// Parameter `inUserData`: A pointer to the data specified by the inUserData parameter of the
/// AudioQueueAddPropertyListener function.
///
/// Parameter `inAQ`: The audio queue that invoked the callback.
///
/// Parameter `inID`: The ID of the property that invoked the callback.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueuepropertylistenerproc?language=objc)
pub type AudioQueuePropertyListenerProc =
    Option<unsafe extern "C-unwind" fn(*mut c_void, AudioQueueRef, AudioQueuePropertyID)>;

/// A function called when an audio queue has data to be processed by its tap
///
/// A processing callback is invoked when the audio queue has data that can be processed by a given
/// tap.
///
/// The audio queue will call the processing callback when it has sufficient data to provide for
/// processing.
///
/// In the case of a siphoning tap, the callback function can inspect the audio data in ioData, but
/// should not otherwise modify it. The callback should not call
/// AudioQueueProcessingTapGetSourceAudio.
///
/// A non-siphoning callback should call AudioQueueProcessingTapGetSourceAudio to request from the
/// queue as much source data as it needs in order to produce the requested number of output
/// samples. When the callback requests source data it may receive less data than it requests.
///
/// In the case of a tap on an audio output queue, the tap must emit the exact number of sample
/// frames that the queue requests. In normal circumstances, the tap's requests for source data will
/// be satisfied (as the client running the audio queue is also providing the queue with the audio
/// source material). If there is insufficient source data available (this is indicated by the
/// outNumberFrames from the GetSource call), then the processing tap should deal as best as it can;
/// it can either return less data than was requested or insert silence, noise, etc. itself. If it
/// returns less data than requested, the hosting audio queue will fill in the remainder with
/// silence.
///
/// In the case of a tap on an audio input queue, the tap may provide back less audio data than is
/// being requested. Typically this will occur because the tap will ask for source data that is not
/// available at this time (the audio input hasn't arrived yet), so the tap should cache the source
/// data that it needs and return as many processed samples as it can. If the processing tap falls
/// behind and is not providing data quickly enough silence will be generated in the data provided
/// to the client (and there is no signal about this either).
///
/// A processing tap executes in a semi-real-time context, so the general limitations for real-time
/// processing apply. Avoid using API's which may block. In particular, it is not safe to call the
/// audio queue on which the tap was installed, with the exceptions of
/// AudioQueueProcessingTapGetSourceAudio and AudioQueueProcessingTapGetQueueTime.
///
/// In normal operation the source data will be continuous from the last time the callback was
/// called and the processed samples should be continuous from the previous samples returned. If
/// there is any discontinuity between the last samples provided for processing the audio queue will
/// set the bit for kAudioQueueProcessing_StartOfStream in the inFlags. After a discontinuity the
/// first sample that the processing tap outputs should correspond to the first sample that was
/// provided in the source samples (so a reset and then consequent process serves to re-anchor a
/// relationship between the processing tap's source and processed samples). In this case the
/// processing tap will typically discard any previous state (for instance, if a processing tap was
/// adding a reverb to a signal, then the discontinuity flag would act the same as AudioUnitReset;
/// any previous source information in the processing tap should be discarded).
///
/// The caller is responsible for absorbing any processing delays. For example, if the processing is
/// to be done by an audio unit that reports a processing latency, then the caller should remove
/// those latency samples from the audio unit's rendering and not return them to the audio queue.
///
/// The processing tap is able to operate on the provided source data in place (that is, it can do
/// "in place processing") and return pointers to that buffer rather than its own. This works in a
/// similar way as AudioUnit render operations.
///
/// When an output audio queue is being stopped asynchronously, the processing tap will see the
/// kAudioQueueProcessingTap_EndOfStream bit set on return from GetSourceAudio, and is responsible
/// for propagating this bit from the callback when its processing has reached this point.
///
/// A processing tap will NEVER see the same source data again, so, it should keep its own copy if
/// it needs to keep it for further reference past the duration of this call. It also cannot assume
/// that the pointers to the source data that it retrieves will remain valid AFTER the processing
/// tap has executed.
///
/// The processing tap should ensure that the data pointers it provides in outProcessedData remain
/// valid until the tap is executed again.
///
/// A processing tap is destroyed implicitly when its audio queue is disposed. It may also be
/// removed explicitly, via AudioQueueProcessingTapDispose.
///
///
/// Parameter `inClientData`: the client data pointer passed to AudioQueueProcessingTapNew
///
/// Parameter `inAQTap`: The tap for this callback.
///
/// Parameter `inNumberFrames`: The requested number of sample frames to be rendered.
///
/// Parameter `ioFlags`: On entry, the flags passed at construction time are provided. On exit,
/// the start/end of stream flags should be set when appropriate.
///
/// Parameter `ioTimeStamp`: On an input audio queue, the timestamp must be returned from this function.
/// On an output audio queue, the callback is provided a continuous timestamp.
///
/// Parameter `outNumberFrames`: The number of frames of audio data provided in the processed data. Can be 0.
///
/// Parameter `ioData`: For non-siphoning taps, on entry, the buffer pointers are null and the lengths
/// are zero. On exit, they should contain the tap's output.
///
/// Siphoning taps receive valid buffers which they must not alter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioqueueprocessingtapcallback?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioQueueProcessingTapCallback = Option<
    unsafe extern "C-unwind" fn(
        NonNull<c_void>,
        AudioQueueProcessingTapRef,
        u32,
        NonNull<AudioTimeStamp>,
        NonNull<AudioQueueProcessingTapFlags>,
        NonNull<u32>,
        NonNull<AudioBufferList>,
    ),
>;

extern "C-unwind" {
    /// Creates a new audio queue for playing audio data.
    ///
    /// To create an playback audio queue, you allocate buffers, then queue buffers (using
    /// AudioQueueEnqueueBuffer). The callback receives buffers and typically queues them again.
    /// To schedule a buffer for playback, providing parameter and start time information, call
    /// AudioQueueEnqueueBufferWithParameters.
    ///
    ///
    /// Parameter `inFormat`: A pointer to a structure describing the format of the audio data to be played. For
    /// linear PCM, only interleaved formats are supported. Compressed formats are supported.
    ///
    /// Parameter `inCallbackProc`: A pointer to a callback function to be called when the audio queue has finished playing
    /// a buffer.
    ///
    /// Parameter `inUserData`: A value or pointer to data that you specify to be passed to the callback function.
    ///
    /// Parameter `inCallbackRunLoop`: The event loop on which inCallbackProc is to be called. If you specify NULL, the
    /// callback is called on one of the audio queue's internal threads.
    ///
    /// Parameter `inCallbackRunLoopMode`: The run loop mode in which to call the callback. Typically, you pass
    /// kCFRunLoopCommonModes. (NULL also specifies kCFRunLoopCommonModes). Other
    /// possibilities are implementation specific. You can choose to create your own thread with
    /// your own run loops. For more information on run loops, see Run Loops or CFRunLoop
    /// Reference.
    ///
    /// Parameter `inFlags`: Reserved for future use. Pass 0.
    ///
    /// Parameter `outAQ`: On return, this variable contains a pointer to the newly created playback audio queue
    /// object.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-foundation"))]
    pub fn AudioQueueNewOutput(
        in_format: NonNull<AudioStreamBasicDescription>,
        in_callback_proc: AudioQueueOutputCallback,
        in_user_data: *mut c_void,
        in_callback_run_loop: Option<&CFRunLoop>,
        in_callback_run_loop_mode: Option<&CFString>,
        in_flags: u32,
        out_aq: NonNull<AudioQueueRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates a new audio queue for recording audio data.
    ///
    /// Outline of how to use the queue for input:
    ///
    /// - create input queue
    /// - allocate buffers
    /// - enqueue buffers (AudioQueueEnqueueBuffer, not with parameters, no packet descriptions)
    /// - the callback receives buffers and re-enqueues them
    ///
    ///
    /// Parameter `inFormat`: A pointer to a structure describing the format of the audio data to be recorded. For
    /// linear PCM, only interleaved formats are supported. Compressed formats are supported.
    ///
    /// Parameter `inCallbackProc`: A pointer to a callback function to be called when the audio queue has finished filling
    /// a buffer.
    ///
    /// Parameter `inUserData`: A value or pointer to data that you specify to be passed to the callback function.
    ///
    /// Parameter `inCallbackRunLoop`: The event loop on which inCallbackProc is to be called. If you specify NULL, the
    /// callback is called on one of the audio queue's internal threads.
    ///
    /// Parameter `inCallbackRunLoopMode`: The run loop mode in which to call the callback. Typically, you pass
    /// kCFRunLoopCommonModes. (NULL also specifies kCFRunLoopCommonModes). Other
    /// possibilities are implementation specific. You can choose to create your own thread with
    /// your own run loops. For more information on run loops, see Run Loops or CFRunLoop
    /// Reference.
    ///
    /// Parameter `inFlags`: Reserved for future use. Pass 0.
    ///
    /// Parameter `outAQ`: On return, this variable contains a pointer to the newly created recording audio queue
    /// object.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-foundation"))]
    pub fn AudioQueueNewInput(
        in_format: NonNull<AudioStreamBasicDescription>,
        in_callback_proc: AudioQueueInputCallback,
        in_user_data: *mut c_void,
        in_callback_run_loop: Option<&CFRunLoop>,
        in_callback_run_loop_mode: Option<&CFString>,
        in_flags: u32,
        out_aq: NonNull<AudioQueueRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates a new audio queue for playing audio data.
    ///
    /// To create an playback audio queue, you allocate buffers, then queue buffers (using
    /// AudioQueueEnqueueBuffer). The callback receives buffers and typically queues them again.
    /// To schedule a buffer for playback, providing parameter and start time information, call
    /// AudioQueueEnqueueBufferWithParameters.
    ///
    ///
    /// Parameter `outAQ`: On return, this variable contains a pointer to the newly created playback audio queue
    /// object.
    ///
    /// Parameter `inFormat`: A pointer to a structure describing the format of the audio data to be played. For
    /// linear PCM, only interleaved formats are supported. Compressed formats are supported.
    ///
    /// Parameter `inFlags`: Reserved for future use. Pass 0.
    ///
    /// Parameter `inCallbackDispatchQueue`: The dispatch queue from which inCallbackBlock is to be called.
    ///
    /// Parameter `inCallbackBlock`: A pointer to a callback block to be called when the audio queue has finished playing
    /// a buffer.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(all(
        feature = "block2",
        feature = "dispatch2",
        feature = "objc2-core-audio-types"
    ))]
    pub fn AudioQueueNewOutputWithDispatchQueue(
        out_aq: NonNull<AudioQueueRef>,
        in_format: NonNull<AudioStreamBasicDescription>,
        in_flags: u32,
        in_callback_dispatch_queue: &DispatchQueue,
        in_callback_block: AudioQueueOutputCallbackBlock,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates a new audio queue for recording audio data.
    ///
    /// Outline of how to use the queue for input:
    ///
    /// - create input queue
    /// - allocate buffers
    /// - enqueue buffers (AudioQueueEnqueueBuffer, not with parameters, no packet descriptions)
    /// - the callback receives buffers and re-enqueues them
    ///
    ///
    /// Parameter `outAQ`: On return, this variable contains a pointer to the newly created recording audio queue
    /// object.
    ///
    /// Parameter `inFormat`: A pointer to a structure describing the format of the audio data to be recorded. For
    /// linear PCM, only interleaved formats are supported. Compressed formats are supported.
    ///
    /// Parameter `inFlags`: Reserved for future use. Pass 0.
    ///
    /// Parameter `inCallbackDispatchQueue`: The dispatch queue from which inCallbackBlock is to be called.
    ///
    /// Parameter `inCallbackBlock`: A pointer to a callback block to be called when the audio queue has finished filling
    /// a buffer.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(all(
        feature = "block2",
        feature = "dispatch2",
        feature = "objc2-core-audio-types"
    ))]
    pub fn AudioQueueNewInputWithDispatchQueue(
        out_aq: NonNull<AudioQueueRef>,
        in_format: NonNull<AudioStreamBasicDescription>,
        in_flags: u32,
        in_callback_dispatch_queue: &DispatchQueue,
        in_callback_block: AudioQueueInputCallbackBlock,
    ) -> OSStatus;
}

/// Disposes an existing audio queue.
///
/// Disposing of the audio queue also disposes of all its resources, including its buffers.
///
///
/// Parameter `inAQ`: The audio queue you want to dispose of
///
/// Parameter `inImmediate`: If you pass true, the audio queue is disposed of immediately (that is, synchronously).
/// If you pass false, disposal does not take place until all enqueued buffers are
/// processed. Whether you call AudioQueueDispose synchronously or asynchronously, you can
/// no longer interact with the queue, and the queue no longer invokes any callbacks to your
/// application after the function returns.
///
/// Note that if AudioQueueDispose is called from a buffer completion callback or property
/// listener, you may receive further callbacks afterwards.
///
/// Returns: An OSStatus result code.
#[inline]
pub unsafe extern "C-unwind" fn AudioQueueDispose(
    in_aq: AudioQueueRef,
    in_immediate: bool,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioQueueDispose(in_aq: AudioQueueRef, in_immediate: Boolean) -> OSStatus;
    }
    unsafe { AudioQueueDispose(in_aq, in_immediate as _) }
}

extern "C-unwind" {
    /// Asks an audio queue to allocate a buffer.
    ///
    /// Once allocated, the pointer to the buffer and the buffer's size are fixed and cannot be
    /// changed. The mAudioDataByteSize field in the audio queue buffer structure,
    /// AudioQueueBuffer, is initially set to 0.
    ///
    ///
    /// Parameter `inAQ`: The audio queue you want to allocate a buffer.
    ///
    /// Parameter `inBufferByteSize`: The desired size of the new buffer, in bytes. An appropriate buffer size depends on the
    /// processing you will perform on the data as well as on the audio data format.
    ///
    /// Parameter `outBuffer`: On return, points to the newly created audio buffer. The mAudioDataByteSize field in the
    /// audio queue buffer structure, AudioQueueBuffer, is initially set to 0.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueAllocateBuffer(
        in_aq: AudioQueueRef,
        in_buffer_byte_size: u32,
        out_buffer: NonNull<AudioQueueBufferRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Asks an audio queue to allocate a buffer with space for packet descriptions.
    ///
    /// Once allocated, the pointer to the buffer and the buffer's size are fixed and cannot be
    /// changed. The mAudioDataByteSize field in the audio queue buffer structure,
    /// AudioQueueBuffer, is initially set to 0.
    ///
    ///
    /// Parameter `inAQ`: The audio queue you want to allocate a buffer.
    ///
    /// Parameter `inBufferByteSize`: The desired size of the new buffer, in bytes. An appropriate buffer size depends on the
    /// processing you will perform on the data as well as on the audio data format.
    ///
    /// Parameter `inNumberPacketDescriptions`: The desired capacity of the packet description array in the new buffer.
    ///
    /// Parameter `outBuffer`: On return, points to the newly created audio buffer. The mAudioDataByteSize field in the
    /// audio queue buffer structure, AudioQueueBuffer, is initially set to 0.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueAllocateBufferWithPacketDescriptions(
        in_aq: AudioQueueRef,
        in_buffer_byte_size: u32,
        in_number_packet_descriptions: u32,
        out_buffer: NonNull<AudioQueueBufferRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Disposes of an audio queue buffer.
    ///
    /// This function disposes of the buffer allocated by AudioQueueAllocateBuffer. Disposing of
    /// an audio queue also automatically disposes of any associated buffers and timeline
    /// objects. Call this function only if you want to dispose of a particular buffer while
    /// continuing to use an audio queue. You can dispose of buffers only when the associated
    /// queue is stopped (that is, not processing audio data).
    ///
    ///
    /// Parameter `inAQ`: The queue from which the buffer was allocated.
    ///
    /// Parameter `inBuffer`: The buffer to be disposed.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueFreeBuffer(in_aq: AudioQueueRef, in_buffer: AudioQueueBufferRef) -> OSStatus;
}

extern "C-unwind" {
    /// Assigns a buffer to an audio queue for recording or playback.
    ///
    /// If the buffer was allocated with AudioQueueAllocateBufferWithPacketDescriptions,
    /// the client should provide packet descriptions in the buffer's mPacketDescriptions
    /// and mPacketDescriptionCount fields rather than in inPacketDescs and
    /// inNumPacketDescs, which should be NULL and 0, respectively, in this case.
    ///
    /// For an input queue, pass 0 and NULL for inNumPacketDescs and inPacketDescs,
    /// respectively. Your callback will receive packet descriptions owned by the audio queue.
    ///
    ///
    /// Parameter `inAQ`: The audio queue you are assigning the buffer to.
    ///
    /// Parameter `inBuffer`: The buffer to queue (that is, to be recorded into or played from).
    ///
    /// Parameter `inNumPacketDescs`: The number of packet descriptions pointed to by the inPacketDescs pointer. Applicable
    /// only for output queues and required only for variable-bit-rate (VBR) audio formats. Pass
    /// 0 for input queues (no packet descriptions are required).
    ///
    /// Parameter `inPacketDescs`: An array of packet descriptions. Applicable only for output queues and required only for
    /// variable-bit-rate (VBR) audio formats. Pass NULL for input queues (no packet
    /// descriptions are required).
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueEnqueueBuffer(
        in_aq: AudioQueueRef,
        in_buffer: AudioQueueBufferRef,
        in_num_packet_descs: u32,
        in_packet_descs: *const AudioStreamPacketDescription,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Assigns a buffer to an audio queue for playback, providing parameters
    /// and start time information.
    ///
    /// You can exert some control of the buffer queue by using this function. You can assign
    /// audio queue settings that are in effect carried by an audio queue buffer as you enqueue
    /// it. Hence, these changes only take effect when an audio queue buffer begins playing.
    ///
    /// This function queues a buffer for playback only, not for recording. Audio queues for
    /// recording have no parameters, do not support variable-bit-rate (VBR) formats (which
    /// might require trimming), and have a different way to handle timing. When queued for
    /// playback, the buffer must contain the audio data to be played back. See
    /// AudioQueueEnqueueBuffer for details on queuing a buffer for recording.
    ///
    /// If the buffer was allocated with AudioQueueAllocateBufferWithPacketDescriptions,
    /// the client should provide packet descriptions in the buffer's mPacketDescriptions
    /// and mPacketDescriptionCount fields rather than in inPacketDescs and
    /// inNumPacketDescs, which should be NULL and 0, respectively, in this case.
    ///
    ///
    /// Parameter `inAQ`: The audio queue associated with the buffer.
    ///
    /// Parameter `inBuffer`: The buffer to be played from.
    ///
    /// Parameter `inNumPacketDescs`: The number of packet descriptions pointed to by the inPacketDescs parameter. Required
    /// only for variable-bit-rate (VBR) audio formats. Pass 0 if no packet descriptions are
    /// required.
    ///
    /// Parameter `inPacketDescs`: A pointer to an array of audio stream packet descriptions. Required only for VBR audio
    /// formats. Pass NULL if no packet descriptions are required.
    ///
    /// Parameter `inTrimFramesAtStart`: The number of priming frames to skip at the start of the buffer.
    ///
    /// Parameter `inTrimFramesAtEnd`: The number of frames to skip at the end of the buffer.
    ///
    /// Parameter `inNumParamValues`: The number of parameter values pointed to by the inParamValues parameter.
    ///
    /// Parameter `inParamValues`: An array of parameter values. (In macOS v10.5, there is only one parameter,
    /// kAudioQueueParam_Volume.) These values are set before buffer playback and cannot be
    /// changed while the buffer is playing. How accurately changes in parameters can be
    /// scheduled depends on the size of the buffer. If there are no parameters to set
    /// (inNumParamValues = 0), pass NULL.
    ///
    /// Parameter `inStartTime`: A pointer to a structure containing the desired start time for playing the buffer. If
    /// you specify the time using the mSampleTime field of the AudioTimeStamp structure, the
    /// sample time is relative to the time the queue started. If you pass NULL for the start
    /// time, the buffer starts immediately after the previously queued buffer, or as soon as
    /// possible if no buffers are queued ahead of it. Buffers are played in the order they are
    /// queued. If multiple buffers are queued, their times must be in ascending order or NULL;
    /// otherwise, an error occurs. The start time indicates when the actual audio data in the
    /// buffer is to be played (that is, the trim frames are not counted).
    ///
    /// Note: When specifying a start time for a buffer, if the buffer is not the first enqueued
    /// since AudioQueueStop or AudioQueueReset, it is normally necessary to call AudioQueueFlush
    /// before AudioQueueEnqueueBufferWithParameters.
    ///
    /// Parameter `outActualStartTime`: On return, points to an AudioTimeStamp structure indicating when the buffer will
    /// actually play.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueEnqueueBufferWithParameters(
        in_aq: AudioQueueRef,
        in_buffer: AudioQueueBufferRef,
        in_num_packet_descs: u32,
        in_packet_descs: *const AudioStreamPacketDescription,
        in_trim_frames_at_start: u32,
        in_trim_frames_at_end: u32,
        in_num_param_values: u32,
        in_param_values: *const AudioQueueParameterEvent,
        in_start_time: *const AudioTimeStamp,
        out_actual_start_time: *mut AudioTimeStamp,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Begins playing or recording audio.
    ///
    /// If the audio hardware is not already running, this function starts it.
    ///
    ///
    /// Parameter `inAQ`: The audio queue to start.
    ///
    /// Parameter `inStartTime`: A pointer to the time at which the audio queue should start. If you specify the time
    /// using the mSampleTime field of the AudioTimeStamp structure, the sample time is
    /// referenced to the sample frame timeline of the associated audio device. May be NULL.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueStart(in_aq: AudioQueueRef, in_start_time: *const AudioTimeStamp) -> OSStatus;
}

extern "C-unwind" {
    /// Begins decoding buffers in preparation for playback.
    ///
    /// This function begins decoding buffers in preparation for playback. It returns when at
    /// least the number of audio sample frames are decoded and ready to play or when all
    /// enqueued buffers have been completely decoded. To ensure that a buffer has been decoded
    /// and is completely ready for playback, before playback:
    ///
    /// 1.  Call AudioQueueEnqueueBuffer.
    /// 2.  Call AudioQueuePrime, which waits if you pass 0 to have a default number of
    /// frames decoded.
    /// 3.  Call AudioQueueStart.
    ///
    /// Calls to AudioQueuePrime following AudioQueueStart/AudioQueuePrime, and before
    /// AudioQueueReset/AudioQueueStop, will have no useful effect. In this situation,
    /// outNumberOfFramesPrepared will not have a useful return value.
    ///
    ///
    /// Parameter `inAQ`: The audio queue to be primed.
    ///
    /// Parameter `inNumberOfFramesToPrepare`: The number of frames to decode before returning. Pass 0 to decode all enqueued buffers.
    ///
    /// Parameter `outNumberOfFramesPrepared`: If not NULL, on return, a pointer to the number of frames actually decoded and prepared
    /// for playback.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueuePrime(
        in_aq: AudioQueueRef,
        in_number_of_frames_to_prepare: u32,
        out_number_of_frames_prepared: *mut u32,
    ) -> OSStatus;
}

/// Stops playing or recording audio.
///
/// This function resets the audio queue and stops the audio hardware associated with the
/// queue if it is not in use by other audio services. Synchronous stops occur immediately,
/// regardless of previously buffered audio data. Asynchronous stops occur after all queued
/// buffers have been played or recorded.
///
///
/// Parameter `inAQ`: The audio queue to stop.
///
/// Parameter `inImmediate`: If you pass true, the stop request occurs immediately (that is, synchronously), and the
/// function returns when the audio queue has stopped. Buffer callbacks are invoked during
/// the stopping. If you pass false, the function returns immediately, but the queue does
/// not stop until all its queued buffers are played or filled (that is, the stop occurs
/// asynchronously). Buffer callbacks are invoked as necessary until the queue actually
/// stops. Also, a playback audio queue callback calls this function when there is no more
/// audio to play.
///
/// Note that when stopping immediately, all pending buffer callbacks are normally invoked
/// during the process of stopping. But if the calling thread is responding to a buffer
/// callback, then it is possible for additional buffer callbacks to occur after
/// AudioQueueStop returns.
///
/// Returns: An OSStatus result code.
#[inline]
pub unsafe extern "C-unwind" fn AudioQueueStop(
    in_aq: AudioQueueRef,
    in_immediate: bool,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioQueueStop(in_aq: AudioQueueRef, in_immediate: Boolean) -> OSStatus;
    }
    unsafe { AudioQueueStop(in_aq, in_immediate as _) }
}

extern "C-unwind" {
    /// Pauses audio playback or recording.
    ///
    /// Pausing the queue does not affect buffers or reset the audio queue. To resume playback
    /// or recording using the audio queue, call AudioQueueStart.
    ///
    ///
    /// Parameter `inAQ`: The queue to be paused.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueuePause(in_aq: AudioQueueRef) -> OSStatus;
}

extern "C-unwind" {
    /// Resets the audio queue's decoder state.
    ///
    /// After all queued buffers have been played, the function cleans up all decoder state
    /// information. You must call this function following a sequence of buffers of encoded
    /// audio; otherwise, some of the audio might not play in the next set of queued buffers.
    /// The only time it is not necessary to call AudioQueueFlush is following AudioQueueStop
    /// with inImmediate=false. (This action internally calls AudioQueueFlush.)
    ///
    /// Also, you might wish to call this function before calling AudioQueueStop depending on
    /// whether you want to stop immediately regardless of what has played or whether you want
    /// to ensure that all buffered data and all data that is in the middle of processing gets
    /// recorded or played before stopping.
    ///
    ///
    /// Parameter `inAQ`: The audio queue to be flushed.
    ///
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueFlush(in_aq: AudioQueueRef) -> OSStatus;
}

extern "C-unwind" {
    /// Resets an audio queue.
    ///
    /// This function immediately resets an audio queue, flushes any queued buffer, removes all
    /// buffers from previously scheduled use, and resets any decoder and digital signal
    /// processing (DSP) state information. It also invokes callbacks for any flushed buffers.
    /// If you queue any buffers after calling this function, processing does not occur until
    /// the decoder and DSP state information is reset. Hence, a discontinuity (that is, a
    /// "glitch") might occur.
    ///
    /// Note that when resetting, all pending buffer callbacks are normally invoked
    /// during the process of resetting. But if the calling thread is responding to a buffer
    /// callback, then it is possible for additional buffer callbacks to occur after
    /// AudioQueueReset returns.
    ///
    ///
    /// Parameter `inAQ`: The audio queue to reset.
    ///
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueReset(in_aq: AudioQueueRef) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains an audio queue parameter value.
    ///
    /// You can access the current parameter values for an audio queue at any time with this
    /// function.
    ///
    ///
    /// Parameter `inAQ`: The audio queue whose parameter value you want to obtain.
    ///
    /// Parameter `inParamID`: The ID of the parameter you want to obtain. In macOS v10.5, audio queues have one
    /// parameter available: kAudioQueueParam_Volume, which controls the queue's playback
    /// volume.
    ///
    /// Parameter `outValue`: On return, points to the current value of the specified parameter.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueGetParameter(
        in_aq: AudioQueueRef,
        in_param_id: AudioQueueParameterID,
        out_value: NonNull<AudioQueueParameterValue>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Sets an audio queue parameter value.
    ///
    /// Parameter `inAQ`: The audio queue whose parameter value you want to set.
    ///
    /// Parameter `inParamID`: The ID of the parameter you want to set.
    ///
    /// Parameter `inValue`: The parameter value to set.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueSetParameter(
        in_aq: AudioQueueRef,
        in_param_id: AudioQueueParameterID,
        in_value: AudioQueueParameterValue,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains an audio queue property value.
    ///
    /// Parameter `inAQ`: The audio queue whose property value you want to obtain.
    ///
    /// Parameter `inID`: The ID of the property you want to obtain. See "Audio Queue Property IDs."
    ///
    /// Parameter `outData`: On return, points to the desired property value.
    ///
    /// Parameter `ioDataSize`: A pointer to the size of the property data. On input, points to the maximum bytes of
    /// space the caller expects to receive. On return, points to the actual data size.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueGetProperty(
        in_aq: AudioQueueRef,
        in_id: AudioQueuePropertyID,
        out_data: NonNull<c_void>,
        io_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Sets an audio queue property value.
    ///
    /// Parameter `inAQ`: The audio queue whose property value you want to set.
    ///
    /// Parameter `inID`: The ID of the property you want to set. See "Audio Queue Property IDs" for the various
    /// audio queue properties.
    ///
    /// Parameter `inData`: A pointer to the property value to set.
    ///
    /// Parameter `inDataSize`: The size of the property data.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueSetProperty(
        in_aq: AudioQueueRef,
        in_id: AudioQueuePropertyID,
        in_data: NonNull<c_void>,
        in_data_size: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains the size of an audio queue property.
    ///
    /// Parameter `inAQ`: The audio queue containing the property value whose size you want to obtain.
    ///
    /// Parameter `inID`: The ID of the property value whose size you want to obtain. See "Audio Queue Property
    /// IDs" for possible values.
    ///
    /// Parameter `outDataSize`: On return, points to the size of the specified property value.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueGetPropertySize(
        in_aq: AudioQueueRef,
        in_id: AudioQueuePropertyID,
        out_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Adds a listener callback for a property.
    ///
    /// This callback is used to act upon a change in an audio queue property such as
    /// kAudioQueueProperty_IsRunning. For instance, if your application has a user interface
    /// with a Play/Stop button, and kAudioQueueProperty_IsRunning changes, you need to update
    /// your button.
    ///
    ///
    /// Parameter `inAQ`: The audio queue that owns the property you want to assign the listener callback to.
    ///
    /// Parameter `inID`: The ID of the property to which you want to assign a listener callback. See "Audio Queue Property IDs".
    ///
    /// Parameter `inProc`: The listener callback to be called when the property value changes.
    ///
    /// Parameter `inUserData`: A value to be passed to the listener callback when it is called.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueAddPropertyListener(
        in_aq: AudioQueueRef,
        in_id: AudioQueuePropertyID,
        in_proc: AudioQueuePropertyListenerProc,
        in_user_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Removes a listener callback for a property.
    ///
    /// Parameter `inAQ`: The audio queue that owns the property from which you want to remove a listener.
    ///
    /// Parameter `inID`: The ID of the property from which you want to remove a listener.
    ///
    /// Parameter `inProc`: The listener being removed.
    ///
    /// Parameter `inUserData`: The same inUserData value that was previously passed to AudioQueueAddPropertyListener.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueRemovePropertyListener(
        in_aq: AudioQueueRef,
        in_id: AudioQueuePropertyID,
        in_proc: AudioQueuePropertyListenerProc,
        in_user_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates a timeline object.
    ///
    /// You need to instantiate a timeline object if you want to know about any timeline
    /// discontinuities. See AudioQueueGetCurrentTime for more details.
    ///
    ///
    /// Parameter `inAQ`: The audio queue to associate with the new timeline object.
    ///
    /// Parameter `outTimeline`: On return, points to the newly created timeline object.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueCreateTimeline(
        in_aq: AudioQueueRef,
        out_timeline: NonNull<AudioQueueTimelineRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Disposes of a timeline object.
    ///
    /// Disposing of an audio queue automatically disposes of any associated timeline objects.
    /// Call this function only if you want to dispose of a timeline object and not the audio
    /// queue associated with it.
    ///
    ///
    /// Parameter `inAQ`: The audio queue associated with the timeline object you want to dispose of.
    ///
    /// Parameter `inTimeline`: The timeline object to dispose of.
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueDisposeTimeline(
        in_aq: AudioQueueRef,
        in_timeline: AudioQueueTimelineRef,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains the current audio queue time.
    ///
    /// You must specify a timeline object if you want to be notified about any timeline
    /// discontinuities in the outTimelineDiscontinuity parameter. If you don't care about
    /// discontinuities, pass NULL in the inTimeLine and outTimelineDiscontinuity parameters.
    ///
    ///
    /// Parameter `inAQ`: The audio queue whose current time you want to obtain.
    ///
    /// Parameter `inTimeline`: The audio queue timeline object to which any timeline discontinuities are reported. May
    /// be NULL.
    ///
    /// Parameter `outTimeStamp`: On return, points to an audio timestamp structure containing the current audio queue
    /// time. The mSampleTime field is in terms of the audio queue's sample rate, and relative
    /// to the time at which the queue has started or will start.
    ///
    /// Parameter `outTimelineDiscontinuity`: Can be NULL. On return, only set to true or false if the inTimeLine parameter is not
    /// NULL. Set to true if a discontinuity has occurred in the sample timeline of the audio
    /// queue. For instance, the device's sample rate changed and a gap occurred in playback or
    /// recording, or the audio queue was unable to prepare and playback in time because it was
    /// late.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueGetCurrentTime(
        in_aq: AudioQueueRef,
        in_timeline: AudioQueueTimelineRef,
        out_time_stamp: *mut AudioTimeStamp,
        out_timeline_discontinuity: *mut Boolean,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains the current time of the audio device associated with an audio queue.
    ///
    /// If the audio device associated with the audio queue is not running, the only valid field
    /// in the audio timestamp structure is mHostTime. This result differentiates the action of
    /// this function from that of the AudioDeviceGetCurrentTime function, (declared in
    /// AudioHardware.h) which returns an error if the audio device is not running.
    ///
    ///
    /// Parameter `inAQ`: The audio queue whose audio device is to be queried.
    ///
    /// Parameter `outTimeStamp`: A pointer to a structure that, on return, contains the current time of the audio device
    /// associated with the audio queue.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueDeviceGetCurrentTime(
        in_aq: AudioQueueRef,
        out_time_stamp: NonNull<AudioTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Converts the time in the time base of the associated audio device from one
    /// representation to another.
    ///
    /// This function converts from one time representation to another (for example, from sample
    /// time to host time or vice versa):
    ///
    /// - Sample time is the absolute sample frame time. Sample numbers are the count of the samples
    /// on the audio device.
    /// - Host time is the time base of the host machine such as the time of the bus clock on the CPU.
    ///
    /// The mSampleTime field in the AudioTimestamp structure (described in Core Audio Data
    /// Types Reference) is always in device time, not in audio queue time. Audio queue time is
    /// relative to the audio queue's start time. The associated audio device has to be running
    /// for the AudioQueueDeviceTranslateTime function to provide a result.
    ///
    ///
    /// Parameter `inAQ`: The queue whose audio device is to perform the requested time translation.
    ///
    /// Parameter `inTime`: A pointer to a structure containing the time to be translated.
    ///
    /// Parameter `outTime`: On entry, mFlags indicate the desired translations. On exit, mFlags indicates which
    /// of the requested translated fields were successfully populated.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueDeviceTranslateTime(
        in_aq: AudioQueueRef,
        in_time: NonNull<AudioTimeStamp>,
        out_time: NonNull<AudioTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtains an audio device's start time that is closest to a requested start time.
    ///
    /// Parameter `inAQ`: The audio queue whose device's nearest start time you want to obtain.
    ///
    /// Parameter `ioRequestedStartTime`: On entry, points to the requested start time. On return, points to the actual start time.
    ///
    /// Parameter `inFlags`: Reserved for future use. Pass 0.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueDeviceGetNearestStartTime(
        in_aq: AudioQueueRef,
        io_requested_start_time: NonNull<AudioTimeStamp>,
        in_flags: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Specify an audio format to which the queue will perform subsequent offline rendering,
    /// or disable offline rendering.
    ///
    /// An output queue's audio playback can be redirected for capture to an audio file,
    /// to support an export function, for example. AudioQueueSetOfflineRenderFormat switches
    /// a queue between normal and offline rendering modes.
    ///
    ///
    /// Parameter `inAQ`: The output queue whose offline rendering mode is to be changed.
    ///
    /// Parameter `inFormat`: The desired format for offline rendering. Pass NULL to disable offline rendering and return the
    /// queue to normal output to an audio device. This format must be linear PCM and (if not mono)
    /// interleaved.
    ///
    /// Parameter `inLayout`: The desired channel layout for offline rendering; also NULL when disabling offline rendering.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueSetOfflineRenderFormat(
        in_aq: AudioQueueRef,
        in_format: *const AudioStreamBasicDescription,
        in_layout: *const AudioChannelLayout,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Obtain a buffer of audio output from a queue in offline rendering mode.
    ///
    /// Parameter `inAQ`: The output queue from which to obtain output.
    ///
    /// Parameter `inTimestamp`: The point in time corresponding to the beginning of the output buffer. Only mSampleTime
    /// is used. mFlags must include kAudioTimeStampSampleTimeValid.
    ///
    /// Parameter `ioBuffer`: The buffer into which the queue will render.
    ///
    /// Parameter `inNumberFrames`: The number of frames of audio to render. Note that fewer frames than requested may be returned.
    /// This can happen if insufficient data was enqueued.
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueOfflineRender(
        in_aq: AudioQueueRef,
        in_timestamp: NonNull<AudioTimeStamp>,
        io_buffer: AudioQueueBufferRef,
        in_number_frames: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Create a new processing tap
    ///
    /// This function creates a processing tap on a given audio queue. A
    /// processing tap can only be established (or removed) on an audio queue that is
    /// stopped (paused is not sufficient). The processing tap will then be used to
    /// process either decoded data in the case of an output queue, or input data
    /// (before it is encoded) in the case of an input queue.
    ///
    /// The processing is performed on audio either before or after any effects or other
    /// processing (varispeed, etc) is applied by the audio queue, depending on inFlags.
    ///
    ///
    /// Parameter `inAQ`: The audio queue from which to create the processing tap
    ///
    /// Parameter `inCallback`: A callback which the queue will call to process the audio
    ///
    /// Parameter `inClientData`: Client data provided to the callback
    ///
    /// Parameter `inFlags`: Flags that are used to control aspects of the processing tap.
    /// Valid flags are:
    /// - kAudioQueueProcessingTap_PreEffects: processing is done before any
    /// further effects are applied by the audio queue to the audio
    /// - kAudioQueueProcessingTap_PostEffects: processing is done after all
    /// processing is done, including that of other taps.
    /// - kAudioQueueProcessingTap_Siphon
    ///
    /// Parameter `outMaxFrames`: The maximum number of sample frames that can be requested of a processing
    /// tap at any one time. Typically this will be approximately 50 msec of audio
    /// (2048 samples
    /// @
    /// 44.1kHz)
    ///
    /// Parameter `outProcessingFormat`: The format in which the client will receive the audio data to be processed.
    /// This will always be the same sample rate as the client format and usually
    /// the same number of channels as the client format of the audio queue. (NOTE:
    /// the number of channels may be different in some cases if the client format
    /// has some channel count restrictions, for instance the client provides 5.1
    /// AAC, but the decoder can only produce stereo). The channel order, if the
    /// same as the client format, will be the same as the client channel order. If
    /// the channel count is changed, it will be to either 1 (mono) or 2 (stereo, in
    /// which case the first channel is left, the second right).
    ///
    /// If the data is not in a convenient format for the client to process in, then
    /// the client should convert the data to and from that format. This is the most
    /// efficient mechanism to use (as the audio queue can chose a format that is
    /// most efficient from its playback (or recording) requirement.
    ///
    /// Parameter `outAQTap`: The processing tap object.
    ///
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueProcessingTapNew(
        in_aq: AudioQueueRef,
        in_callback: AudioQueueProcessingTapCallback,
        in_client_data: *mut c_void,
        in_flags: AudioQueueProcessingTapFlags,
        out_max_frames: NonNull<u32>,
        out_processing_format: NonNull<AudioStreamBasicDescription>,
        out_aq_tap: NonNull<AudioQueueProcessingTapRef>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Dispose a processing tap object
    ///
    /// As with AudioQueueProcessingTapNew(), this call can only be made on an
    /// audio queue that is stopped (paused is not sufficient)
    ///
    ///
    /// Parameter `inAQTap`: The processing tap to dispose.
    ///
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueProcessingTapDispose(in_aq_tap: AudioQueueProcessingTapRef) -> OSStatus;
}

extern "C-unwind" {
    /// Used by a processing tap to retrieve source audio.
    ///
    /// This function may only be called from the processing tap's callback.
    ///
    ///
    /// Parameter `inAQTap`: the processing tap
    ///
    /// Parameter `inNumberFrames`: the number of frames the processing tap requires for its processing
    ///
    /// Parameter `ioTimeStamp`: On an input audio queue, the timestamp is returned from this function.
    /// On an output audio queue, the caller must provide a continuous timestamp.
    ///
    /// Parameter `outFlags`: flags to describe state about the input requested, e.g.
    /// discontinuity/complete
    ///
    /// Parameter `outNumberFrames`: the number of source frames that have been provided by the parent audio
    /// queue. This can be less than the number of requested frames specified in
    /// inNumberFrames
    ///
    /// Parameter `ioData`: the audio buffer list which will contain the source data. The audio queue owns
    /// the buffer pointers if NULL pointers were provided (recommended). In this case
    /// the source buffers are only valid for the duration of the processing tap
    /// callback. If the buffer pointers are non-NULL, then they must be big enough to
    /// hold inNumberFrames, and the audio queue will copy its source data into those
    /// buffers.
    ///
    ///
    /// Returns: An OSStatus result code.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioQueueProcessingTapGetSourceAudio(
        in_aq_tap: AudioQueueProcessingTapRef,
        in_number_frames: u32,
        io_time_stamp: NonNull<AudioTimeStamp>,
        out_flags: NonNull<AudioQueueProcessingTapFlags>,
        out_number_frames: NonNull<u32>,
        io_data: NonNull<AudioBufferList>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Used by a processing tap to retrieve the queue's current time.
    ///
    /// This function may only be called from the processing tap's callback, and only
    /// for audio output queues. It must be called after calling
    /// AudioQueueProcessingTapGetSourceAudio().
    ///
    ///
    /// Parameter `inAQTap`: the processing tap
    ///
    /// Parameter `outQueueSampleTime`: the current sample time of the audio queue. This will appear to be stationary
    /// if the queue is paused.
    ///
    /// Parameter `outQueueFrameCount`: the number of sample frames of queue time corresponding to the current chunk of
    /// audio being processed by the tap. This will differ from the frame count passed
    /// to the tap if the queue's playback rate is currently other than 1.0, due to the
    /// use of time compression/expansion. The frame count can also be 0 if the queue is
    /// paused.
    ///
    ///
    /// Returns: An OSStatus result code.
    pub fn AudioQueueProcessingTapGetQueueTime(
        in_aq_tap: AudioQueueProcessingTapRef,
        out_queue_sample_time: NonNull<f64>,
        out_queue_frame_count: NonNull<u32>,
    ) -> OSStatus;
}
