// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_assume_role_with_saml_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::assume_role_with_saml::AssumeRoleWithSamlOutput,
    crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExpiredTokenException" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::ExpiredTokenException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::ExpiredTokenExceptionBuilder::default();
                output = crate::protocol_serde::shape_expired_token_exception::de_expired_token_exception_xml_err(_response_body, output)
                    .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "IDPRejectedClaim" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::IdpRejectedClaimException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::IdpRejectedClaimExceptionBuilder::default();
                output = crate::protocol_serde::shape_idp_rejected_claim_exception::de_idp_rejected_claim_exception_xml_err(_response_body, output)
                    .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "InvalidIdentityToken" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::InvalidIdentityTokenException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::InvalidIdentityTokenExceptionBuilder::default();
                output = crate::protocol_serde::shape_invalid_identity_token_exception::de_invalid_identity_token_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "MalformedPolicyDocument" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::MalformedPolicyDocumentException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::MalformedPolicyDocumentExceptionBuilder::default();
                output = crate::protocol_serde::shape_malformed_policy_document_exception::de_malformed_policy_document_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "PackedPolicyTooLarge" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::PackedPolicyTooLargeException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::PackedPolicyTooLargeExceptionBuilder::default();
                output = crate::protocol_serde::shape_packed_policy_too_large_exception::de_packed_policy_too_large_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "RegionDisabledException" => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::RegionDisabledException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::RegionDisabledExceptionBuilder::default();
                output = crate::protocol_serde::shape_region_disabled_exception::de_region_disabled_exception_xml_err(_response_body, output)
                    .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_assume_role_with_saml_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::assume_role_with_saml::AssumeRoleWithSamlOutput,
    crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::assume_role_with_saml::builders::AssumeRoleWithSamlOutputBuilder::default();
        output = crate::protocol_serde::shape_assume_role_with_saml::de_assume_role_with_saml(_response_body, output)
            .map_err(crate::operation::assume_role_with_saml::AssumeRoleWithSAMLError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

#[allow(unused_mut)]
pub fn de_assume_role_with_saml(
    inp: &[u8],
    mut builder: crate::operation::assume_role_with_saml::builders::AssumeRoleWithSamlOutputBuilder,
) -> std::result::Result<crate::operation::assume_role_with_saml::builders::AssumeRoleWithSamlOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError>
{
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !(start_el.matches("AssumeRoleWithSAMLResponse")) {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "invalid root, expected AssumeRoleWithSAMLResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("AssumeRoleWithSAMLResult")) {
            return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
                "invalid result, expected AssumeRoleWithSAMLResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Credentials") /* Credentials com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$Credentials */ =>  {
                let var_1 =
                    Some(
                        crate::protocol_serde::shape_credentials::de_credentials(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_credentials(var_1);
            }
            ,
            s if s.matches("AssumedRoleUser") /* AssumedRoleUser com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$AssumedRoleUser */ =>  {
                let var_2 =
                    Some(
                        crate::protocol_serde::shape_assumed_role_user::de_assumed_role_user(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_assumed_role_user(var_2);
            }
            ,
            s if s.matches("PackedPolicySize") /* PackedPolicySize com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$PackedPolicySize */ =>  {
                let var_3 =
                    Some(
                         {
                            <i32 as ::aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_packed_policy_size(var_3);
            }
            ,
            s if s.matches("Subject") /* Subject com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$Subject */ =>  {
                let var_4 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subject(var_4);
            }
            ,
            s if s.matches("SubjectType") /* SubjectType com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$SubjectType */ =>  {
                let var_5 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_subject_type(var_5);
            }
            ,
            s if s.matches("Issuer") /* Issuer com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$Issuer */ =>  {
                let var_6 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_issuer(var_6);
            }
            ,
            s if s.matches("Audience") /* Audience com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$Audience */ =>  {
                let var_7 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_audience(var_7);
            }
            ,
            s if s.matches("NameQualifier") /* NameQualifier com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$NameQualifier */ =>  {
                let var_8 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name_qualifier(var_8);
            }
            ,
            s if s.matches("SourceIdentity") /* SourceIdentity com.amazonaws.sts.synthetic#AssumeRoleWithSAMLOutput$SourceIdentity */ =>  {
                let var_9 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_identity(var_9);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom("expected AssumeRoleWithSAMLResult tag"));
    };
    Ok(builder)
}
