// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The journal table record expiration settings for a journal table in an S3 Metadata configuration.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RecordExpiration {
    /// <p>Specifies whether journal table record expiration is enabled or disabled.</p>
    pub expiration: crate::types::ExpirationState,
    /// <p>If you enable journal table record expiration, you can set the number of days to retain your journal table records. Journal table records must be retained for a minimum of 7 days. To set this value, specify any whole number from <code>7</code> to <code>2147483647</code>. For example, to retain your journal table records for one year, set this value to <code>365</code>.</p>
    pub days: ::std::option::Option<i32>,
}
impl RecordExpiration {
    /// <p>Specifies whether journal table record expiration is enabled or disabled.</p>
    pub fn expiration(&self) -> &crate::types::ExpirationState {
        &self.expiration
    }
    /// <p>If you enable journal table record expiration, you can set the number of days to retain your journal table records. Journal table records must be retained for a minimum of 7 days. To set this value, specify any whole number from <code>7</code> to <code>2147483647</code>. For example, to retain your journal table records for one year, set this value to <code>365</code>.</p>
    pub fn days(&self) -> ::std::option::Option<i32> {
        self.days
    }
}
impl RecordExpiration {
    /// Creates a new builder-style object to manufacture [`RecordExpiration`](crate::types::RecordExpiration).
    pub fn builder() -> crate::types::builders::RecordExpirationBuilder {
        crate::types::builders::RecordExpirationBuilder::default()
    }
}

/// A builder for [`RecordExpiration`](crate::types::RecordExpiration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RecordExpirationBuilder {
    pub(crate) expiration: ::std::option::Option<crate::types::ExpirationState>,
    pub(crate) days: ::std::option::Option<i32>,
}
impl RecordExpirationBuilder {
    /// <p>Specifies whether journal table record expiration is enabled or disabled.</p>
    /// This field is required.
    pub fn expiration(mut self, input: crate::types::ExpirationState) -> Self {
        self.expiration = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether journal table record expiration is enabled or disabled.</p>
    pub fn set_expiration(mut self, input: ::std::option::Option<crate::types::ExpirationState>) -> Self {
        self.expiration = input;
        self
    }
    /// <p>Specifies whether journal table record expiration is enabled or disabled.</p>
    pub fn get_expiration(&self) -> &::std::option::Option<crate::types::ExpirationState> {
        &self.expiration
    }
    /// <p>If you enable journal table record expiration, you can set the number of days to retain your journal table records. Journal table records must be retained for a minimum of 7 days. To set this value, specify any whole number from <code>7</code> to <code>2147483647</code>. For example, to retain your journal table records for one year, set this value to <code>365</code>.</p>
    pub fn days(mut self, input: i32) -> Self {
        self.days = ::std::option::Option::Some(input);
        self
    }
    /// <p>If you enable journal table record expiration, you can set the number of days to retain your journal table records. Journal table records must be retained for a minimum of 7 days. To set this value, specify any whole number from <code>7</code> to <code>2147483647</code>. For example, to retain your journal table records for one year, set this value to <code>365</code>.</p>
    pub fn set_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.days = input;
        self
    }
    /// <p>If you enable journal table record expiration, you can set the number of days to retain your journal table records. Journal table records must be retained for a minimum of 7 days. To set this value, specify any whole number from <code>7</code> to <code>2147483647</code>. For example, to retain your journal table records for one year, set this value to <code>365</code>.</p>
    pub fn get_days(&self) -> &::std::option::Option<i32> {
        &self.days
    }
    /// Consumes the builder and constructs a [`RecordExpiration`](crate::types::RecordExpiration).
    /// This method will fail if any of the following fields are not set:
    /// - [`expiration`](crate::types::builders::RecordExpirationBuilder::expiration)
    pub fn build(self) -> ::std::result::Result<crate::types::RecordExpiration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RecordExpiration {
            expiration: self.expiration.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "expiration",
                    "expiration was not specified but it is required when building RecordExpiration",
                )
            })?,
            days: self.days,
        })
    }
}
