// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_rename_object_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::rename_object::RenameObjectOutput, crate::operation::rename_object::RenameObjectError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::rename_object::RenameObjectError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::rename_object::RenameObjectError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotencyParameterMismatch" => crate::operation::rename_object::RenameObjectError::IdempotencyParameterMismatch({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::IdempotencyParameterMismatchBuilder::default();
                output =
                    crate::protocol_serde::shape_idempotency_parameter_mismatch::de_idempotency_parameter_mismatch_xml_err(_response_body, output)
                        .map_err(crate::operation::rename_object::RenameObjectError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::rename_object::RenameObjectError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_rename_object_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::rename_object::RenameObjectOutput, crate::operation::rename_object::RenameObjectError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::rename_object::builders::RenameObjectOutputBuilder::default();
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_rename_object_headers(
    input: &crate::operation::rename_object::RenameObjectInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.rename_source {
        let formatted_2 = inner_1.as_str();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "rename_source",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-rename-source", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.destination_if_match {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "destination_if_match",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("If-Match", header_value);
    }
    if let ::std::option::Option::Some(inner_5) = &input.destination_if_none_match {
        let formatted_6 = inner_5.as_str();
        let header_value = formatted_6;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "destination_if_none_match",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("If-None-Match", header_value);
    }
    if let ::std::option::Option::Some(inner_7) = &input.destination_if_modified_since {
        let formatted_8 = inner_7.fmt(::aws_smithy_types::date_time::Format::HttpDate)?;
        let header_value = formatted_8;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "destination_if_modified_since",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("If-Modified-Since", header_value);
    }
    if let ::std::option::Option::Some(inner_9) = &input.destination_if_unmodified_since {
        let formatted_10 = inner_9.fmt(::aws_smithy_types::date_time::Format::HttpDate)?;
        let header_value = formatted_10;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "destination_if_unmodified_since",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("If-Unmodified-Since", header_value);
    }
    if let ::std::option::Option::Some(inner_11) = &input.source_if_match {
        let formatted_12 = inner_11.as_str();
        let header_value = formatted_12;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "source_if_match",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-rename-source-if-match", header_value);
    }
    if let ::std::option::Option::Some(inner_13) = &input.source_if_none_match {
        let formatted_14 = inner_13.as_str();
        let header_value = formatted_14;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "source_if_none_match",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-rename-source-if-none-match", header_value);
    }
    if let ::std::option::Option::Some(inner_15) = &input.source_if_modified_since {
        let formatted_16 = inner_15.fmt(::aws_smithy_types::date_time::Format::HttpDate)?;
        let header_value = formatted_16;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "source_if_modified_since",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-rename-source-if-modified-since", header_value);
    }
    if let ::std::option::Option::Some(inner_17) = &input.source_if_unmodified_since {
        let formatted_18 = inner_17.fmt(::aws_smithy_types::date_time::Format::HttpDate)?;
        let header_value = formatted_18;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "source_if_unmodified_since",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-rename-source-if-unmodified-since", header_value);
    }
    if let ::std::option::Option::Some(inner_19) = &input.client_token {
        let formatted_20 = inner_19.as_str();
        let header_value = formatted_20;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "client_token",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-client-token", header_value);
    }
    Ok(builder)
}
