// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketEncryption`](crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket from which the server-side encryption configuration is retrieved.</p> <p><b>Directory buckets </b> - When you use this operation with a directory bucket, you must use path-style requests in the format <code>https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i></p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><note>  <p>For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code <code>501 Not Implemented</code>.</p> </note><br>
    /// - On success, responds with [`GetBucketEncryptionOutput`](crate::operation::get_bucket_encryption::GetBucketEncryptionOutput) with field(s):
    ///   - [`server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::operation::get_bucket_encryption::GetBucketEncryptionOutput::server_side_encryption_configuration): <p>Specifies the default server-side-encryption configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketEncryptionError>`](crate::operation::get_bucket_encryption::GetBucketEncryptionError)
    pub fn get_bucket_encryption(&self) -> crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder {
        crate::operation::get_bucket_encryption::builders::GetBucketEncryptionFluentBuilder::new(self.handle.clone())
    }
}
