// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::types::error::_resource_not_found_exception::ResourceNotFoundException;

pub use crate::types::error::_resource_in_use_exception::ResourceInUseException;

pub use crate::types::error::_limit_exceeded_exception::LimitExceededException;

pub use crate::types::error::_invalid_argument_exception::InvalidArgumentException;

pub use crate::types::error::_validation_exception::ValidationException;

pub use crate::types::error::_access_denied_exception::AccessDeniedException;

pub use crate::types::error::_internal_failure_exception::InternalFailureException;

pub use crate::types::error::_kms_throttling_exception::KmsThrottlingException;

pub use crate::types::error::_kms_opt_in_required::KmsOptInRequired;

pub use crate::types::error::_kms_not_found_exception::KmsNotFoundException;

pub use crate::types::error::_kms_access_denied_exception::KmsAccessDeniedException;

pub use crate::types::error::_kms_invalid_state_exception::KmsInvalidStateException;

pub use crate::types::error::_kms_disabled_exception::KmsDisabledException;

/// Error type for the `SubscribeToShardEventStreamError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum SubscribeToShardEventStreamError {
    /// <p>The requested resource could not be found. The stream might not be specified correctly.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>The resource is not available for this operation. For successful operation, the resource must be in the <code>ACTIVE</code> state.</p>
    ResourceInUseException(crate::types::error::ResourceInUseException),
    /// <p>The request was rejected because the specified customer master key (CMK) isn't enabled.</p>
    KmsDisabledException(crate::types::error::KmsDisabledException),
    /// <p>The request was rejected because the state of the specified resource isn't valid for this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a Customer Master Key</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    KmsInvalidStateException(crate::types::error::KmsInvalidStateException),
    /// <p>The ciphertext references a key that doesn't exist or that you don't have access to.</p>
    KmsAccessDeniedException(crate::types::error::KmsAccessDeniedException),
    /// <p>The request was rejected because the specified entity or resource can't be found.</p>
    KmsNotFoundException(crate::types::error::KmsNotFoundException),
    /// <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
    KmsOptInRequired(crate::types::error::KmsOptInRequired),
    /// <p>The request was denied due to request throttling. For more information about throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    KmsThrottlingException(crate::types::error::KmsThrottlingException),
    /// <p>The processing of the request failed because of an unknown error, exception, or failure.</p>
    InternalFailureException(crate::types::error::InternalFailureException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-SubscribeToShardEventStreamError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl SubscribeToShardEventStreamError {
    /// Creates the `SubscribeToShardEventStreamError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `SubscribeToShardEventStreamError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::ResourceNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::ResourceInUseException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsDisabledException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsInvalidStateException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsAccessDeniedException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsOptInRequired(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::KmsThrottlingException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InternalFailureException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::Unhandled(e) => &e.meta,
        }
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(self, Self::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(self, Self::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(self, Self::KmsDisabledException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(self, Self::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(self, Self::KmsAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(self, Self::KmsNotFoundException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsOptInRequired`.
    pub fn is_kms_opt_in_required(&self) -> bool {
        matches!(self, Self::KmsOptInRequired(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::KmsThrottlingException`.
    pub fn is_kms_throttling_exception(&self) -> bool {
        matches!(self, Self::KmsThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SubscribeToShardEventStreamError::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(self, Self::InternalFailureException(_))
    }
}
impl ::std::error::Error for SubscribeToShardEventStreamError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::ResourceNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::ResourceInUseException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsDisabledException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsInvalidStateException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsAccessDeniedException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsOptInRequired(_inner) => ::std::option::Option::Some(_inner),
            Self::KmsThrottlingException(_inner) => ::std::option::Option::Some(_inner),
            Self::InternalFailureException(_inner) => ::std::option::Option::Some(_inner),
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for SubscribeToShardEventStreamError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::ResourceNotFoundException(_inner) => _inner.fmt(f),
            Self::ResourceInUseException(_inner) => _inner.fmt(f),
            Self::KmsDisabledException(_inner) => _inner.fmt(f),
            Self::KmsInvalidStateException(_inner) => _inner.fmt(f),
            Self::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            Self::KmsNotFoundException(_inner) => _inner.fmt(f),
            Self::KmsOptInRequired(_inner) => _inner.fmt(f),
            Self::KmsThrottlingException(_inner) => _inner.fmt(f),
            Self::InternalFailureException(_inner) => _inner.fmt(f),
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for SubscribeToShardEventStreamError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for SubscribeToShardEventStreamError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::ResourceNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::ResourceInUseException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsDisabledException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsInvalidStateException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsAccessDeniedException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsOptInRequired(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::KmsThrottlingException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InternalFailureException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for SubscribeToShardEventStreamError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl ::aws_types::request_id::RequestId for crate::types::error::SubscribeToShardEventStreamError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::types::error::_provisioned_throughput_exceeded_exception::ProvisionedThroughputExceededException;

pub use crate::types::error::_expired_next_token_exception::ExpiredNextTokenException;

pub use crate::types::error::_expired_iterator_exception::ExpiredIteratorException;

mod _access_denied_exception;

mod _expired_iterator_exception;

mod _expired_next_token_exception;

mod _internal_failure_exception;

mod _invalid_argument_exception;

mod _kms_access_denied_exception;

mod _kms_disabled_exception;

mod _kms_invalid_state_exception;

mod _kms_not_found_exception;

mod _kms_opt_in_required;

mod _kms_throttling_exception;

mod _limit_exceeded_exception;

mod _provisioned_throughput_exceeded_exception;

mod _resource_in_use_exception;

mod _resource_not_found_exception;

mod _validation_exception;

/// Builders
pub mod builders;
