// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents the input for <code>ListStreams</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ListStreamsInput {
    /// <p>The maximum number of streams to list. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p>
    pub limit: ::std::option::Option<i32>,
    /// <p>The name of the stream to start the list with.</p>
    pub exclusive_start_stream_name: ::std::option::Option<::std::string::String>,
    /// <p></p>
    pub next_token: ::std::option::Option<::std::string::String>,
}
impl ListStreamsInput {
    /// <p>The maximum number of streams to list. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p>
    pub fn limit(&self) -> ::std::option::Option<i32> {
        self.limit
    }
    /// <p>The name of the stream to start the list with.</p>
    pub fn exclusive_start_stream_name(&self) -> ::std::option::Option<&str> {
        self.exclusive_start_stream_name.as_deref()
    }
    /// <p></p>
    pub fn next_token(&self) -> ::std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl ListStreamsInput {
    /// Creates a new builder-style object to manufacture [`ListStreamsInput`](crate::operation::list_streams::ListStreamsInput).
    pub fn builder() -> crate::operation::list_streams::builders::ListStreamsInputBuilder {
        crate::operation::list_streams::builders::ListStreamsInputBuilder::default()
    }
}

/// A builder for [`ListStreamsInput`](crate::operation::list_streams::ListStreamsInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ListStreamsInputBuilder {
    pub(crate) limit: ::std::option::Option<i32>,
    pub(crate) exclusive_start_stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) next_token: ::std::option::Option<::std::string::String>,
}
impl ListStreamsInputBuilder {
    /// <p>The maximum number of streams to list. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p>
    pub fn limit(mut self, input: i32) -> Self {
        self.limit = ::std::option::Option::Some(input);
        self
    }
    /// <p>The maximum number of streams to list. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p>
    pub fn set_limit(mut self, input: ::std::option::Option<i32>) -> Self {
        self.limit = input;
        self
    }
    /// <p>The maximum number of streams to list. The default value is 100. If you specify a value greater than 100, at most 100 results are returned.</p>
    pub fn get_limit(&self) -> &::std::option::Option<i32> {
        &self.limit
    }
    /// <p>The name of the stream to start the list with.</p>
    pub fn exclusive_start_stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.exclusive_start_stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream to start the list with.</p>
    pub fn set_exclusive_start_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.exclusive_start_stream_name = input;
        self
    }
    /// <p>The name of the stream to start the list with.</p>
    pub fn get_exclusive_start_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.exclusive_start_stream_name
    }
    /// <p></p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.next_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p></p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.next_token = input;
        self
    }
    /// <p></p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.next_token
    }
    /// Consumes the builder and constructs a [`ListStreamsInput`](crate::operation::list_streams::ListStreamsInput).
    pub fn build(self) -> ::std::result::Result<crate::operation::list_streams::ListStreamsInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::list_streams::ListStreamsInput {
            limit: self.limit,
            exclusive_start_stream_name: self.exclusive_start_stream_name,
            next_token: self.next_token,
        })
    }
}
