// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DescribeStreamConsumerInput {
    /// <p>The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The name that you gave to the consumer.</p>
    pub consumer_name: ::std::option::Option<::std::string::String>,
    /// <p>The ARN returned by Kinesis Data Streams when you registered the consumer.</p>
    pub consumer_arn: ::std::option::Option<::std::string::String>,
}
impl DescribeStreamConsumerInput {
    /// <p>The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The name that you gave to the consumer.</p>
    pub fn consumer_name(&self) -> ::std::option::Option<&str> {
        self.consumer_name.as_deref()
    }
    /// <p>The ARN returned by Kinesis Data Streams when you registered the consumer.</p>
    pub fn consumer_arn(&self) -> ::std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
}
impl DescribeStreamConsumerInput {
    /// Creates a new builder-style object to manufacture [`DescribeStreamConsumerInput`](crate::operation::describe_stream_consumer::DescribeStreamConsumerInput).
    pub fn builder() -> crate::operation::describe_stream_consumer::builders::DescribeStreamConsumerInputBuilder {
        crate::operation::describe_stream_consumer::builders::DescribeStreamConsumerInputBuilder::default()
    }
}

/// A builder for [`DescribeStreamConsumerInput`](crate::operation::describe_stream_consumer::DescribeStreamConsumerInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DescribeStreamConsumerInputBuilder {
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) consumer_name: ::std::option::Option<::std::string::String>,
    pub(crate) consumer_arn: ::std::option::Option<::std::string::String>,
}
impl DescribeStreamConsumerInputBuilder {
    /// <p>The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The name that you gave to the consumer.</p>
    pub fn consumer_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.consumer_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name that you gave to the consumer.</p>
    pub fn set_consumer_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.consumer_name = input;
        self
    }
    /// <p>The name that you gave to the consumer.</p>
    pub fn get_consumer_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.consumer_name
    }
    /// <p>The ARN returned by Kinesis Data Streams when you registered the consumer.</p>
    pub fn consumer_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.consumer_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN returned by Kinesis Data Streams when you registered the consumer.</p>
    pub fn set_consumer_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.consumer_arn = input;
        self
    }
    /// <p>The ARN returned by Kinesis Data Streams when you registered the consumer.</p>
    pub fn get_consumer_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.consumer_arn
    }
    /// Consumes the builder and constructs a [`DescribeStreamConsumerInput`](crate::operation::describe_stream_consumer::DescribeStreamConsumerInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::describe_stream_consumer::DescribeStreamConsumerInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::describe_stream_consumer::DescribeStreamConsumerInput {
            stream_arn: self.stream_arn,
            consumer_name: self.consumer_name,
            consumer_arn: self.consumer_arn,
        })
    }
}
