// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An error occurred while streaming the response. Retry your request.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ModelStreamErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: ::std::option::Option<::std::string::String>,
    /// <p>The original status code.</p>
    pub original_status_code: ::std::option::Option<i32>,
    /// <p>The original message.</p>
    pub original_message: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl ModelStreamErrorException {
    /// <p>The original status code.</p>
    pub fn original_status_code(&self) -> ::std::option::Option<i32> {
        self.original_status_code
    }
    /// <p>The original message.</p>
    pub fn original_message(&self) -> ::std::option::Option<&str> {
        self.original_message.as_deref()
    }
}
impl ModelStreamErrorException {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for ModelStreamErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "ModelStreamErrorException")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {}", inner_1)?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for ModelStreamErrorException {}
impl ::aws_types::request_id::RequestId for crate::types::error::ModelStreamErrorException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for ModelStreamErrorException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl ModelStreamErrorException {
    /// Creates a new builder-style object to manufacture [`ModelStreamErrorException`](crate::types::error::ModelStreamErrorException).
    pub fn builder() -> crate::types::error::builders::ModelStreamErrorExceptionBuilder {
        crate::types::error::builders::ModelStreamErrorExceptionBuilder::default()
    }
}

/// A builder for [`ModelStreamErrorException`](crate::types::error::ModelStreamErrorException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ModelStreamErrorExceptionBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    pub(crate) original_status_code: ::std::option::Option<i32>,
    pub(crate) original_message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl ModelStreamErrorExceptionBuilder {
    #[allow(missing_docs)] // documentation missing in model
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// <p>The original status code.</p>
    pub fn original_status_code(mut self, input: i32) -> Self {
        self.original_status_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The original status code.</p>
    pub fn set_original_status_code(mut self, input: ::std::option::Option<i32>) -> Self {
        self.original_status_code = input;
        self
    }
    /// <p>The original status code.</p>
    pub fn get_original_status_code(&self) -> &::std::option::Option<i32> {
        &self.original_status_code
    }
    /// <p>The original message.</p>
    pub fn original_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.original_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The original message.</p>
    pub fn set_original_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.original_message = input;
        self
    }
    /// <p>The original message.</p>
    pub fn get_original_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.original_message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`ModelStreamErrorException`](crate::types::error::ModelStreamErrorException).
    pub fn build(self) -> crate::types::error::ModelStreamErrorException {
        crate::types::error::ModelStreamErrorException {
            message: self.message,
            original_status_code: self.original_status_code,
            original_message: self.original_message,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
