// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The source for an image.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum ImageSource {
    /// <p>The raw image bytes for the image. If you use an AWS SDK, you don't need to encode the image bytes in base64.</p>
    Bytes(::aws_smithy_types::Blob),
    /// <p>The location of an image object in an Amazon S3 bucket. To see which models support S3 uploads, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html">Supported models and features for Converse</a>.</p>
    S3Location(crate::types::S3Location),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ImageSource {
    /// Tries to convert the enum instance into [`Bytes`](crate::types::ImageSource::Bytes), extracting the inner [`Blob`](::aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bytes(&self) -> ::std::result::Result<&::aws_smithy_types::Blob, &Self> {
        if let ImageSource::Bytes(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Bytes`](crate::types::ImageSource::Bytes).
    pub fn is_bytes(&self) -> bool {
        self.as_bytes().is_ok()
    }
    /// Tries to convert the enum instance into [`S3Location`](crate::types::ImageSource::S3Location), extracting the inner [`S3Location`](crate::types::S3Location).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_location(&self) -> ::std::result::Result<&crate::types::S3Location, &Self> {
        if let ImageSource::S3Location(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`S3Location`](crate::types::ImageSource::S3Location).
    pub fn is_s3_location(&self) -> bool {
        self.as_s3_location().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
