// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Identifies logical issues in the translated statements that exist independent of any policy rules, such as statements that are always true or always false.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailAutomatedReasoningLogicWarning {
    /// <p>The category of the detected logical issue, such as statements that are always true or always false.</p>
    pub r#type: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarningType>,
    /// <p>The logical statements that serve as premises under which the claims are validated.</p>
    pub premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    /// <p>The logical statements that are validated while assuming the policy and premises.</p>
    pub claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
}
impl GuardrailAutomatedReasoningLogicWarning {
    /// <p>The category of the detected logical issue, such as statements that are always true or always false.</p>
    pub fn r#type(&self) -> ::std::option::Option<&crate::types::GuardrailAutomatedReasoningLogicWarningType> {
        self.r#type.as_ref()
    }
    /// <p>The logical statements that serve as premises under which the claims are validated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.premises.is_none()`.
    pub fn premises(&self) -> &[crate::types::GuardrailAutomatedReasoningStatement] {
        self.premises.as_deref().unwrap_or_default()
    }
    /// <p>The logical statements that are validated while assuming the policy and premises.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.claims.is_none()`.
    pub fn claims(&self) -> &[crate::types::GuardrailAutomatedReasoningStatement] {
        self.claims.as_deref().unwrap_or_default()
    }
}
impl GuardrailAutomatedReasoningLogicWarning {
    /// Creates a new builder-style object to manufacture [`GuardrailAutomatedReasoningLogicWarning`](crate::types::GuardrailAutomatedReasoningLogicWarning).
    pub fn builder() -> crate::types::builders::GuardrailAutomatedReasoningLogicWarningBuilder {
        crate::types::builders::GuardrailAutomatedReasoningLogicWarningBuilder::default()
    }
}

/// A builder for [`GuardrailAutomatedReasoningLogicWarning`](crate::types::GuardrailAutomatedReasoningLogicWarning).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailAutomatedReasoningLogicWarningBuilder {
    pub(crate) r#type: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarningType>,
    pub(crate) premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    pub(crate) claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
}
impl GuardrailAutomatedReasoningLogicWarningBuilder {
    /// <p>The category of the detected logical issue, such as statements that are always true or always false.</p>
    pub fn r#type(mut self, input: crate::types::GuardrailAutomatedReasoningLogicWarningType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The category of the detected logical issue, such as statements that are always true or always false.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarningType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The category of the detected logical issue, such as statements that are always true or always false.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::GuardrailAutomatedReasoningLogicWarningType> {
        &self.r#type
    }
    /// Appends an item to `premises`.
    ///
    /// To override the contents of this collection use [`set_premises`](Self::set_premises).
    ///
    /// <p>The logical statements that serve as premises under which the claims are validated.</p>
    pub fn premises(mut self, input: crate::types::GuardrailAutomatedReasoningStatement) -> Self {
        let mut v = self.premises.unwrap_or_default();
        v.push(input);
        self.premises = ::std::option::Option::Some(v);
        self
    }
    /// <p>The logical statements that serve as premises under which the claims are validated.</p>
    pub fn set_premises(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>) -> Self {
        self.premises = input;
        self
    }
    /// <p>The logical statements that serve as premises under which the claims are validated.</p>
    pub fn get_premises(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>> {
        &self.premises
    }
    /// Appends an item to `claims`.
    ///
    /// To override the contents of this collection use [`set_claims`](Self::set_claims).
    ///
    /// <p>The logical statements that are validated while assuming the policy and premises.</p>
    pub fn claims(mut self, input: crate::types::GuardrailAutomatedReasoningStatement) -> Self {
        let mut v = self.claims.unwrap_or_default();
        v.push(input);
        self.claims = ::std::option::Option::Some(v);
        self
    }
    /// <p>The logical statements that are validated while assuming the policy and premises.</p>
    pub fn set_claims(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>) -> Self {
        self.claims = input;
        self
    }
    /// <p>The logical statements that are validated while assuming the policy and premises.</p>
    pub fn get_claims(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>> {
        &self.claims
    }
    /// Consumes the builder and constructs a [`GuardrailAutomatedReasoningLogicWarning`](crate::types::GuardrailAutomatedReasoningLogicWarning).
    pub fn build(self) -> crate::types::GuardrailAutomatedReasoningLogicWarning {
        crate::types::GuardrailAutomatedReasoningLogicWarning {
            r#type: self.r#type,
            premises: self.premises,
            claims: self.claims,
        }
    }
}
