// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ApplyGuardrailOutput {
    /// <p>The usage details in the response from the guardrail.</p>
    pub usage: ::std::option::Option<crate::types::GuardrailUsage>,
    /// <p>The action taken in the response from the guardrail.</p>
    pub action: crate::types::GuardrailAction,
    /// <p>The reason for the action taken when harmful content is detected.</p>
    pub action_reason: ::std::option::Option<::std::string::String>,
    /// <p>The output details in the response from the guardrail.</p>
    pub outputs: ::std::vec::Vec<crate::types::GuardrailOutputContent>,
    /// <p>The assessment details in the response from the guardrail.</p>
    pub assessments: ::std::vec::Vec<crate::types::GuardrailAssessment>,
    /// <p>The guardrail coverage details in the apply guardrail response.</p>
    pub guardrail_coverage: ::std::option::Option<crate::types::GuardrailCoverage>,
    _request_id: Option<String>,
}
impl ApplyGuardrailOutput {
    /// <p>The usage details in the response from the guardrail.</p>
    pub fn usage(&self) -> ::std::option::Option<&crate::types::GuardrailUsage> {
        self.usage.as_ref()
    }
    /// <p>The action taken in the response from the guardrail.</p>
    pub fn action(&self) -> &crate::types::GuardrailAction {
        &self.action
    }
    /// <p>The reason for the action taken when harmful content is detected.</p>
    pub fn action_reason(&self) -> ::std::option::Option<&str> {
        self.action_reason.as_deref()
    }
    /// <p>The output details in the response from the guardrail.</p>
    pub fn outputs(&self) -> &[crate::types::GuardrailOutputContent] {
        use std::ops::Deref;
        self.outputs.deref()
    }
    /// <p>The assessment details in the response from the guardrail.</p>
    pub fn assessments(&self) -> &[crate::types::GuardrailAssessment] {
        use std::ops::Deref;
        self.assessments.deref()
    }
    /// <p>The guardrail coverage details in the apply guardrail response.</p>
    pub fn guardrail_coverage(&self) -> ::std::option::Option<&crate::types::GuardrailCoverage> {
        self.guardrail_coverage.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for ApplyGuardrailOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl ApplyGuardrailOutput {
    /// Creates a new builder-style object to manufacture [`ApplyGuardrailOutput`](crate::operation::apply_guardrail::ApplyGuardrailOutput).
    pub fn builder() -> crate::operation::apply_guardrail::builders::ApplyGuardrailOutputBuilder {
        crate::operation::apply_guardrail::builders::ApplyGuardrailOutputBuilder::default()
    }
}

/// A builder for [`ApplyGuardrailOutput`](crate::operation::apply_guardrail::ApplyGuardrailOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ApplyGuardrailOutputBuilder {
    pub(crate) usage: ::std::option::Option<crate::types::GuardrailUsage>,
    pub(crate) action: ::std::option::Option<crate::types::GuardrailAction>,
    pub(crate) action_reason: ::std::option::Option<::std::string::String>,
    pub(crate) outputs: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailOutputContent>>,
    pub(crate) assessments: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAssessment>>,
    pub(crate) guardrail_coverage: ::std::option::Option<crate::types::GuardrailCoverage>,
    _request_id: Option<String>,
}
impl ApplyGuardrailOutputBuilder {
    /// <p>The usage details in the response from the guardrail.</p>
    /// This field is required.
    pub fn usage(mut self, input: crate::types::GuardrailUsage) -> Self {
        self.usage = ::std::option::Option::Some(input);
        self
    }
    /// <p>The usage details in the response from the guardrail.</p>
    pub fn set_usage(mut self, input: ::std::option::Option<crate::types::GuardrailUsage>) -> Self {
        self.usage = input;
        self
    }
    /// <p>The usage details in the response from the guardrail.</p>
    pub fn get_usage(&self) -> &::std::option::Option<crate::types::GuardrailUsage> {
        &self.usage
    }
    /// <p>The action taken in the response from the guardrail.</p>
    /// This field is required.
    pub fn action(mut self, input: crate::types::GuardrailAction) -> Self {
        self.action = ::std::option::Option::Some(input);
        self
    }
    /// <p>The action taken in the response from the guardrail.</p>
    pub fn set_action(mut self, input: ::std::option::Option<crate::types::GuardrailAction>) -> Self {
        self.action = input;
        self
    }
    /// <p>The action taken in the response from the guardrail.</p>
    pub fn get_action(&self) -> &::std::option::Option<crate::types::GuardrailAction> {
        &self.action
    }
    /// <p>The reason for the action taken when harmful content is detected.</p>
    pub fn action_reason(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.action_reason = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The reason for the action taken when harmful content is detected.</p>
    pub fn set_action_reason(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.action_reason = input;
        self
    }
    /// <p>The reason for the action taken when harmful content is detected.</p>
    pub fn get_action_reason(&self) -> &::std::option::Option<::std::string::String> {
        &self.action_reason
    }
    /// Appends an item to `outputs`.
    ///
    /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
    ///
    /// <p>The output details in the response from the guardrail.</p>
    pub fn outputs(mut self, input: crate::types::GuardrailOutputContent) -> Self {
        let mut v = self.outputs.unwrap_or_default();
        v.push(input);
        self.outputs = ::std::option::Option::Some(v);
        self
    }
    /// <p>The output details in the response from the guardrail.</p>
    pub fn set_outputs(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailOutputContent>>) -> Self {
        self.outputs = input;
        self
    }
    /// <p>The output details in the response from the guardrail.</p>
    pub fn get_outputs(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailOutputContent>> {
        &self.outputs
    }
    /// Appends an item to `assessments`.
    ///
    /// To override the contents of this collection use [`set_assessments`](Self::set_assessments).
    ///
    /// <p>The assessment details in the response from the guardrail.</p>
    pub fn assessments(mut self, input: crate::types::GuardrailAssessment) -> Self {
        let mut v = self.assessments.unwrap_or_default();
        v.push(input);
        self.assessments = ::std::option::Option::Some(v);
        self
    }
    /// <p>The assessment details in the response from the guardrail.</p>
    pub fn set_assessments(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAssessment>>) -> Self {
        self.assessments = input;
        self
    }
    /// <p>The assessment details in the response from the guardrail.</p>
    pub fn get_assessments(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAssessment>> {
        &self.assessments
    }
    /// <p>The guardrail coverage details in the apply guardrail response.</p>
    pub fn guardrail_coverage(mut self, input: crate::types::GuardrailCoverage) -> Self {
        self.guardrail_coverage = ::std::option::Option::Some(input);
        self
    }
    /// <p>The guardrail coverage details in the apply guardrail response.</p>
    pub fn set_guardrail_coverage(mut self, input: ::std::option::Option<crate::types::GuardrailCoverage>) -> Self {
        self.guardrail_coverage = input;
        self
    }
    /// <p>The guardrail coverage details in the apply guardrail response.</p>
    pub fn get_guardrail_coverage(&self) -> &::std::option::Option<crate::types::GuardrailCoverage> {
        &self.guardrail_coverage
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`ApplyGuardrailOutput`](crate::operation::apply_guardrail::ApplyGuardrailOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`action`](crate::operation::apply_guardrail::builders::ApplyGuardrailOutputBuilder::action)
    /// - [`outputs`](crate::operation::apply_guardrail::builders::ApplyGuardrailOutputBuilder::outputs)
    /// - [`assessments`](crate::operation::apply_guardrail::builders::ApplyGuardrailOutputBuilder::assessments)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::apply_guardrail::ApplyGuardrailOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::apply_guardrail::ApplyGuardrailOutput {
            usage: self.usage,
            action: self.action.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "action",
                    "action was not specified but it is required when building ApplyGuardrailOutput",
                )
            })?,
            action_reason: self.action_reason,
            outputs: self.outputs.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "outputs",
                    "outputs was not specified but it is required when building ApplyGuardrailOutput",
                )
            })?,
            assessments: self.assessments.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "assessments",
                    "assessments was not specified but it is required when building ApplyGuardrailOutput",
                )
            })?,
            guardrail_coverage: self.guardrail_coverage,
            _request_id: self._request_id,
        })
    }
}
