# Billing

We use Stripe as our billing and payments provider. All Pro plans require payment via credit card.
For invoice-based billing, a Business plan is required. Contact [sales@zed.dev](mailto:sales@zed.dev) for more information.

## Settings {#settings}

You can access billing settings at [zed.dev/account](https://zed.dev/account).
Clicking the button under Account Settings will navigate you to Stripe’s secure portal, where you can update all billing-related settings and configuration.

## Billing Cycles {#billing-cycles}

Zed is billed on a monthly basis based on the date you initially subscribe.

We’ll also bill in-month for additional prompts used beyond your plan’s prompt limit, if usage exceeds $20 before month end.
See [usage-based pricing](./plans-and-usage.md#ubp) for more.

## Invoice History {#invoice-history}

You can access your invoice history by navigating to [zed.dev/account](https://zed.dev/account) and clicking "Manage" on your subscription.

From Stripe’s secure portal, you can download all current and historical invoices.

## Updating Billing Information {#updating-billing-info}

You can update your payment method, company name, address, and tax information through the billing portal.

Please note that changes to billing information will **only** affect future invoices — **we cannot modify historical invoices**.

## Sales Tax {#sales-tax}

Zed partners with [Sphere](https://www.getsphere.com/) to calculate indirect tax rate for invoices, based on customer location and the product being sold. Tax is listed as a separate line item on invoices, based preferentially on your billing address, followed by the card issue country known to Stripe.

If you have a VAT/GST ID, you can add it at [zed.dev/account](https://zed.dev/account) by clicking "Manage" on your subscription. Check the box that denotes you as a business.

Please note that changes to VAT/GST IDs and address will **only** affect future invoices — **we cannot modify historical invoices**.
Questions or issues can be directed to [billing-support@zed.dev](mailto:billing-support@zed.dev).
