/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene62;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;

@Deprecated
public class Lucene62SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene62SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_MULTI_VALUED_SORT = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segment, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = EndiannessReverserUtil.openChecksumInput((Directory)dir, (String)fileName, (IOContext)context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Sort indexSort;
                int format = CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)1, (byte[])segmentID, (String)"");
                Version version = Version.fromBits((int)input.readInt(), (int)input.readInt(), (int)input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, (DataInput)input);
                }
                boolean isCompoundFile = input.readByte() == 1;
                Map diagnostics = input.readMapOfStrings();
                Set files = input.readSetOfStrings();
                Map attributes = input.readMapOfStrings();
                int numSortFields = input.readVInt();
                if (numSortFields > 0) {
                    SortField[] sortFields = new SortField[numSortFields];
                    for (int i = 0; i < numSortFields; ++i) {
                        Object missingValue;
                        boolean reverse;
                        SortField.Type sortType;
                        String fieldName = input.readString();
                        int sortTypeID = input.readVInt();
                        SortedSetSelector.Type sortedSetSelector = null;
                        SortedNumericSelector.Type sortedNumericSelector = null;
                        switch (sortTypeID) {
                            case 0: {
                                sortType = SortField.Type.STRING;
                                break;
                            }
                            case 1: {
                                sortType = SortField.Type.LONG;
                                break;
                            }
                            case 2: {
                                sortType = SortField.Type.INT;
                                break;
                            }
                            case 3: {
                                sortType = SortField.Type.DOUBLE;
                                break;
                            }
                            case 4: {
                                sortType = SortField.Type.FLOAT;
                                break;
                            }
                            case 5: {
                                sortType = SortField.Type.STRING;
                                byte selector = input.readByte();
                                if (selector == 0) {
                                    sortedSetSelector = SortedSetSelector.Type.MIN;
                                    break;
                                }
                                if (selector == 1) {
                                    sortedSetSelector = SortedSetSelector.Type.MAX;
                                    break;
                                }
                                if (selector == 2) {
                                    sortedSetSelector = SortedSetSelector.Type.MIDDLE_MIN;
                                    break;
                                }
                                if (selector == 3) {
                                    sortedSetSelector = SortedSetSelector.Type.MIDDLE_MAX;
                                    break;
                                }
                                throw new CorruptIndexException("invalid index SortedSetSelector ID: " + selector, (DataInput)input);
                            }
                            case 6: {
                                byte type = input.readByte();
                                if (type == 0) {
                                    sortType = SortField.Type.LONG;
                                } else if (type == 1) {
                                    sortType = SortField.Type.INT;
                                } else if (type == 2) {
                                    sortType = SortField.Type.DOUBLE;
                                } else if (type == 3) {
                                    sortType = SortField.Type.FLOAT;
                                } else {
                                    throw new CorruptIndexException("invalid index SortedNumericSortField type ID: " + type, (DataInput)input);
                                }
                                byte numericSelector = input.readByte();
                                if (numericSelector == 0) {
                                    sortedNumericSelector = SortedNumericSelector.Type.MIN;
                                    break;
                                }
                                if (numericSelector == 1) {
                                    sortedNumericSelector = SortedNumericSelector.Type.MAX;
                                    break;
                                }
                                throw new CorruptIndexException("invalid index SortedNumericSelector ID: " + numericSelector, (DataInput)input);
                            }
                            default: {
                                throw new CorruptIndexException("invalid index sort field type ID: " + sortTypeID, (DataInput)input);
                            }
                        }
                        byte b = input.readByte();
                        if (b == 0) {
                            reverse = true;
                        } else if (b == 1) {
                            reverse = false;
                        } else {
                            throw new CorruptIndexException("invalid index sort reverse: " + b, (DataInput)input);
                        }
                        sortFields[i] = sortedSetSelector != null ? new SortedSetSortField(fieldName, reverse, sortedSetSelector) : (sortedNumericSelector != null ? new SortedNumericSortField(fieldName, sortType, reverse, sortedNumericSelector) : new SortField(fieldName, sortType, reverse));
                        b = input.readByte();
                        if (b == 0) {
                            missingValue = null;
                        } else {
                            switch (sortType) {
                                case STRING: {
                                    if (b == 1) {
                                        missingValue = SortField.STRING_LAST;
                                        break;
                                    }
                                    if (b == 2) {
                                        missingValue = SortField.STRING_FIRST;
                                        break;
                                    }
                                    throw new CorruptIndexException("invalid missing value flag: " + b, (DataInput)input);
                                }
                                case LONG: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, (DataInput)input);
                                    }
                                    missingValue = input.readLong();
                                    break;
                                }
                                case INT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, (DataInput)input);
                                    }
                                    missingValue = input.readInt();
                                    break;
                                }
                                case DOUBLE: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, (DataInput)input);
                                    }
                                    missingValue = Double.longBitsToDouble(input.readLong());
                                    break;
                                }
                                case FLOAT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, (DataInput)input);
                                    }
                                    missingValue = Float.valueOf(Float.intBitsToFloat(input.readInt()));
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("unhandled sortType=" + String.valueOf(sortType)));
                                }
                            }
                        }
                        if (missingValue == null) continue;
                        sortFields[i].setMissingValue(missingValue);
                    }
                    indexSort = new Sort(sortFields);
                } else {
                    if (numSortFields < 0) {
                        throw new CorruptIndexException("invalid index sort field count: " + numSortFields, (DataInput)input);
                    }
                    indexSort = null;
                }
                si = new SegmentInfo(dir, version, null, segment, docCount, isCompoundFile, false, null, diagnostics, segmentID, attributes, indexSort);
                si.setFiles((Collection)files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    public void write(Directory dir, SegmentInfo info, IOContext ioContext) {
        throw new UnsupportedOperationException("This format can only be used for reading");
    }
}

