/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Streams;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.NetworkMessage;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TransportStatus;

abstract class OutboundMessage
extends NetworkMessage {
    protected final Writeable message;

    OutboundMessage(ThreadContext threadContext, TransportVersion version, byte status, long requestId, Compression.Scheme compressionScheme, Writeable message) {
        super(threadContext, version, status, requestId, compressionScheme);
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BytesReference serialize(RecyclerBytesStreamOutput bytesStream) throws IOException {
        BytesReference zeroCopyBuffer;
        boolean compress;
        bytesStream.setTransportVersion(this.version);
        bytesStream.skip(TcpHeader.headerSize(this.version));
        int variableHeaderLength = -1;
        long preHeaderPosition = bytesStream.position();
        if (this.version.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
            this.writeVariableHeader(bytesStream);
            variableHeaderLength = Math.toIntExact(bytesStream.position() - preHeaderPosition);
        }
        RecyclerBytesStreamOutput stream = (compress = TransportStatus.isCompress(this.status)) ? this.wrapCompressed(bytesStream) : bytesStream;
        try {
            Writeable writeable;
            stream.setTransportVersion(this.version);
            if (variableHeaderLength == -1) {
                this.writeVariableHeader(stream);
            }
            if ((writeable = this.message) instanceof BytesTransportRequest) {
                BytesTransportRequest bRequest = (BytesTransportRequest)writeable;
                bRequest.writeThin(stream);
                zeroCopyBuffer = bRequest.bytes;
            } else if (this.message instanceof RemoteTransportException) {
                stream.writeException((RemoteTransportException)this.message);
                zeroCopyBuffer = BytesArray.EMPTY;
            } else {
                this.message.writeTo(stream);
                zeroCopyBuffer = BytesArray.EMPTY;
            }
        }
        finally {
            if (compress) {
                ((StreamOutput)stream).close();
            }
        }
        BytesReference message = bytesStream.bytes();
        BytesReference reference = zeroCopyBuffer.length() == 0 ? message : CompositeBytesReference.of(message, zeroCopyBuffer);
        bytesStream.seek(0L);
        int contentSize = reference.length() - TcpHeader.headerSize(this.version);
        TcpHeader.writeHeader(bytesStream, this.requestId, this.status, this.version, contentSize, variableHeaderLength);
        return reference;
    }

    private StreamOutput wrapCompressed(RecyclerBytesStreamOutput bytesStream) throws IOException {
        if (this.compressionScheme == Compression.Scheme.DEFLATE) {
            return new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.noCloseStream((OutputStream)bytesStream)));
        }
        if (this.compressionScheme == Compression.Scheme.LZ4) {
            return new OutputStreamStreamOutput(Compression.Scheme.lz4OutputStream(Streams.noCloseStream((OutputStream)bytesStream)));
        }
        throw new IllegalArgumentException("Invalid compression scheme: " + String.valueOf((Object)this.compressionScheme));
    }

    protected void writeVariableHeader(StreamOutput stream) throws IOException {
        this.threadContext.writeTo(stream);
    }

    static class Response
    extends OutboundMessage {
        Response(ThreadContext threadContext, Writeable message, TransportVersion version, long requestId, boolean isHandshake, Compression.Scheme compressionScheme) {
            super(threadContext, version, Response.setStatus(isHandshake, message), requestId, compressionScheme, message);
        }

        private static byte setStatus(boolean isHandshake, Writeable message) {
            byte status = 0;
            status = TransportStatus.setResponse(status);
            if (message instanceof RemoteTransportException) {
                status = TransportStatus.setError(status);
            }
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }

        public String toString() {
            return "Response{" + this.requestId + "}{" + this.isError() + "}{" + this.isCompress() + "}{" + this.isHandshake() + "}{" + String.valueOf(this.message.getClass()) + "}";
        }
    }

    static class Request
    extends OutboundMessage {
        private final String action;

        Request(ThreadContext threadContext, Writeable message, TransportVersion version, String action, long requestId, boolean isHandshake, Compression.Scheme compressionScheme) {
            super(threadContext, version, Request.setStatus(isHandshake), requestId, Request.adjustCompressionScheme(compressionScheme, message), message);
            this.action = action;
        }

        @Override
        protected void writeVariableHeader(StreamOutput stream) throws IOException {
            super.writeVariableHeader(stream);
            if (this.version.before(TransportVersions.V_8_0_0)) {
                stream.writeStringArray(Strings.EMPTY_ARRAY);
            }
            stream.writeString(this.action);
        }

        private static Compression.Scheme adjustCompressionScheme(Compression.Scheme compressionScheme, Writeable message) {
            if (message instanceof BytesTransportRequest) {
                return null;
            }
            return compressionScheme;
        }

        private static byte setStatus(boolean isHandshake) {
            byte status = 0;
            status = TransportStatus.setRequest(status);
            if (isHandshake) {
                status = TransportStatus.setHandshake(status);
            }
            return status;
        }

        public String toString() {
            return "Request{" + this.action + "}{" + this.requestId + "}{" + this.isError() + "}{" + this.isCompress() + "}{" + this.isHandshake() + "}";
        }
    }
}

