/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class StandardRetrieverBuilder
extends RetrieverBuilder
implements ToXContent {
    public static final String NAME = "standard";
    public static final NodeFeature STANDARD_RETRIEVER_SUPPORTED = new NodeFeature("standard_retriever_supported");
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SEARCH_AFTER_FIELD = new ParseField("search_after", new String[0]);
    public static final ParseField TERMINATE_AFTER_FIELD = new ParseField("terminate_after", new String[0]);
    public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    public static final ParseField COLLAPSE_FIELD = new ParseField("collapse", new String[0]);
    public static final ObjectParser<StandardRetrieverBuilder, RetrieverParserContext> PARSER = new ObjectParser("standard", StandardRetrieverBuilder::new);
    QueryBuilder queryBuilder;
    SearchAfterBuilder searchAfterBuilder;
    int terminateAfter = 0;
    List<SortBuilder<?>> sortBuilders;
    CollapseBuilder collapseBuilder;

    public static StandardRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(STANDARD_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [standard]", new Object[0]);
        }
        return (StandardRetrieverBuilder)PARSER.apply(parser, (Object)context);
    }

    public StandardRetrieverBuilder() {
    }

    public StandardRetrieverBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    private StandardRetrieverBuilder(StandardRetrieverBuilder clone) {
        this.retrieverName = clone.retrieverName;
        this.queryBuilder = clone.queryBuilder;
        this.minScore = clone.minScore;
        this.sortBuilders = clone.sortBuilders;
        this.preFilterQueryBuilders = clone.preFilterQueryBuilders;
        this.collapseBuilder = clone.collapseBuilder;
        this.searchAfterBuilder = clone.searchAfterBuilder;
        this.terminateAfter = clone.terminateAfter;
    }

    @Override
    public RetrieverBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        List<QueryBuilder> rewrittenFilters;
        boolean changed = false;
        ArrayList rewrittenSortBuilders = null;
        if (this.sortBuilders != null) {
            rewrittenSortBuilders = new ArrayList(this.sortBuilders.size());
            for (SortBuilder<?> sort : this.sortBuilders) {
                SortBuilder newSort = (SortBuilder)sort.rewrite(ctx);
                rewrittenSortBuilders.add(newSort);
                changed |= newSort != sort;
            }
        }
        changed |= (rewrittenFilters = this.rewritePreFilters(ctx)) != this.preFilterQueryBuilders;
        QueryBuilder rewrittenQuery = null;
        if (this.queryBuilder != null) {
            rewrittenQuery = this.queryBuilder.rewrite(ctx);
            changed |= rewrittenQuery != this.queryBuilder;
        }
        if (changed) {
            StandardRetrieverBuilder rewritten = new StandardRetrieverBuilder(this);
            rewritten.sortBuilders = rewrittenSortBuilders;
            rewritten.preFilterQueryBuilders = rewrittenFilters;
            rewritten.queryBuilder = rewrittenQuery;
            return rewritten;
        }
        return this;
    }

    @Override
    public QueryBuilder topDocsQuery() {
        if (this.preFilterQueryBuilders.isEmpty()) {
            QueryBuilder qb = this.queryBuilder;
            qb.queryName(this.retrieverName);
            return qb;
        }
        BoolQueryBuilder ret = (BoolQueryBuilder)new BoolQueryBuilder().filter(this.queryBuilder).queryName(this.retrieverName);
        this.preFilterQueryBuilders.stream().forEach(ret::filter);
        return ret;
    }

    @Override
    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        if (!this.preFilterQueryBuilders.isEmpty() || this.minScore != null) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (QueryBuilder preFilterQueryBuilder : this.preFilterQueryBuilders) {
                boolQueryBuilder.filter(preFilterQueryBuilder);
            }
            if (this.queryBuilder != null) {
                boolQueryBuilder.must(this.queryBuilder);
            }
            searchSourceBuilder.subSearches().add(new SubSearchSourceBuilder(boolQueryBuilder));
        } else if (this.queryBuilder != null) {
            searchSourceBuilder.subSearches().add(new SubSearchSourceBuilder(this.queryBuilder));
        }
        if (this.searchAfterBuilder != null) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + SEARCH_AFTER_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.searchAfter(this.searchAfterBuilder.getSortValues());
        }
        if (this.terminateAfter != 0) {
            if (compoundUsed) {
                throw new IllegalArgumentException("[" + TERMINATE_AFTER_FIELD.getPreferredName() + "] cannot be used in children of compound retrievers");
            }
            searchSourceBuilder.terminateAfter(this.terminateAfter);
        }
        if (this.sortBuilders != null) {
            searchSourceBuilder.sort(this.sortBuilders);
        }
        if (this.minScore != null) {
            searchSourceBuilder.minScore(this.minScore.floatValue());
        }
        if (this.collapseBuilder != null) {
            searchSourceBuilder.collapse(this.collapseBuilder);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.queryBuilder != null) {
            builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.queryBuilder);
        }
        if (this.searchAfterBuilder != null) {
            this.searchAfterBuilder.innerToXContent(builder);
        }
        if (this.terminateAfter != 0) {
            builder.field(TERMINATE_AFTER_FIELD.getPreferredName(), this.terminateAfter);
        }
        if (this.sortBuilders != null) {
            builder.field(SORT_FIELD.getPreferredName(), this.sortBuilders);
        }
        if (this.collapseBuilder != null) {
            builder.field(COLLAPSE_FIELD.getPreferredName(), (ToXContent)this.collapseBuilder);
        }
    }

    @Override
    public boolean doEquals(Object o) {
        StandardRetrieverBuilder that = (StandardRetrieverBuilder)o;
        return this.terminateAfter == that.terminateAfter && Objects.equals(this.queryBuilder, that.queryBuilder) && Objects.equals(this.searchAfterBuilder, that.searchAfterBuilder) && Objects.equals(this.sortBuilders, that.sortBuilders) && Objects.equals(this.collapseBuilder, that.collapseBuilder);
    }

    @Override
    public int doHashCode() {
        return Objects.hash(this.queryBuilder, this.searchAfterBuilder, this.terminateAfter, this.sortBuilders, this.collapseBuilder);
    }

    static {
        PARSER.declareObject((r, v) -> {
            r.queryBuilder = v;
        }, (p, c) -> {
            QueryBuilder queryBuilder = AbstractQueryBuilder.parseTopLevelQuery(p, c::trackQueryUsage);
            return queryBuilder;
        }, QUERY_FIELD);
        PARSER.declareField((r, v) -> {
            r.searchAfterBuilder = v;
        }, (p, c) -> SearchAfterBuilder.fromXContent(p), SEARCH_AFTER_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((r, v) -> {
            r.terminateAfter = v;
        }, (p, c) -> p.intValue(), TERMINATE_AFTER_FIELD, ObjectParser.ValueType.INT);
        PARSER.declareField((r, v) -> {
            r.sortBuilders = v;
        }, (p, c) -> SortBuilder.fromXContent(p), SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField((r, v) -> {
            r.collapseBuilder = v;
        }, (p, c) -> CollapseBuilder.fromXContent(p), COLLAPSE_FIELD, ObjectParser.ValueType.OBJECT);
        RetrieverBuilder.declareBaseParserFields(NAME, PARSER);
    }
}

