/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

class StoredFieldSourceProvider
implements SourceProvider {
    private final StoredFieldLoader storedFieldLoader;
    private final Map<Object, LeafStoredFieldSourceProvider> leaves = ConcurrentCollections.newConcurrentMap();

    StoredFieldSourceProvider(StoredFieldLoader storedFieldLoader) {
        this.storedFieldLoader = storedFieldLoader;
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        Object id = ctx.id();
        LeafStoredFieldSourceProvider provider = this.leaves.get(id);
        if (provider == null) {
            provider = new LeafStoredFieldSourceProvider(this.storedFieldLoader.getLoader(ctx, null));
            LeafStoredFieldSourceProvider existing = this.leaves.put(id, provider);
            assert (existing == null) : "unexpected source provider [" + String.valueOf(existing) + "]";
        }
        return provider.getSource(doc);
    }

    private static class LeafStoredFieldSourceProvider {
        final LeafStoredFieldLoader leafStoredFieldLoader;
        int doc = -1;
        Source source;

        private LeafStoredFieldSourceProvider(LeafStoredFieldLoader leafStoredFieldLoader) {
            this.leafStoredFieldLoader = leafStoredFieldLoader;
        }

        Source getSource(int doc) throws IOException {
            if (this.doc == doc) {
                return this.source;
            }
            this.doc = doc;
            this.leafStoredFieldLoader.advanceTo(doc);
            this.source = Source.fromBytes(this.leafStoredFieldLoader.source());
            return this.source;
        }
    }
}

