/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class SumAggregator
extends NumericMetricsAggregator.SingleDoubleValue {
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    SumAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.format = valuesSourceConfig.format();
        this.sums = this.bigArrays().newDoubleArray(1L, true);
        this.compensations = this.bigArrays().newDoubleArray(1L, true);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    SumAggregator.this.maybeGrow(bucket);
                    kahanSummation.reset(SumAggregator.this.sums.get(bucket), SumAggregator.this.compensations.get(bucket));
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        kahanSummation.add(values.nextValue());
                    }
                    SumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    SumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, (Object)values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    SumAggregator.this.maybeGrow(bucket);
                    kahanSummation.reset(SumAggregator.this.sums.get(bucket), SumAggregator.this.compensations.get(bucket));
                    kahanSummation.add(values.doubleValue());
                    SumAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    SumAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }

    private void maybeGrow(long bucket) {
        if (bucket >= this.sums.size()) {
            this.sums = this.bigArrays().grow(this.sums, bucket + 1L);
            this.compensations = this.bigArrays().grow(this.compensations, bucket + 1L);
        }
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new Sum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return Sum.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

