/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.xcontent.XContentBuilder;

public class SignificantLongTerms
extends InternalMappedSignificantTerms<SignificantLongTerms, Bucket> {
    public static final String NAME = "siglterms";

    public SignificantLongTerms(String name, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<Bucket> buckets) {
        super(name, requiredSize, minDocCount, metadata, format, subsetSize, supersetSize, significanceHeuristic, buckets);
    }

    public SignificantLongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public SignificantLongTerms create(List<Bucket> buckets) {
        return new SignificantLongTerms(this.name, this.requiredSize, this.minDocCount, (Map<String, Object>)this.metadata, this.format, this.subsetSize, this.supersetSize, this.significanceHeuristic, buckets);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.subsetDf, prototype.subsetSize, prototype.supersetDf, prototype.supersetSize, prototype.term, aggregations, prototype.format, prototype.score);
    }

    @Override
    protected SignificantLongTerms create(long subsetSize, long supersetSize, List<Bucket> buckets) {
        return new SignificantLongTerms(this.getName(), this.requiredSize, this.minDocCount, this.getMetadata(), this.format, subsetSize, supersetSize, this.significanceHeuristic, buckets);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    Bucket createBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(subsetDf, subsetSize, supersetDf, supersetSize, prototype.term, aggregations, this.format, prototype.score);
    }

    public static class Bucket
    extends InternalSignificantTerms.Bucket<Bucket> {
        long term;

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations, DocValueFormat format, double score) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations, format);
            this.term = term;
            this.score = score;
        }

        Bucket(StreamInput in, long subsetSize, long supersetSize, DocValueFormat format) throws IOException {
            super(in, subsetSize, supersetSize, format);
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.term = in.readLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeLong(this.term);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term));
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

