/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorScriptDocValues;
import org.elasticsearch.script.field.vectors.ByteKnnDenseVector;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;

public class ByteKnnDenseVectorDocValuesField
extends DenseVectorDocValuesField {
    protected ByteVectorValues input;
    protected byte[] vector;
    protected final int dims;

    public ByteKnnDenseVectorDocValuesField(@Nullable ByteVectorValues input, String name, int dims) {
        this(input, name, dims, DenseVectorFieldMapper.ElementType.BYTE);
    }

    protected ByteKnnDenseVectorDocValuesField(@Nullable ByteVectorValues input, String name, int dims, DenseVectorFieldMapper.ElementType elementType) {
        super(name, elementType);
        this.dims = dims;
        this.input = input;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input == null) {
            return;
        }
        int currentDoc = this.input.docID();
        this.vector = (byte[])(currentDoc == Integer.MAX_VALUE || docId < currentDoc ? null : (docId == currentDoc ? this.input.vectorValue() : (byte[])((currentDoc = this.input.advance(docId)) == docId ? this.input.vectorValue() : null)));
    }

    @Override
    public DenseVectorScriptDocValues toScriptDocValues() {
        return new DenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.vector == null;
    }

    protected DenseVector getVector() {
        return new ByteKnnDenseVector(this.vector);
    }

    @Override
    public DenseVector get() {
        if (this.isEmpty()) {
            return DenseVector.EMPTY;
        }
        return this.getVector();
    }

    @Override
    public DenseVector get(DenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.getVector();
    }

    @Override
    public DenseVector getInternal() {
        return this.get(null);
    }
}

