/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.metrics;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.IndexingStats;

public final class IndexStats
implements Writeable {
    int numIndices = 0;
    long numDocs = 0L;
    long numBytes = 0L;
    SearchStats.Stats search = new SearchStats().getTotal();
    IndexingStats.Stats indexing = new IndexingStats().getTotal();

    IndexStats() {
    }

    IndexStats(StreamInput in) throws IOException {
        this.numIndices = in.readVInt();
        this.numDocs = in.readVLong();
        this.numBytes = in.readVLong();
        this.search = SearchStats.Stats.readStats(in);
        this.indexing = new IndexingStats.Stats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numIndices);
        out.writeVLong(this.numDocs);
        out.writeVLong(this.numBytes);
        this.search.writeTo(out);
        this.indexing.writeTo(out);
    }

    void add(IndexStats other) {
        this.numIndices += other.numIndices;
        this.numDocs += other.numDocs;
        this.numBytes += other.numBytes;
        this.search.add(other.search);
        this.indexing.add(other.indexing);
    }

    public int numIndices() {
        return this.numIndices;
    }

    public long numDocs() {
        return this.numDocs;
    }

    public long numBytes() {
        return this.numBytes;
    }
}

