/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.health.Diagnosis;
import org.elasticsearch.health.HealthFeatures;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.metadata.HealthMetadata;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.indices.ShardLimitValidator;

public class ShardsCapacityHealthIndicatorService
implements HealthIndicatorService {
    static final String NAME = "shards_capacity";
    static final String DATA_NODE_NAME = "data";
    static final String FROZEN_NODE_NAME = "frozen";
    private static final String UPGRADE_BLOCKED = "The cluster has too many used shards to be able to upgrade.";
    private static final String UPGRADE_AT_RISK = "The cluster is running low on room to add new shard. Upgrading to a new version is at risk.";
    private static final String INDEX_CREATION_BLOCKED = "The cluster is running low on room to add new shards. Adding data to new indices is at risk";
    private static final String INDEX_CREATION_RISK = "The cluster is running low on room to add new shards. Adding data to new indices might soon fail.";
    private static final String HELP_GUIDE = "https://ela.st/fix-shards-capacity";
    private static final TriFunction<String, Setting<?>, String, Diagnosis> SHARD_MAX_CAPACITY_REACHED_FN = (id, setting, indexType) -> new Diagnosis(new Diagnosis.Definition(NAME, (String)id, "Elasticsearch is about to reach the maximum number of shards it can host, based on your current settings.", "Increase the value of [" + setting.getKey() + "] cluster setting or remove " + indexType + " indices to clear up resources.", HELP_GUIDE), null);
    static final List<HealthIndicatorImpact> RED_INDICATOR_IMPACTS = List.of(new HealthIndicatorImpact("shards_capacity", "upgrade_blocked", 1, "The cluster has too many used shards to be able to upgrade.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)), new HealthIndicatorImpact("shards_capacity", "creation_of_new_indices_blocked", 1, "The cluster is running low on room to add new shards. Adding data to new indices is at risk", List.of(ImpactArea.INGEST)));
    static final List<HealthIndicatorImpact> YELLOW_INDICATOR_IMPACTS = List.of(new HealthIndicatorImpact("shards_capacity", "upgrade_at_risk", 2, "The cluster is running low on room to add new shard. Upgrading to a new version is at risk.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)), new HealthIndicatorImpact("shards_capacity", "creation_of_new_indices_at_risk", 2, "The cluster is running low on room to add new shards. Adding data to new indices might soon fail.", List.of(ImpactArea.INGEST)));
    static final Diagnosis SHARDS_MAX_CAPACITY_REACHED_DATA_NODES = SHARD_MAX_CAPACITY_REACHED_FN.apply("increase_max_shards_per_node", ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE, "data");
    static final Diagnosis SHARDS_MAX_CAPACITY_REACHED_FROZEN_NODES = SHARD_MAX_CAPACITY_REACHED_FN.apply("increase_max_shards_per_node_frozen", ShardLimitValidator.SETTING_CLUSTER_MAX_SHARDS_PER_NODE_FROZEN, "frozen");
    private final ClusterService clusterService;
    private final FeatureService featureService;

    public ShardsCapacityHealthIndicatorService(ClusterService clusterService, FeatureService featureService) {
        this.clusterService = clusterService;
        this.featureService = featureService;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
        ClusterState state = this.clusterService.state();
        HealthMetadata healthMetadata = HealthMetadata.getFromClusterState(state);
        if (healthMetadata == null || healthMetadata.getShardLimitsMetadata() == null) {
            if (!this.featureService.clusterHasFeature(state, HealthFeatures.SUPPORTS_SHARDS_CAPACITY_INDICATOR)) {
                return this.createIndicator(HealthStatus.GREEN, "No shard limits configured yet. The cluster currently has mixed versions (an upgrade may be in progress).", HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            return this.unknownIndicator();
        }
        HealthMetadata.ShardLimits shardLimitsMetadata = healthMetadata.getShardLimitsMetadata();
        return this.mergeIndicators(verbose, ShardsCapacityHealthIndicatorService.calculateFrom(shardLimitsMetadata.maxShardsPerNode(), state.nodes(), state.metadata(), ShardLimitValidator::checkShardLimitForNormalNodes), ShardsCapacityHealthIndicatorService.calculateFrom(shardLimitsMetadata.maxShardsPerNodeFrozen(), state.nodes(), state.metadata(), ShardLimitValidator::checkShardLimitForFrozenNodes));
    }

    private HealthIndicatorResult mergeIndicators(boolean verbose, StatusResult dataNodes, StatusResult frozenNodes) {
        HealthStatus finalStatus = HealthStatus.merge(Stream.of(dataNodes.status, frozenNodes.status));
        List<Diagnosis> diagnoses = List.of();
        StringBuilder symptomBuilder = new StringBuilder();
        if (finalStatus == HealthStatus.GREEN) {
            symptomBuilder.append("The cluster has enough room to add new shards.");
        }
        if (finalStatus.indicatesHealthProblem()) {
            symptomBuilder.append("Cluster is close to reaching the configured maximum number of shards for ");
            if (dataNodes.status == frozenNodes.status) {
                symptomBuilder.append(DATA_NODE_NAME).append(" and ").append(FROZEN_NODE_NAME);
                diagnoses = List.of(SHARDS_MAX_CAPACITY_REACHED_DATA_NODES, SHARDS_MAX_CAPACITY_REACHED_FROZEN_NODES);
            } else if (dataNodes.status.indicatesHealthProblem()) {
                symptomBuilder.append(DATA_NODE_NAME);
                diagnoses = List.of(SHARDS_MAX_CAPACITY_REACHED_DATA_NODES);
            } else if (frozenNodes.status.indicatesHealthProblem()) {
                symptomBuilder.append(FROZEN_NODE_NAME);
                diagnoses = List.of(SHARDS_MAX_CAPACITY_REACHED_FROZEN_NODES);
            }
            symptomBuilder.append(" nodes.");
        }
        List<HealthIndicatorImpact> indicatorImpacts = switch (finalStatus) {
            case HealthStatus.RED -> RED_INDICATOR_IMPACTS;
            case HealthStatus.YELLOW -> YELLOW_INDICATOR_IMPACTS;
            default -> List.of();
        };
        return this.createIndicator(finalStatus, symptomBuilder.toString(), verbose ? ShardsCapacityHealthIndicatorService.buildDetails(dataNodes.result, frozenNodes.result) : HealthIndicatorDetails.EMPTY, indicatorImpacts, verbose ? diagnoses : List.of());
    }

    static StatusResult calculateFrom(int maxShardsPerNodeSetting, DiscoveryNodes discoveryNodes, Metadata metadata, ShardsCapacityChecker checker) {
        ShardLimitValidator.Result result = checker.check(maxShardsPerNodeSetting, 5, 1, discoveryNodes, metadata);
        if (!result.canAddShards()) {
            return new StatusResult(HealthStatus.RED, result);
        }
        result = checker.check(maxShardsPerNodeSetting, 10, 1, discoveryNodes, metadata);
        if (!result.canAddShards()) {
            return new StatusResult(HealthStatus.YELLOW, result);
        }
        return new StatusResult(HealthStatus.GREEN, result);
    }

    static HealthIndicatorDetails buildDetails(ShardLimitValidator.Result dataNodes, ShardLimitValidator.Result frozenNodes) {
        return (builder, params) -> {
            builder.startObject();
            builder.startObject(DATA_NODE_NAME);
            builder.field("max_shards_in_cluster", dataNodes.maxShardsInCluster());
            if (dataNodes.currentUsedShards().isPresent()) {
                builder.field("current_used_shards", dataNodes.currentUsedShards().get());
            }
            builder.endObject();
            builder.startObject(FROZEN_NODE_NAME);
            builder.field("max_shards_in_cluster", frozenNodes.maxShardsInCluster());
            if (frozenNodes.currentUsedShards().isPresent()) {
                builder.field("current_used_shards", frozenNodes.currentUsedShards().get());
            }
            builder.endObject();
            builder.endObject();
            return builder;
        };
    }

    private HealthIndicatorResult unknownIndicator() {
        return this.createIndicator(HealthStatus.UNKNOWN, "Unable to determine shard capacity status.", HealthIndicatorDetails.EMPTY, List.of(), List.of());
    }

    @FunctionalInterface
    static interface ShardsCapacityChecker {
        public ShardLimitValidator.Result check(int var1, int var2, int var3, DiscoveryNodes var4, Metadata var5);
    }

    record StatusResult(HealthStatus status, ShardLimitValidator.Result result) {
    }
}

