/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.indices.close.CloseIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.readonly.TransportVerifyShardIndexBlockAction;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataVerifier;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataIndexStateService {
    private static final Logger logger = LogManager.getLogger(MetadataIndexStateService.class);
    public static final int INDEX_CLOSED_BLOCK_ID = 4;
    public static final ClusterBlock INDEX_CLOSED_BLOCK = new ClusterBlock(4, "index closed", false, false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.READ_WRITE);
    public static final Setting<Boolean> VERIFIED_BEFORE_CLOSE_SETTING = Setting.boolSetting("index.verified_before_close", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexMetadataVerifier indexMetadataVerifier;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final NodeClient client;
    private final ThreadPool threadPool;
    private final MasterServiceTaskQueue<OpenIndicesTask> opensQueue;
    private final MasterServiceTaskQueue<AddBlocksToCloseTask> addBlocksToCloseQueue;
    private final MasterServiceTaskQueue<CloseIndicesTask> closesQueue;
    private final MasterServiceTaskQueue<AddBlocksTask> addBlocksQueue;
    private final MasterServiceTaskQueue<FinalizeBlocksTask> finalizeBlocksQueue;

    @Inject
    public MetadataIndexStateService(ClusterService clusterService, AllocationService allocationService, IndexMetadataVerifier indexMetadataVerifier, IndicesService indicesService, ShardLimitValidator shardLimitValidator, NodeClient client, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.indexMetadataVerifier = indexMetadataVerifier;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
        this.client = client;
        this.threadPool = threadPool;
        this.opensQueue = clusterService.createTaskQueue("open-index", Priority.URGENT, new OpenIndicesExecutor());
        this.addBlocksToCloseQueue = clusterService.createTaskQueue("add-blocks-to-close", Priority.URGENT, new AddBlocksToCloseExecutor());
        this.closesQueue = clusterService.createTaskQueue("close-index", Priority.URGENT, new CloseIndicesExecutor());
        this.addBlocksQueue = clusterService.createTaskQueue("add-blocks", Priority.URGENT, new AddBlocksExecutor());
        this.finalizeBlocksQueue = clusterService.createTaskQueue("finalize-blocks", Priority.URGENT, new FinalizeBlocksExecutor());
    }

    public void closeIndices(CloseIndexClusterStateUpdateRequest request, ActionListener<CloseIndexResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.addBlocksToCloseQueue.submitTask("add-block-index-to-close " + Arrays.toString(request.indices()), new AddBlocksToCloseTask(request, listener), request.masterNodeTimeout());
    }

    static ClusterState addIndexClosedBlocks(Index[] indices, Map<Index, ClusterBlock> blockedIndices, ClusterState currentState) {
        HashSet<Index> indicesToClose = new HashSet<Index>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.CLOSE) {
                indicesToClose.add(index);
                continue;
            }
            logger.debug("index {} is already closed, ignoring", (Object)index);
            assert (currentState.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
        }
        if (indicesToClose.isEmpty()) {
            return currentState;
        }
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, indicesToClose);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + String.valueOf(restoringIndices));
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToClose);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder(currentState.blocks());
        for (Index index : indicesToClose) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != 4) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createIndexClosingBlock();
            }
            assert (org.elasticsearch.common.Strings.hasLength(indexBlock.uuid())) : "Closing block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
        }
        logger.info(() -> Strings.format((String)"closing indices %s", (Object[])new Object[]{blockedIndices.keySet().stream().map(Object::toString).collect(Collectors.joining(","))}));
        return ClusterState.builder(currentState).blocks(blocks).build();
    }

    private static Tuple<ClusterState, Map<Index, ClusterBlock>> addIndexBlock(Index[] indices, ClusterState currentState, IndexMetadata.APIBlock block) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        HashSet<Index> indicesToAddBlock = new HashSet<Index>();
        for (Index index : indices) {
            metadata.getSafe(index);
            if (currentState.blocks().hasIndexBlock(index.getName(), block.block)) {
                logger.debug("index {} already has block {}, ignoring", (Object)index, (Object)block.block);
                continue;
            }
            indicesToAddBlock.add(index);
        }
        if (indicesToAddBlock.isEmpty()) {
            return Tuple.tuple((Object)currentState, Map.of());
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder(currentState.blocks());
        HashMap<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();
        for (Index index : indicesToAddBlock) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != block.block.id()) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = MetadataIndexStateService.createUUIDBasedBlock(block.block);
            }
            assert (org.elasticsearch.common.Strings.hasLength(indexBlock.uuid())) : "Block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (block.setting().get(indexMetadata.getSettings()).booleanValue()) continue;
            Settings updatedSettings = Settings.builder().put(indexMetadata.getSettings()).put(block.settingName(), true).build();
            metadata.put(IndexMetadata.builder(indexMetadata).settings(updatedSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
        logger.info("adding [index.blocks.{}] block to indices {}", (Object)block.name, blockedIndices.keySet().stream().map(Object::toString).toList());
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).metadata(metadata).build(), blockedIndices);
    }

    public void addIndexBlock(AddIndexBlockClusterStateUpdateRequest request, ActionListener<AddIndexBlockResponse> listener) {
        Object[] concreteIndices = request.indices();
        if (concreteIndices == null || concreteIndices.length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        Metadata metadata = this.clusterService.state().metadata();
        ArrayList<String> writeIndices = new ArrayList<String>();
        SortedMap<String, IndexAbstraction> lookup = metadata.getIndicesLookup();
        for (Index index : concreteIndices) {
            Index writeIndex;
            IndexAbstraction ia = (IndexAbstraction)lookup.get(index.getName());
            if (ia == null || ia.getParentDataStream() == null || !(writeIndex = metadata.index(ia.getParentDataStream().getWriteIndex()).getIndex()).equals(index)) continue;
            writeIndices.add(index.getName());
        }
        if (writeIndices.size() > 0) {
            throw new IllegalArgumentException("cannot add a block to the following data stream write indices [" + org.elasticsearch.common.Strings.collectionToCommaDelimitedString(writeIndices) + "]");
        }
        this.addBlocksQueue.submitTask("add-index-block-[" + request.block().name + "]-" + Arrays.toString(concreteIndices), new AddBlocksTask(request, listener), request.masterNodeTimeout());
    }

    static Tuple<ClusterState, List<CloseIndexResponse.IndexResult>> closeRoutingTable(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, CloseIndexResponse.IndexResult> verifyResult, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder(currentState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(shardRoutingRoleStrategy, currentState.routingTable());
        HashSet<String> closedIndices = new HashSet<String>();
        HashMap<Index, CloseIndexResponse.IndexResult> closingResults = new HashMap<Index, CloseIndexResponse.IndexResult>(verifyResult);
        for (Map.Entry<Index, CloseIndexResponse.IndexResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before closing {} failed [{}]", (Object)index, result);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    logger.debug("verification of shards before closing {} succeeded but index is already closed", (Object)index);
                    assert (currentState.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
                    continue;
                }
                ClusterBlock closingBlock = blockedIndices.get(index);
                assert (closingBlock != null);
                if (!currentState.blocks().hasIndexBlock(index.getName(), closingBlock)) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, Set.of(index));
                if (!restoringIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but index is being restored in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being restored in the meantime", (Object)index);
                    continue;
                }
                Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, Set.of(index));
                if (!snapshottingIndices.isEmpty()) {
                    closingResults.put(result.getKey(), new CloseIndexResponse.IndexResult(result.getKey(), new IllegalStateException("verification of shards before closing " + String.valueOf(index) + " succeeded but index is being snapshot in the meantime")));
                    logger.debug("verification of shards before closing {} succeeded but index is being snapshot in the meantime", (Object)index);
                    continue;
                }
                blocks.removeIndexBlockWithId(index.getName(), 4);
                blocks.addIndexBlock(index.getName(), INDEX_CLOSED_BLOCK);
                IndexMetadata.Builder updatedMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE);
                metadata.put(updatedMetadata.timestampRange(IndexLongFieldRange.NO_SHARDS).eventIngestedRange(IndexLongFieldRange.NO_SHARDS, currentState.getMinTransportVersion()).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put(VERIFIED_BEFORE_CLOSE_SETTING.getKey(), true)));
                routingTable.addAsFromOpenToClose(metadata.getSafe(index));
                logger.debug("closing index {} succeeded", (Object)index);
                closedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since it was blocked before closing, ignoring", (Object)index);
            }
        }
        logger.info("completed closing of indices {}", closedIndices);
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable).build(), List.copyOf(closingResults.values()));
    }

    public void openIndices(OpenIndexClusterStateUpdateRequest request, ActionListener<ShardsAcknowledgedResponse> listener) {
        this.onlyOpenIndices(request, listener.delegateFailure((delegate, response) -> {
            if (response.isAcknowledged()) {
                String[] indexNames = (String[])Arrays.stream(request.indices()).map(Index::getName).toArray(String[]::new);
                ActiveShardsObserver.waitForActiveShards(this.clusterService, indexNames, request.waitForActiveShards(), request.ackTimeout(), delegate.map(shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug(() -> Strings.format((String)"[%s] indices opened, but the operation timed out while waiting for enough shards to be started.", (Object[])new Object[]{Arrays.toString(indexNames)}));
                    }
                    return ShardsAcknowledgedResponse.of(true, shardsAcknowledged);
                }));
            } else {
                delegate.onResponse(ShardsAcknowledgedResponse.NOT_ACKNOWLEDGED);
            }
        }));
    }

    private void onlyOpenIndices(OpenIndexClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.indices() == null || request.indices().length == 0) {
            throw new IllegalArgumentException("Index name is required");
        }
        this.opensQueue.submitTask("open-indices " + Arrays.toString(request.indices()), new OpenIndicesTask(request, listener), request.masterNodeTimeout());
    }

    private static Tuple<ClusterState, List<AddIndexBlockResponse.AddBlockResult>> finalizeBlock(ClusterState currentState, Map<Index, ClusterBlock> blockedIndices, Map<Index, AddIndexBlockResponse.AddBlockResult> verifyResult, IndexMetadata.APIBlock block) {
        ClusterBlocks.Builder blocks = ClusterBlocks.builder(currentState.blocks());
        HashSet<String> effectivelyBlockedIndices = new HashSet<String>();
        HashMap<Index, AddIndexBlockResponse.AddBlockResult> blockingResults = new HashMap<Index, AddIndexBlockResponse.AddBlockResult>(verifyResult);
        for (Map.Entry<Index, AddIndexBlockResponse.AddBlockResult> result : verifyResult.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = !result.getValue().hasFailures();
            try {
                if (!acknowledged) {
                    logger.debug("verification of shards before blocking {} failed [{}]", (Object)index, result);
                    continue;
                }
                ClusterBlock tempBlock = blockedIndices.get(index);
                assert (tempBlock != null);
                assert (tempBlock.uuid() != null);
                ClusterBlock currentBlock = currentState.blocks().getIndexBlockWithId(index.getName(), tempBlock.id());
                if (currentBlock != null && currentBlock.equals(block.block)) {
                    logger.debug("verification of shards for {} succeeded, but block finalization already occurred (possibly for another block) [{}]", (Object)index, result);
                    continue;
                }
                if (currentBlock == null || !currentBlock.equals(tempBlock)) {
                    blockingResults.put(result.getKey(), new AddIndexBlockResponse.AddBlockResult(result.getKey(), new IllegalStateException("verification of shards before blocking " + String.valueOf(index) + " succeeded but block has been removed in the meantime")));
                    logger.debug("verification of shards before blocking {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                assert (currentBlock != null && currentBlock.equals(tempBlock) && currentBlock.id() == block.block.id());
                blocks.removeIndexBlockWithId(index.getName(), tempBlock.id());
                blocks.addIndexBlock(index.getName(), block.block);
                logger.debug("add block {} to index {} succeeded", (Object)block.block, (Object)index);
                effectivelyBlockedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                logger.debug("index {} has been deleted since blocking it started, ignoring", (Object)index);
            }
        }
        logger.info("completed adding [index.blocks.{}] block to indices {}", (Object)block.name, effectivelyBlockedIndices);
        return Tuple.tuple((Object)ClusterState.builder(currentState).blocks(blocks).build(), List.copyOf(blockingResults.values()));
    }

    public static ClusterBlock createIndexClosingBlock() {
        return new ClusterBlock(4, UUIDs.randomBase64UUID(), "index preparing to close. Reopen the index to allow writes again or retry closing the index to fully close the index.", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    }

    public static boolean isIndexVerifiedBeforeClosed(IndexMetadata indexMetadata) {
        return indexMetadata.getState() == IndexMetadata.State.CLOSE && VERIFIED_BEFORE_CLOSE_SETTING.exists(indexMetadata.getSettings()) && VERIFIED_BEFORE_CLOSE_SETTING.get(indexMetadata.getSettings()) != false;
    }

    public static ClusterBlock createUUIDBasedBlock(ClusterBlock clusterBlock) {
        assert (clusterBlock.uuid() == null) : "no UUID expected on source block";
        return new ClusterBlock(clusterBlock.id(), UUIDs.randomBase64UUID(), "moving to block " + clusterBlock.description(), clusterBlock.retryable(), clusterBlock.disableStatePersistence(), clusterBlock.isAllowReleaseResources(), clusterBlock.status(), clusterBlock.levels());
    }

    private class OpenIndicesExecutor
    implements ClusterStateTaskExecutor<OpenIndicesTask> {
        private OpenIndicesExecutor() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<OpenIndicesTask> batchExecutionContext) {
            AllocationActionMultiListener<AcknowledgedResponse> listener = new AllocationActionMultiListener<AcknowledgedResponse>(MetadataIndexStateService.this.threadPool.getThreadContext());
            ClusterState state = batchExecutionContext.initialState();
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                LinkedHashSet indicesToOpen = Sets.newLinkedHashSetWithExpectedSize(batchExecutionContext.taskContexts().size());
                for (ClusterStateTaskExecutor.TaskContext<OpenIndicesTask> taskContext : batchExecutionContext.taskContexts()) {
                    Collections.addAll(indicesToOpen, taskContext.getTask().request.indices());
                }
                Index[] indices = indicesToOpen.toArray(Index.EMPTY_ARRAY);
                state = this.openIndices(indices, state);
                state = MetadataIndexStateService.this.allocationService.reroute(state, "indices opened", listener.reroute());
                for (ClusterStateTaskExecutor.TaskContext<OpenIndicesTask> taskContext : batchExecutionContext.taskContexts()) {
                    OpenIndicesTask task = taskContext.getTask();
                    taskContext.success(task.getAckListener(listener));
                }
            }
            catch (Exception e) {
                for (ClusterStateTaskExecutor.TaskContext<OpenIndicesTask> taskContext : batchExecutionContext.taskContexts()) {
                    taskContext.onFailure(e);
                }
            }
            return state;
        }

        private ClusterState openIndices(Index[] indices, ClusterState currentState) {
            ArrayList<IndexMetadata> indicesToOpen = new ArrayList<IndexMetadata>(indices.length);
            for (Index index : indices) {
                IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                    indicesToOpen.add(indexMetadata);
                    continue;
                }
                if (!currentState.blocks().hasIndexBlockWithId(index.getName(), 4)) continue;
                indicesToOpen.add(indexMetadata);
            }
            MetadataIndexStateService.this.shardLimitValidator.validateShardLimit(currentState.nodes(), currentState.metadata(), indices);
            if (indicesToOpen.isEmpty()) {
                return currentState;
            }
            logger.info(() -> {
                StringBuilder indexNames = new StringBuilder();
                org.elasticsearch.common.Strings.collectionToDelimitedStringWithLimit(indicesToOpen.stream().map(i -> i.getIndex().toString()).toList(), ",", "", "", 512, indexNames);
                return "opening indices [" + String.valueOf(indexNames) + "]";
            });
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder(currentState.blocks());
            IndexVersion minIndexCompatibilityVersion = currentState.getNodes().getMinSupportedIndexVersion();
            for (IndexMetadata indexMetadata : indicesToOpen) {
                Index index = indexMetadata.getIndex();
                if (indexMetadata.getState() != IndexMetadata.State.OPEN) {
                    Settings.Builder updatedSettings = Settings.builder().put(indexMetadata.getSettings());
                    updatedSettings.remove(VERIFIED_BEFORE_CLOSE_SETTING.getKey());
                    IndexMetadata newIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.OPEN).settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(updatedSettings).timestampRange(IndexLongFieldRange.NO_SHARDS).eventIngestedRange(IndexLongFieldRange.NO_SHARDS, currentState.getMinTransportVersion()).build();
                    newIndexMetadata = MetadataIndexStateService.this.indexMetadataVerifier.verifyIndexMetadata(newIndexMetadata, minIndexCompatibilityVersion);
                    try {
                        MetadataIndexStateService.this.indicesService.verifyIndexMetadata(newIndexMetadata, newIndexMetadata);
                    }
                    catch (Exception e) {
                        throw new ElasticsearchException("Failed to verify index " + String.valueOf(index), (Throwable)e, new Object[0]);
                    }
                    metadata.put(newIndexMetadata, true);
                }
                blocks.removeIndexBlockWithId(index.getName(), 4);
            }
            ClusterState updatedState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).build();
            RoutingTable.Builder routingTable = RoutingTable.builder(MetadataIndexStateService.this.allocationService.getShardRoutingRoleStrategy(), updatedState.routingTable());
            for (IndexMetadata previousIndexMetadata : indicesToOpen) {
                if (previousIndexMetadata.getState() == IndexMetadata.State.OPEN) continue;
                routingTable.addAsFromCloseToOpen(updatedState.metadata().getIndexSafe(previousIndexMetadata.getIndex()));
            }
            return ClusterState.builder(updatedState).routingTable(routingTable).build();
        }
    }

    private class AddBlocksToCloseExecutor
    extends SimpleBatchedExecutor<AddBlocksToCloseTask, Map<Index, ClusterBlock>> {
        private AddBlocksToCloseExecutor() {
        }

        @Override
        public Tuple<ClusterState, Map<Index, ClusterBlock>> executeTask(AddBlocksToCloseTask task, ClusterState clusterState) throws Exception {
            HashMap<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>(task.request.indices().length);
            ClusterState updatedClusterState = MetadataIndexStateService.addIndexClosedBlocks(task.request.indices(), blockedIndices, clusterState);
            return Tuple.tuple((Object)updatedClusterState, blockedIndices);
        }

        @Override
        public void taskSucceeded(AddBlocksToCloseTask task, Map<Index, ClusterBlock> blockedIndices) {
            if (blockedIndices.isEmpty()) {
                task.listener().onResponse(CloseIndexResponse.EMPTY);
            } else {
                MetadataIndexStateService.this.threadPool.executor("management").execute(new WaitForClosedBlocksApplied(blockedIndices, task.request, task.listener().delegateFailure((delegate2, verifyResults) -> MetadataIndexStateService.this.closesQueue.submitTask("close-indices", new CloseIndicesTask(task.request, blockedIndices, (Map<Index, CloseIndexResponse.IndexResult>)verifyResults, (ActionListener<CloseIndexResponse>)delegate2), null))));
            }
        }
    }

    private class CloseIndicesExecutor
    implements ClusterStateTaskExecutor<CloseIndicesTask> {
        private CloseIndicesExecutor() {
        }

        @Override
        @SuppressForbidden(reason="consuming published cluster state for legacy reasons")
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<CloseIndicesTask> batchExecutionContext) {
            AllocationActionMultiListener listener = new AllocationActionMultiListener(MetadataIndexStateService.this.threadPool.getThreadContext());
            ClusterState state = batchExecutionContext.initialState();
            for (ClusterStateTaskExecutor.TaskContext<CloseIndicesTask> taskContext : batchExecutionContext.taskContexts()) {
                CloseIndicesTask task = taskContext.getTask();
                try {
                    Tuple<ClusterState, List<CloseIndexResponse.IndexResult>> closingResult = MetadataIndexStateService.closeRoutingTable(state, task.blockedIndices, task.verifyResults, MetadataIndexStateService.this.allocationService.getShardRoutingRoleStrategy());
                    state = (ClusterState)closingResult.v1();
                    List indices = (List)closingResult.v2();
                    assert (indices.size() == task.verifyResults.size());
                    taskContext.success(clusterState -> {
                        boolean acknowledged = indices.stream().noneMatch(CloseIndexResponse.IndexResult::hasFailures);
                        String[] waitForIndices = (String[])indices.stream().filter(result -> !result.hasFailures()).filter(result -> clusterState.routingTable().hasIndex(result.getIndex())).map(result -> result.getIndex().getName()).toArray(String[]::new);
                        if (waitForIndices.length > 0) {
                            ActiveShardsObserver.waitForActiveShards(MetadataIndexStateService.this.clusterService, waitForIndices, task.request.waitForActiveShards(), task.request.ackTimeout(), listener.delay(task.listener()).map(shardsAcknowledged -> {
                                if (!shardsAcknowledged.booleanValue()) {
                                    logger.debug(() -> Strings.format((String)"[%s] indices closed, but the operation timed out while waiting for enough shards to be started.", (Object[])new Object[]{Arrays.toString(waitForIndices)}));
                                }
                                boolean shardsAcked = acknowledged ? shardsAcknowledged : false;
                                return new CloseIndexResponse(acknowledged, shardsAcked, indices);
                            }));
                        } else {
                            listener.delay(task.listener()).onResponse(new CloseIndexResponse(acknowledged, false, indices));
                        }
                    });
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                ClusterState clusterState2 = MetadataIndexStateService.this.allocationService.reroute(state, "indices closed", listener.reroute());
                return clusterState2;
            }
        }
    }

    private class AddBlocksExecutor
    extends SimpleBatchedExecutor<AddBlocksTask, Map<Index, ClusterBlock>> {
        private AddBlocksExecutor() {
        }

        @Override
        public Tuple<ClusterState, Map<Index, ClusterBlock>> executeTask(AddBlocksTask task, ClusterState clusterState) {
            return MetadataIndexStateService.addIndexBlock(task.request.indices(), clusterState, task.request.block());
        }

        @Override
        public void taskSucceeded(AddBlocksTask task, Map<Index, ClusterBlock> blockedIndices) {
            if (blockedIndices.isEmpty()) {
                task.listener().onResponse(AddIndexBlockResponse.EMPTY);
            } else {
                MetadataIndexStateService.this.threadPool.executor("management").execute(new WaitForBlocksApplied(blockedIndices, task.request, task.listener().delegateFailure((delegate2, verifyResults) -> MetadataIndexStateService.this.finalizeBlocksQueue.submitTask("finalize-index-block-[" + task.request.block().name + "]-[" + blockedIndices.keySet().stream().map(Index::getName).collect(Collectors.joining(", ")) + "]", new FinalizeBlocksTask(task.request, blockedIndices, (Map<Index, AddIndexBlockResponse.AddBlockResult>)verifyResults, (ActionListener<AddIndexBlockResponse>)delegate2), null))));
            }
        }
    }

    private static class FinalizeBlocksExecutor
    extends SimpleBatchedExecutor<FinalizeBlocksTask, List<AddIndexBlockResponse.AddBlockResult>> {
        private FinalizeBlocksExecutor() {
        }

        @Override
        public Tuple<ClusterState, List<AddIndexBlockResponse.AddBlockResult>> executeTask(FinalizeBlocksTask task, ClusterState clusterState) throws Exception {
            Tuple<ClusterState, List<AddIndexBlockResponse.AddBlockResult>> finalizeResult = MetadataIndexStateService.finalizeBlock(clusterState, task.blockedIndices, task.verifyResults, task.request.block());
            assert (((List)finalizeResult.v2()).size() == task.verifyResults.size());
            return finalizeResult;
        }

        @Override
        public void taskSucceeded(FinalizeBlocksTask task, List<AddIndexBlockResponse.AddBlockResult> indices) {
            boolean acknowledged = indices.stream().noneMatch(AddIndexBlockResponse.AddBlockResult::hasFailures);
            task.listener().onResponse(new AddIndexBlockResponse(acknowledged, acknowledged, indices));
        }
    }

    private record AddBlocksToCloseTask(CloseIndexClusterStateUpdateRequest request, ActionListener<CloseIndexResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    private record AddBlocksTask(AddIndexBlockClusterStateUpdateRequest request, ActionListener<AddIndexBlockResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    private record OpenIndicesTask(OpenIndexClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        public ClusterStateAckListener getAckListener(final AllocationActionMultiListener<AcknowledgedResponse> multiListener) {
            return new ClusterStateAckListener(){

                @Override
                public boolean mustAck(DiscoveryNode discoveryNode) {
                    return true;
                }

                @Override
                public void onAllNodesAcked() {
                    multiListener.delay(listener).onResponse(AcknowledgedResponse.of(true));
                }

                @Override
                public void onAckFailure(Exception e) {
                    multiListener.delay(listener).onResponse(AcknowledgedResponse.of(false));
                }

                @Override
                public void onAckTimeout() {
                    multiListener.delay(listener).onResponse(AcknowledgedResponse.FALSE);
                }

                @Override
                public TimeValue ackTimeout() {
                    return request.ackTimeout();
                }
            };
        }
    }

    private class WaitForBlocksApplied
    extends ActionRunnable<Map<Index, AddIndexBlockResponse.AddBlockResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final AddIndexBlockClusterStateUpdateRequest request;

        private WaitForBlocksApplied(Map<Index, ClusterBlock> blockedIndices, AddIndexBlockClusterStateUpdateRequest request, ActionListener<Map<Index, AddIndexBlockResponse.AddBlockResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        @Override
        protected void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReady((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Map.copyOf(results));
                }
            }));
        }

        private void waitForShardsReady(final Index index, ClusterBlock clusterBlock, ClusterState state, final Consumer<AddIndexBlockResponse.AddBlockResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has since been deleted, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                logger.debug("index {} is closed, no need to wait for shards, ignoring", (Object)index);
                onResponse.accept(new AddIndexBlockResponse.AddBlockResult(index));
                return;
            }
            final AtomicArray results = new AtomicArray(indexRoutingTable.size());
            final CountDown countDown = new CountDown(indexRoutingTable.size());
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBlockRequest(shardRoutingTable, clusterBlock, ActionListener.notifyOnce(new ActionListener<ReplicationResponse>(){

                    @Override
                    public void onResponse(ReplicationResponse replicationResponse) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure[] failures = (AddIndexBlockResponse.AddBlockShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map((? super T f) -> new AddIndexBlockResponse.AddBlockShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(AddIndexBlockResponse.AddBlockShardResult.Failure[]::new);
                        results.setOnce(shardId, new AddIndexBlockResponse.AddBlockShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        AddIndexBlockResponse.AddBlockShardResult.Failure failure = new AddIndexBlockResponse.AddBlockShardResult.Failure(index.getName(), shardId, e);
                        results.setOnce(shardId, new AddIndexBlockResponse.AddBlockShardResult(shardId, new AddIndexBlockResponse.AddBlockShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            AddIndexBlockResponse.AddBlockResult result = new AddIndexBlockResponse.AddBlockResult(index, results.toArray(new AddIndexBlockResponse.AddBlockShardResult[results.length()]));
                            logger.debug("result of applying block to index {}: {}", (Object)index, (Object)result);
                            onResponse.accept(result);
                        }
                    }
                }));
            }
        }

        private void sendVerifyShardBlockRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock block, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(ReplicationResponse.ShardInfo.allSuccessful(shardRoutingTable.size()));
                listener.onResponse(response);
                return;
            }
            TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardIndexBlockAction.ShardRequest shardRequest = new TransportVerifyShardIndexBlockAction.ShardRequest(shardId, block, parentTaskId);
            shardRequest.timeout(this.request.ackTimeout());
            MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardIndexBlockAction.TYPE, shardRequest, listener);
        }
    }

    private class WaitForClosedBlocksApplied
    extends ActionRunnable<Map<Index, CloseIndexResponse.IndexResult>> {
        private final Map<Index, ClusterBlock> blockedIndices;
        private final CloseIndexClusterStateUpdateRequest request;

        private WaitForClosedBlocksApplied(Map<Index, ClusterBlock> blockedIndices, CloseIndexClusterStateUpdateRequest request, ActionListener<Map<Index, CloseIndexResponse.IndexResult>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for closed blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
            this.request = request;
        }

        @Override
        protected void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = MetadataIndexStateService.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReadyForClosing((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Map.copyOf(results));
                }
            }));
        }

        private void waitForShardsReadyForClosing(final Index index, ClusterBlock closingBlock, ClusterState state, final Consumer<CloseIndexResponse.IndexResult> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                logger.debug("index {} has been blocked before closing and is now deleted, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                assert (state.blocks().hasIndexBlock(index.getName(), INDEX_CLOSED_BLOCK));
                logger.debug("index {} has been blocked before closing and is already closed, ignoring", (Object)index);
                onResponse.accept(new CloseIndexResponse.IndexResult(index));
                return;
            }
            final AtomicArray results = new AtomicArray(indexRoutingTable.size());
            final CountDown countDown = new CountDown(indexRoutingTable.size());
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(i);
                final int shardId = shardRoutingTable.shardId().id();
                this.sendVerifyShardBeforeCloseRequest(shardRoutingTable, closingBlock, ActionListener.notifyOnce(new ActionListener<ReplicationResponse>(){

                    @Override
                    public void onResponse(ReplicationResponse replicationResponse) {
                        CloseIndexResponse.ShardResult.Failure[] failures = (CloseIndexResponse.ShardResult.Failure[])Arrays.stream(replicationResponse.getShardInfo().getFailures()).map((? super T f) -> new CloseIndexResponse.ShardResult.Failure(f.index(), f.shardId(), f.getCause(), f.nodeId())).toArray(CloseIndexResponse.ShardResult.Failure[]::new);
                        results.setOnce(shardId, new CloseIndexResponse.ShardResult(shardId, failures));
                        this.processIfFinished();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        CloseIndexResponse.ShardResult.Failure failure = new CloseIndexResponse.ShardResult.Failure(index.getName(), shardId, e);
                        results.setOnce(shardId, new CloseIndexResponse.ShardResult(shardId, new CloseIndexResponse.ShardResult.Failure[]{failure}));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            onResponse.accept(new CloseIndexResponse.IndexResult(index, results.toArray(new CloseIndexResponse.ShardResult[results.length()])));
                        }
                    }
                }));
            }
        }

        private void sendVerifyShardBeforeCloseRequest(IndexShardRoutingTable shardRoutingTable, ClusterBlock closingBlock, ActionListener<ReplicationResponse> listener) {
            ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(ReplicationResponse.ShardInfo.allSuccessful(shardRoutingTable.size()));
                listener.onResponse(response);
                return;
            }
            TaskId parentTaskId = new TaskId(MetadataIndexStateService.this.clusterService.localNode().getId(), this.request.taskId());
            TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, true, parentTaskId);
            if (this.request.ackTimeout() != null) {
                shardRequest.timeout(this.request.ackTimeout());
            }
            MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardBeforeCloseAction.TYPE, shardRequest, listener.delegateFailure((delegate, replicationResponse) -> {
                TransportVerifyShardBeforeCloseAction.ShardRequest req = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, closingBlock, false, parentTaskId);
                if (this.request.ackTimeout() != null) {
                    req.timeout(this.request.ackTimeout());
                }
                MetadataIndexStateService.this.client.executeLocally(TransportVerifyShardBeforeCloseAction.TYPE, req, delegate);
            }));
        }
    }

    private record FinalizeBlocksTask(AddIndexBlockClusterStateUpdateRequest request, Map<Index, ClusterBlock> blockedIndices, Map<Index, AddIndexBlockResponse.AddBlockResult> verifyResults, ActionListener<AddIndexBlockResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    private record CloseIndicesTask(CloseIndexClusterStateUpdateRequest request, Map<Index, ClusterBlock> blockedIndices, Map<Index, CloseIndexResponse.IndexResult> verifyResults, ActionListener<CloseIndexResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

