/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class InferenceFieldMetadata
implements SimpleDiffable<InferenceFieldMetadata>,
ToXContentFragment {
    private static final String INFERENCE_ID_FIELD = "inference_id";
    private static final String SEARCH_INFERENCE_ID_FIELD = "search_inference_id";
    private static final String SOURCE_FIELDS_FIELD = "source_fields";
    private final String name;
    private final String inferenceId;
    private final String searchInferenceId;
    private final String[] sourceFields;

    public InferenceFieldMetadata(String name, String inferenceId, String[] sourceFields) {
        this(name, inferenceId, inferenceId, sourceFields);
    }

    public InferenceFieldMetadata(String name, String inferenceId, String searchInferenceId, String[] sourceFields) {
        this.name = Objects.requireNonNull(name);
        this.inferenceId = Objects.requireNonNull(inferenceId);
        this.searchInferenceId = Objects.requireNonNull(searchInferenceId);
        this.sourceFields = Objects.requireNonNull(sourceFields);
    }

    public InferenceFieldMetadata(StreamInput input) throws IOException {
        this.name = input.readString();
        this.inferenceId = input.readString();
        this.searchInferenceId = input.getTransportVersion().onOrAfter(TransportVersions.SEMANTIC_TEXT_SEARCH_INFERENCE_ID) ? input.readString() : this.inferenceId;
        this.sourceFields = input.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.inferenceId);
        if (out.getTransportVersion().onOrAfter(TransportVersions.SEMANTIC_TEXT_SEARCH_INFERENCE_ID)) {
            out.writeString(this.searchInferenceId);
        }
        out.writeStringArray(this.sourceFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceFieldMetadata that = (InferenceFieldMetadata)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.searchInferenceId, that.searchInferenceId) && Arrays.equals(this.sourceFields, that.sourceFields);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.inferenceId, this.searchInferenceId);
        result = 31 * result + Arrays.hashCode(this.sourceFields);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getInferenceId() {
        return this.inferenceId;
    }

    public String getSearchInferenceId() {
        return this.searchInferenceId;
    }

    public String[] getSourceFields() {
        return this.sourceFields;
    }

    public static Diff<InferenceFieldMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(InferenceFieldMetadata::new, in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(INFERENCE_ID_FIELD, this.inferenceId);
        if (!this.searchInferenceId.equals(this.inferenceId)) {
            builder.field(SEARCH_INFERENCE_ID_FIELD, this.searchInferenceId);
        }
        builder.array(SOURCE_FIELDS_FIELD, this.sourceFields);
        return builder.endObject();
    }

    public static InferenceFieldMetadata fromXContent(XContentParser parser) throws IOException {
        String name = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        Objects.requireNonNull(token, "Expected InferenceFieldMetadata but got EOF");
        String currentFieldName = null;
        String inferenceId = null;
        String searchInferenceId = null;
        ArrayList<String> inputFields = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (INFERENCE_ID_FIELD.equals(currentFieldName)) {
                    inferenceId = parser.text();
                    continue;
                }
                if (!SEARCH_INFERENCE_ID_FIELD.equals(currentFieldName)) continue;
                searchInferenceId = parser.text();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!SOURCE_FIELDS_FIELD.equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        inputFields.add(parser.text());
                        continue;
                    }
                    parser.skipChildren();
                }
                continue;
            }
            parser.skipChildren();
        }
        return new InferenceFieldMetadata(name, inferenceId, searchInferenceId == null ? inferenceId : searchInferenceId, (String[])inputFields.toArray(String[]::new));
    }
}

