/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpdateDesiredNodesResponse
extends ActionResponse
implements ToXContentObject {
    private static final TransportVersion DRY_RUN_SUPPORTING_VERSION = TransportVersions.V_8_4_0;
    private final boolean replacedExistingHistoryId;
    private final boolean dryRun;

    public UpdateDesiredNodesResponse(boolean replacedExistingHistoryId) {
        this(replacedExistingHistoryId, false);
    }

    public UpdateDesiredNodesResponse(boolean replacedExistingHistoryId, boolean dryRun) {
        this.replacedExistingHistoryId = replacedExistingHistoryId;
        this.dryRun = dryRun;
    }

    public UpdateDesiredNodesResponse(StreamInput in) throws IOException {
        super(in);
        this.replacedExistingHistoryId = in.readBoolean();
        this.dryRun = in.getTransportVersion().onOrAfter(DRY_RUN_SUPPORTING_VERSION) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.replacedExistingHistoryId);
        if (out.getTransportVersion().onOrAfter(DRY_RUN_SUPPORTING_VERSION)) {
            out.writeBoolean(this.dryRun);
        }
    }

    public boolean hasReplacedExistingHistoryId() {
        return this.replacedExistingHistoryId;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("replaced_existing_history_id", this.replacedExistingHistoryId);
        builder.field("dry_run", this.dryRun);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDesiredNodesResponse that = (UpdateDesiredNodesResponse)o;
        return this.replacedExistingHistoryId == that.replacedExistingHistoryId && this.dryRun == that.dryRun;
    }

    public int hashCode() {
        return Objects.hash(this.replacedExistingHistoryId, this.dryRun);
    }
}

