/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;

public class FallbackableClaim {
    private final String name;
    private final JWTClaimsSet claimsSet;
    private final String actualName;

    public FallbackableClaim(String name, @Nullable Map<String, String> fallbackClaimNames, JWTClaimsSet claimsSet) {
        this.name = Objects.requireNonNull(name);
        this.claimsSet = Objects.requireNonNull(claimsSet);
        String fallbackName = fallbackClaimNames != null ? fallbackClaimNames.getOrDefault(name, name) : null;
        this.actualName = fallbackName == null ? name : (claimsSet.getClaim(name) != null ? name : fallbackName);
    }

    public String getActualName() {
        return this.actualName;
    }

    public String getStringClaimValue() {
        try {
            return this.claimsSet.getStringClaim(this.actualName);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(Strings.format((String)"cannot parse string claim [%s] as string", (Object[])new Object[]{this}), e);
        }
    }

    public List<String> getStringListClaimValue() {
        Object claimValue = this.claimsSet.getClaim(this.actualName);
        if (claimValue instanceof String) {
            return List.of((String)claimValue);
        }
        try {
            return this.claimsSet.getStringListClaim(this.actualName);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(Strings.format((String)"cannot parse string claim [%s] as string array", (Object[])new Object[]{this}), e);
        }
    }

    public String toString() {
        if (this.name.equals(this.actualName)) {
            return this.name;
        }
        return Strings.format((String)"%s (fallback of %s)", (Object[])new Object[]{this.actualName, this.name});
    }
}

