/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.java_version_checker;

import java.util.Arrays;
import java.util.Locale;

final class JavaVersionChecker {
    private JavaVersionChecker() {
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            throw new IllegalArgumentException("expected zero arguments but was " + Arrays.toString(args));
        }
        int MIN_VERSION = 17;
        String versionString = System.getProperty("java.specification.version");
        int version = versionString.equals("1.8") ? 8 : Integer.parseInt(versionString);
        if (version >= 17) {
            return;
        }
        String message = String.format(Locale.ROOT, "The minimum required Java version is %d; your Java version %d from [%s] does not meet that requirement.", 17, version, System.getProperty("java.home"));
        System.err.println(message);
        System.exit(1);
    }
}

