/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.transform.action.ScheduleNowTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;
import org.elasticsearch.xpack.transform.transforms.scheduling.TransformScheduler;

public class TransportScheduleNowTransformAction
extends TransportTasksAction<TransformTask, ScheduleNowTransformAction.Request, ScheduleNowTransformAction.Response, ScheduleNowTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportScheduleNowTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformScheduler transformScheduler;

    @Inject
    public TransportScheduleNowTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, TransformServices transformServices) {
        super("cluster:admin/transform/schedule_now", clusterService, transportService, actionFilters, ScheduleNowTransformAction.Request::new, ScheduleNowTransformAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.transformConfigManager = transformServices.configManager();
        this.transformScheduler = transformServices.scheduler();
    }

    protected void doExecute(Task task, ScheduleNowTransformAction.Request request, ActionListener<ScheduleNowTransformAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        ActionListener getTransformListener = ActionListener.wrap(unusedConfig -> {
            PersistentTasksCustomMetadata.PersistentTask<?> transformTask = TransformTask.getTransformTask(request.getId(), clusterState);
            if (transformTask != null && transformTask.isAssigned() && transformTask.getState() instanceof TransformState && ((TransformState)transformTask.getState()).getTaskState() != TransformTaskState.FAILED) {
                ActionListener taskScheduleNowListener = ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                    if (e instanceof TransformTaskDisappearedDuringScheduleNowException) {
                        logger.debug(() -> Strings.format((String)"[%s] transform task disappeared during schedule_now, ignoring.", (Object[])new Object[]{request.getId()}), (Throwable)e);
                        listener.onResponse((Object)ScheduleNowTransformAction.Response.TRUE);
                        return;
                    }
                    if (e instanceof TransformTaskScheduleNowException) {
                        logger.warn(() -> Strings.format((String)"[%s] failed to schedule now the running transform.", (Object[])new Object[]{request.getId()}), (Throwable)e);
                        listener.onResponse((Object)ScheduleNowTransformAction.Response.TRUE);
                        return;
                    }
                    listener.onFailure(e);
                });
                request.setNodes(new String[]{transformTask.getExecutorNode()});
                super.doExecute(task, (BaseTasksRequest)request, taskScheduleNowListener);
            } else {
                listener.onResponse((Object)ScheduleNowTransformAction.Response.TRUE);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.getTransformConfiguration(request.getId(), (ActionListener<TransformConfig>)getTransformListener);
    }

    protected void taskOperation(CancellableTask actionTask, ScheduleNowTransformAction.Request request, TransformTask transformTask, ActionListener<ScheduleNowTransformAction.Response> listener) {
        this.transformScheduler.scheduleNow(request.getId());
        listener.onResponse((Object)ScheduleNowTransformAction.Response.TRUE);
    }

    protected ScheduleNowTransformAction.Response newResponse(ScheduleNowTransformAction.Request request, List<ScheduleNowTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (tasks.isEmpty()) {
            if (!taskOperationFailures.isEmpty()) {
                throw new TransformTaskScheduleNowException("Failed to schedule now the running transform due to task operation failure.", taskOperationFailures.get(0).getCause(), new Object[0]);
            }
            if (!failedNodeExceptions.isEmpty()) {
                FailedNodeException failedNodeException = failedNodeExceptions.get(0);
                Throwable failedNodeExceptionCause = ExceptionsHelper.unwrapCause((Throwable)failedNodeException.getCause());
                if (failedNodeExceptionCause instanceof ActionNotFoundTransportException) {
                    throw (ActionNotFoundTransportException)failedNodeExceptionCause;
                }
                throw new TransformTaskScheduleNowException("Failed to schedule now the running transform due to failed node exception.", (Throwable)failedNodeExceptions.get(0), new Object[0]);
            }
            throw new TransformTaskDisappearedDuringScheduleNowException("Could not schedule now the running transform as it has been stopped.");
        }
        return tasks.get(0);
    }

    private static class TransformTaskScheduleNowException
    extends ElasticsearchException {
        TransformTaskScheduleNowException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }

    private static class TransformTaskDisappearedDuringScheduleNowException
    extends ElasticsearchException {
        TransformTaskDisappearedDuringScheduleNowException(String msg) {
            super(msg, new Object[0]);
        }
    }
}

