/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.nio.file.Path;
import java.util.Optional;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.server.cli.SecureSettingsLoader;

public class KeyStoreLoader
implements SecureSettingsLoader {
    @Override
    public SecureSettingsLoader.LoadedSecrets load(Environment environment, Terminal terminal) throws Exception {
        KeyStoreWrapper secureSettings = KeyStoreWrapper.load((Path)environment.configFile());
        SecureString password = secureSettings == null || !secureSettings.hasPassword() ? new SecureString(new char[0]) : new SecureString(terminal.readSecret("Enter password for the elasticsearch keystore : "));
        return new SecureSettingsLoader.LoadedSecrets((SecureSettings)secureSettings, Optional.of(password));
    }

    @Override
    public SecureSettings bootstrap(Environment environment, SecureString password) throws Exception {
        return KeyStoreWrapper.bootstrap((Path)environment.configFile(), () -> password);
    }

    @Override
    public boolean supportsSecurityAutoConfiguration() {
        return true;
    }
}

