/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.nulls;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class IsNotNull
extends UnaryScalarFunction
implements Negatable<UnaryScalarFunction> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "IsNotNull", IsNotNull::new);

    public IsNotNull(Source source, Expression field) {
        super(source, field);
    }

    private IsNotNull(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return IsNotNull.ENTRY.name;
    }

    @Override
    protected NodeInfo<IsNotNull> info() {
        return NodeInfo.create(this, IsNotNull::new, this.field());
    }

    @Override
    protected IsNotNull replaceChild(Expression newChild) {
        return new IsNotNull(this.source(), newChild);
    }

    @Override
    public Object fold() {
        return this.field().fold() != null && !DataType.isNull(this.field().dataType());
    }

    @Override
    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public UnaryScalarFunction negate() {
        return new IsNull(this.source(), this.field());
    }
}

