/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.DateUtils;

public class Range
extends ScalarFunction {
    private final Expression value;
    private final Expression lower;
    private final Expression upper;
    private final boolean includeLower;
    private final boolean includeUpper;
    private final ZoneId zoneId;

    public Range(Source src, Expression value, Expression lower, boolean inclLower, Expression upper, boolean inclUpper, ZoneId zoneId) {
        super(src, Arrays.asList(value, lower, upper));
        this.value = value;
        this.lower = lower;
        this.upper = upper;
        this.includeLower = inclLower;
        this.includeUpper = inclUpper;
        this.zoneId = zoneId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected NodeInfo<Range> info() {
        return NodeInfo.create(this, Range::new, this.value, this.lower, this.includeLower, this.upper, this.includeUpper, this.zoneId);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Range(this.source(), newChildren.get(0), newChildren.get(1), this.includeLower, newChildren.get(2), this.includeUpper, this.zoneId);
    }

    public Expression value() {
        return this.value;
    }

    public Expression lower() {
        return this.lower;
    }

    public Expression upper() {
        return this.upper;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public boolean foldable() {
        if (this.lower.foldable() && this.upper.foldable()) {
            return this.areBoundariesInvalid() || this.value.foldable();
        }
        return false;
    }

    @Override
    public Object fold() {
        boolean lowerComparsion;
        if (this.areBoundariesInvalid()) {
            return Boolean.FALSE;
        }
        Object val = this.value.fold();
        Integer lowerCompare = BinaryComparison.compare(this.lower.fold(), val);
        Integer upperCompare = BinaryComparison.compare(val, this.upper().fold());
        boolean bl = lowerCompare == null ? false : (this.includeLower ? lowerCompare <= 0 : (lowerComparsion = lowerCompare < 0));
        boolean upperComparsion = upperCompare == null ? false : (this.includeUpper ? upperCompare <= 0 : upperCompare < 0);
        return lowerComparsion && upperComparsion;
    }

    protected boolean areBoundariesInvalid() {
        Integer compare;
        Object lowerValue = this.lower.fold();
        Object upperValue = this.upper.fold();
        if (DataType.isDateTime(this.value.dataType()) || DataType.isDateTime(this.lower.dataType()) || DataType.isDateTime(this.upper.dataType())) {
            try {
                if (upperValue instanceof String) {
                    String upperString = (String)upperValue;
                    upperValue = DateUtils.asDateTime(upperString);
                }
                if (lowerValue instanceof String) {
                    String lowerString = (String)lowerValue;
                    lowerValue = DateUtils.asDateTime(lowerString);
                }
            }
            catch (DateTimeException e) {
                return false;
            }
        }
        return (compare = BinaryComparison.compare(lowerValue, upperValue)) != null && (compare > 0 || compare == 0 && (!this.includeLower || !this.includeUpper));
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.includeLower, this.includeUpper, this.value, this.lower, this.upper, this.zoneId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper) && Objects.equals(this.value, other.value) && Objects.equals(this.lower, other.lower) && Objects.equals(this.upper, other.upper) && Objects.equals(this.zoneId, other.zoneId);
    }
}

