/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.condition;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public interface Condition
extends ToXContentObject {
    public String type();

    public static class Result
    implements ToXContentObject {
        private final String type;
        private final Status status = Status.SUCCESS;
        private final String reason;
        private final boolean met;
        @Nullable
        private final Map<String, Object> resolveValues;

        public Map<String, Object> getResolvedValues() {
            return this.resolveValues;
        }

        public Result(Map<String, Object> resolveValues, String type, boolean met) {
            this.type = type;
            this.met = met;
            this.reason = null;
            this.resolveValues = resolveValues;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public boolean met() {
            return this.met;
        }

        public String reason() {
            assert (this.status == Status.FAILURE);
            return this.reason;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status) {
                case SUCCESS: {
                    assert (this.reason == null);
                    builder.field("met", this.met);
                    break;
                }
                case FAILURE: {
                    assert (this.reason != null && !this.met);
                    builder.field("reason", this.reason);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.resolveValues != null) {
                builder.startObject(this.type).field("resolved_values", this.resolveValues).endObject();
            }
            return builder.endObject();
        }

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

