/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.transport.Transports;

public class SemanticTextInfoExtractor {
    private static final Logger logger = LogManager.getLogger(SemanticTextInfoExtractor.class);

    public static Set<String> extractIndexesReferencingInferenceEndpoints(Metadata metadata, Set<String> endpointIds) {
        assert (Transports.assertNotTransportThread((String)"non-trivial nested loops over cluster state structures"));
        assert (!endpointIds.isEmpty());
        assert (metadata != null);
        HashSet<String> referenceIndices = new HashSet<String>();
        Map indices = metadata.indices();
        indices.forEach((indexName, indexMetadata) -> {
            Map inferenceFields = indexMetadata.getInferenceFields();
            if (inferenceFields.values().stream().anyMatch(im -> endpointIds.contains(im.getInferenceId()) || endpointIds.contains(im.getSearchInferenceId()))) {
                referenceIndices.add((String)indexName);
            }
        });
        return referenceIndices;
    }
}

