/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.TransportClusterHealthAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class AnnotationIndex {
    private static final Logger logger = LogManager.getLogger(AnnotationIndex.class);
    public static final String READ_ALIAS_NAME = ".ml-annotations-read";
    public static final String WRITE_ALIAS_NAME = ".ml-annotations-write";
    public static final String LATEST_INDEX_NAME = ".ml-annotations-000001";
    public static final List<String> OLD_INDEX_NAMES = List.of(".ml-annotations-6");
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    public static final int ANNOTATION_INDEX_MAPPINGS_VERSION = 1;

    public static void createAnnotationsIndexIfNecessaryAndWaitForYellow(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener annotationsIndexCreatedListener = finalListener.delegateFailureAndWrap((delegate, success) -> {
            ClusterHealthRequest request = new ClusterHealthRequest(masterNodeTimeout, new String[]{READ_ALIAS_NAME}).waitForYellowStatus();
            ClientHelper.executeAsyncWithOrigin(client, "ml", TransportClusterHealthAction.TYPE, request, delegate.delegateFailureAndWrap((l, r) -> l.onResponse((Object)(!r.isTimedOut() ? 1 : 0))));
        });
        AnnotationIndex.createAnnotationsIndexIfNecessary(client, state, masterNodeTimeout, (ActionListener<Boolean>)annotationsIndexCreatedListener);
    }

    public static void createAnnotationsIndexIfNecessary(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener checkMappingsListener = finalListener.delegateFailureAndWrap((delegate, success) -> ElasticsearchMappings.addDocMappingIfMissing(WRITE_ALIAS_NAME, (CheckedSupplier<String, IOException>)((CheckedSupplier)AnnotationIndex::annotationsMapping), client, state, masterNodeTimeout, (ActionListener<Boolean>)delegate, 1));
        ActionListener createAliasListener = finalListener.delegateFailureAndWrap((finalDelegate, currentIndexName) -> {
            IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(currentIndexName).alias(READ_ALIAS_NAME).isHidden(Boolean.valueOf(true))).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(currentIndexName).alias(WRITE_ALIAS_NAME).isHidden(Boolean.valueOf(true)));
            SortedMap lookup = state.getMetadata().getIndicesLookup();
            for (String oldIndexName : OLD_INDEX_NAMES) {
                IndexAbstraction oldIndexAbstraction = (IndexAbstraction)lookup.get(oldIndexName);
                if (oldIndexAbstraction == null) continue;
                for (Index oldIndex : oldIndexAbstraction.getIndices()) {
                    requestBuilder.removeAlias(oldIndex.getName(), WRITE_ALIAS_NAME);
                }
            }
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", (IndicesAliasesRequest)requestBuilder.request(), finalDelegate.delegateFailureAndWrap((l, r) -> checkMappingsListener.onResponse((Object)r.isAcknowledged())), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        });
        MlMetadata mlMetadata = MlMetadata.getMlMetadata(state);
        SortedMap mlLookup = state.getMetadata().getIndicesLookup().tailMap(".ml");
        if (!mlMetadata.isResetMode() && !mlMetadata.isUpgradeMode() && !mlLookup.isEmpty() && mlLookup.firstKey().startsWith(".ml")) {
            IndexAbstraction currentIndexAbstraction = (IndexAbstraction)mlLookup.get(LATEST_INDEX_NAME);
            if (currentIndexAbstraction == null) {
                logger.debug(() -> Strings.format((String)"Creating [%s] because [%s] exists; trace %s", (Object[])new Object[]{LATEST_INDEX_NAME, mlLookup.firstKey(), ExceptionsHelper.formatStackTrace((StackTraceElement[])Thread.currentThread().getStackTrace())}));
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(LATEST_INDEX_NAME).mapping(AnnotationIndex.annotationsMapping()).settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put("index.number_of_shards", "1").put("index.hidden", true));
                ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)LATEST_INDEX_NAME), e -> {
                    if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        createAliasListener.onResponse((Object)LATEST_INDEX_NAME);
                    } else {
                        finalListener.onFailure(e);
                    }
                }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
                return;
            }
            String currentIndexName2 = ((Index)currentIndexAbstraction.getIndices().get(0)).getName();
            IndexAbstraction writeAliasAbstraction = (IndexAbstraction)mlLookup.get(WRITE_ALIAS_NAME);
            if (!mlLookup.containsKey(READ_ALIAS_NAME) || writeAliasAbstraction == null) {
                createAliasListener.onResponse((Object)currentIndexName2);
                return;
            }
            List writeAliasIndices = writeAliasAbstraction.getIndices();
            if (writeAliasIndices.size() != 1 || !currentIndexName2.equals(((Index)writeAliasIndices.get(0)).getName())) {
                createAliasListener.onResponse((Object)currentIndexName2);
                return;
            }
            checkMappingsListener.onResponse((Object)false);
            return;
        }
        finalListener.onResponse((Object)false);
    }

    public static String annotationsMapping() {
        return TemplateUtils.loadTemplate("/ml/annotations_index_mappings.json", "8.11.0", MAPPINGS_VERSION_VARIABLE, Map.of("xpack.ml.managed.index.version", Integer.toString(1)));
    }
}

