/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.core.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionSnapshot;
import org.elasticsearch.xpack.core.watcher.execution.Wid;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.execution.CurrentExecutions;
import org.elasticsearch.xpack.watcher.execution.TriggeredExecutionContext;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatchStore;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class ExecutionService {
    public static final Setting<TimeValue> DEFAULT_THROTTLE_PERIOD_SETTING = Setting.positiveTimeSetting((String)"xpack.watcher.execution.default_throttle_period", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(ExecutionService.class);
    private final MeanMetric totalExecutionsTime = new MeanMetric();
    private final Map<String, MeanMetric> actionByTypeExecutionTime = new HashMap<String, MeanMetric>();
    private final TimeValue defaultThrottlePeriod;
    private final TimeValue maxStopTimeout;
    private final TimeValue indexDefaultTimeout;
    private final HistoryStore historyStore;
    private final TriggeredWatchStore triggeredWatchStore;
    private final Clock clock;
    private final WatchParser parser;
    private final ClusterService clusterService;
    private final Client client;
    private final WatchExecutor executor;
    private final ExecutorService genericExecutor;
    private AtomicReference<CurrentExecutions> currentExecutions = new AtomicReference();
    private final AtomicBoolean paused = new AtomicBoolean(false);

    public ExecutionService(Settings settings, HistoryStore historyStore, TriggeredWatchStore triggeredWatchStore, WatchExecutor executor, Clock clock, WatchParser parser, ClusterService clusterService, Client client, ExecutorService genericExecutor) {
        this.historyStore = historyStore;
        this.triggeredWatchStore = triggeredWatchStore;
        this.executor = executor;
        this.clock = clock;
        this.defaultThrottlePeriod = (TimeValue)DEFAULT_THROTTLE_PERIOD_SETTING.get(settings);
        this.maxStopTimeout = (TimeValue)Watcher.MAX_STOP_TIMEOUT_SETTING.get(settings);
        this.parser = parser;
        this.clusterService = clusterService;
        this.client = client;
        this.genericExecutor = genericExecutor;
        this.indexDefaultTimeout = settings.getAsTime("xpack.watcher.internal.ops.index.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.currentExecutions.set(new CurrentExecutions());
    }

    public void unPause() {
        this.paused.set(false);
    }

    public int pause(Runnable stoppedListener) {
        assert (stoppedListener != null);
        this.paused.set(true);
        return this.clearExecutionsAndQueue(stoppedListener);
    }

    public int clearExecutionsAndQueue(Runnable stoppedListener) {
        assert (stoppedListener != null);
        int cancelledTaskCount = this.executor.queue().drainTo(new ArrayList());
        this.clearExecutions(stoppedListener);
        return cancelledTaskCount;
    }

    public TimeValue defaultThrottlePeriod() {
        return this.defaultThrottlePeriod;
    }

    public long executionThreadPoolQueueSize() {
        return this.executor.queue().size();
    }

    public long executionThreadPoolMaxSize() {
        return this.executor.largestPoolSize();
    }

    CurrentExecutions getCurrentExecutions() {
        return this.currentExecutions.get();
    }

    public List<WatchExecutionSnapshot> currentExecutions() {
        ArrayList<WatchExecutionSnapshot> currentExecutions = new ArrayList<WatchExecutionSnapshot>();
        for (WatchExecution watchExecution : this.currentExecutions.get()) {
            currentExecutions.add(watchExecution.createSnapshot());
        }
        currentExecutions.sort(Comparator.comparing(WatchExecutionSnapshot::executionTime));
        return currentExecutions;
    }

    public List<QueuedWatch> queuedWatches() {
        ArrayList snapshot = new ArrayList();
        this.executor.tasks().forEach(snapshot::add);
        if (snapshot.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueuedWatch> queuedWatches = new ArrayList<QueuedWatch>(snapshot.size());
        for (Runnable task : snapshot) {
            WatchExecutionTask executionTask = (WatchExecutionTask)task;
            queuedWatches.add(new QueuedWatch(executionTask.ctx));
        }
        queuedWatches.sort(Comparator.comparing(QueuedWatch::executionTime));
        return queuedWatches;
    }

    void processEventsAsync(Iterable<TriggerEvent> events) throws Exception {
        if (this.paused.get()) {
            logger.debug("watcher execution service paused, not processing [{}] events", (Object)Iterables.size(events));
            return;
        }
        Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext = this.createTriggeredWatchesAndContext(events);
        List triggeredWatches = (List)watchesAndContext.v1();
        this.triggeredWatchStore.putAll(triggeredWatches, (ActionListener<BulkResponse>)ActionListener.wrap(response -> this.executeTriggeredWatches((BulkResponse)response, watchesAndContext), e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof EsRejectedExecutionException) {
                logger.debug("failed to store watch records due to filled up watcher threadpool");
            } else {
                logger.warn("failed to store watch records", (Throwable)e);
            }
        }));
    }

    void processEventsSync(Iterable<TriggerEvent> events) throws IOException {
        if (this.paused.get()) {
            logger.debug("watcher execution service paused, not processing [{}] events", (Object)Iterables.size(events));
            return;
        }
        Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext = this.createTriggeredWatchesAndContext(events);
        List triggeredWatches = (List)watchesAndContext.v1();
        logger.debug("saving watch records [{}]", (Object)triggeredWatches.size());
        BulkResponse bulkResponse = this.triggeredWatchStore.putAll(triggeredWatches);
        this.executeTriggeredWatches(bulkResponse, watchesAndContext);
    }

    private Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> createTriggeredWatchesAndContext(Iterable<TriggerEvent> events) {
        LinkedList<TriggeredWatch> triggeredWatches = new LinkedList<TriggeredWatch>();
        LinkedList<TriggeredExecutionContext> contexts = new LinkedList<TriggeredExecutionContext>();
        ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
        for (TriggerEvent event : events) {
            GetResponse response = this.getWatch(event.jobName());
            if (!response.isExists()) {
                logger.warn("unable to find watch [{}] in watch index, perhaps it has been deleted", (Object)event.jobName());
                continue;
            }
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(event.jobName(), now, event, this.defaultThrottlePeriod);
            contexts.add(ctx);
            triggeredWatches.add(new TriggeredWatch(ctx.id(), event));
        }
        return Tuple.tuple(triggeredWatches, contexts);
    }

    private void executeTriggeredWatches(BulkResponse response, Tuple<List<TriggeredWatch>, List<TriggeredExecutionContext>> watchesAndContext) {
        for (int i = 0; i < response.getItems().length; ++i) {
            BulkItemResponse itemResponse = response.getItems()[i];
            if (itemResponse.isFailed()) {
                logger.error(() -> "could not store triggered watch with id [" + itemResponse.getId() + "]", (Throwable)itemResponse.getFailure().getCause());
                continue;
            }
            this.executeAsync((WatchExecutionContext)((List)watchesAndContext.v2()).get(i), (TriggeredWatch)((List)watchesAndContext.v1()).get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchRecord execute(WatchExecutionContext ctx) {
        WatchRecord record;
        block23: {
            ctx.setNodeId(this.clusterService.localNode().getId());
            record = null;
            String watchId = ctx.id().watchId();
            CurrentExecutions currentExecutions = this.currentExecutions.get();
            try {
                boolean executionAlreadyExists = currentExecutions.put(watchId, new WatchExecution(ctx, Thread.currentThread()));
                if (executionAlreadyExists) {
                    logger.trace("not executing watch [{}] because it is already queued", (Object)watchId);
                    record = ctx.abortBeforeExecution(ExecutionState.NOT_EXECUTED_ALREADY_QUEUED, "Watch is already queued in thread pool");
                    break block23;
                }
                try {
                    ctx.ensureWatchExists(() -> {
                        GetResponse resp = this.getWatch(watchId);
                        if (!resp.isExists()) {
                            throw new ResourceNotFoundException("watch [{}] does not exist", new Object[]{watchId});
                        }
                        return this.parser.parseWithSecrets(watchId, true, resp.getSourceAsBytesRef(), ctx.executionTime(), XContentType.JSON, resp.getSeqNo(), resp.getPrimaryTerm());
                    });
                }
                catch (ResourceNotFoundException e) {
                    String message = "unable to find watch for record [" + String.valueOf(ctx.id()) + "]";
                    record = ctx.abortBeforeExecution(ExecutionState.NOT_EXECUTED_WATCH_MISSING, message);
                }
                catch (Exception e) {
                    record = ctx.abortFailedExecution(e);
                }
                if (ctx.watch() != null) {
                    if (ctx.shouldBeExecuted()) {
                        logger.debug("executing watch [{}]", (Object)watchId);
                        record = this.executeInner(ctx);
                        if (ctx.recordExecution()) {
                            this.updateWatchStatus(ctx.watch());
                        }
                    } else {
                        logger.debug("not executing watch [{}]", (Object)watchId);
                        record = ctx.abortBeforeExecution(ExecutionState.EXECUTION_NOT_NEEDED, "Watch is not active");
                    }
                }
            }
            catch (Exception e) {
                record = ExecutionService.createWatchRecord(record, ctx, e);
                ExecutionService.logWatchRecord(ctx, e);
            }
            finally {
                if (ctx.knownWatch()) {
                    if (record != null && ctx.recordExecution()) {
                        try {
                            if (ctx.overrideRecordOnConflict()) {
                                this.historyStore.forcePut(record);
                            } else {
                                this.historyStore.put(record);
                            }
                        }
                        catch (Exception e) {
                            logger.error(() -> "failed to update watch record [" + String.valueOf(ctx.id()) + "]", (Throwable)e);
                        }
                    }
                    this.triggeredWatchStore.delete(ctx.id());
                }
                currentExecutions.remove(watchId);
                logger.debug("finished [{}]/[{}]", (Object)watchId, (Object)ctx.id());
            }
        }
        return record;
    }

    public void updateWatchStatus(Watch watch) throws IOException {
        Map<String, String> parameters = Map.of("include_status", "true", "include_state", "false");
        ToXContent.MapParams params = new ToXContent.MapParams(parameters);
        XContentBuilder source = JsonXContent.contentBuilder().startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)watch.status(), (ToXContent.Params)params).endObject();
        UpdateRequest updateRequest = new UpdateRequest(".watches", watch.id());
        updateRequest.doc(source);
        updateRequest.setIfSeqNo(watch.getSourceSeqNo());
        updateRequest.setIfPrimaryTerm(watch.getSourcePrimaryTerm());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
            this.client.update(updateRequest).actionGet(this.indexDefaultTimeout);
        }
        catch (DocumentMissingException documentMissingException) {
            // empty catch block
        }
    }

    private static WatchRecord createWatchRecord(WatchRecord existingRecord, WatchExecutionContext ctx, Exception e) {
        if (ctx.executionPhase().sealed()) {
            if (existingRecord == null) {
                return new WatchRecord.ExceptionWatchRecord(ctx, e);
            }
            return new WatchRecord.ExceptionWatchRecord(existingRecord, e);
        }
        return ctx.abortFailedExecution(e);
    }

    private static void logWatchRecord(WatchExecutionContext ctx, Exception e) {
        if (logger.isDebugEnabled()) {
            logger.debug(() -> "failed to execute watch [" + ctx.id().watchId() + "]", (Throwable)e);
        } else {
            logger.warn("failed to execute watch [{}]", (Object)ctx.id().watchId());
        }
    }

    private void executeAsync(WatchExecutionContext ctx, TriggeredWatch triggeredWatch) {
        try {
            this.executor.execute(new WatchExecutionTask(ctx, () -> this.execute(ctx)));
        }
        catch (EsRejectedExecutionException e) {
            this.genericExecutor.execute(new WatchExecutionTask(ctx, () -> {
                String message = "failed to run triggered watch [" + String.valueOf(triggeredWatch.id()) + "] due to thread pool capacity";
                logger.warn(message);
                WatchRecord record = ctx.abortBeforeExecution(ExecutionState.THREADPOOL_REJECTION, message);
                try {
                    this.forcePutHistory(record);
                }
                catch (Exception exc) {
                    logger.error(() -> Strings.format((String)"Error storing watch history record for watch [%s] after thread pool rejection", (Object[])new Object[]{triggeredWatch.id()}), (Throwable)exc);
                }
                try {
                    this.deleteTrigger(triggeredWatch.id());
                }
                catch (Exception exc) {
                    logger.error(() -> Strings.format((String)"Error deleting entry from .triggered_watches for watch [%s] after thread pool rejection", (Object[])new Object[]{triggeredWatch.id()}), (Throwable)exc);
                }
            }));
        }
    }

    private void forcePutHistory(WatchRecord watchRecord) {
        try {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();
                 ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
                watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
                IndexRequest request = new IndexRequest(".watcher-history-16").id(watchRecord.id().value()).source(builder).opType(DocWriteRequest.OpType.CREATE);
                this.client.index(request).get(30L, TimeUnit.SECONDS);
                logger.debug("indexed watch history record [{}]", (Object)watchRecord.id().value());
            }
            catch (VersionConflictEngineException vcee) {
                watchRecord = new WatchRecord.MessageWatchRecord(watchRecord, ExecutionState.EXECUTED_MULTIPLE_TIMES, "watch record [{ " + String.valueOf(watchRecord.id()) + " }] has been stored before, previous state [" + String.valueOf(watchRecord.state()) + "]");
                try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                     ThreadContext.StoredContext ignore2 = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
                    IndexRequest request = new IndexRequest(".watcher-history-16").id(watchRecord.id().value()).source(xContentBuilder.value((ToXContent)watchRecord));
                    this.client.index(request).get(30L, TimeUnit.SECONDS);
                }
                logger.debug("overwrote watch history record [{}]", (Object)watchRecord.id().value());
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ioe) {
            WatchRecord wr = watchRecord;
            logger.error(() -> "failed to persist watch record [" + String.valueOf(wr) + "]", (Throwable)ioe);
        }
    }

    private void deleteTrigger(Wid watcherId) {
        DeleteRequest request = new DeleteRequest(".triggered_watches");
        request.id(watcherId.value());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
            this.client.delete(request).actionGet(30L, TimeUnit.SECONDS);
        }
        logger.trace("successfully deleted triggered watch with id [{}]", (Object)watcherId);
    }

    WatchRecord executeInner(WatchExecutionContext ctx) {
        ctx.start();
        Watch watch = ctx.watch();
        ctx.beforeInput();
        Input.Result inputResult = ctx.inputResult();
        if (inputResult == null) {
            inputResult = watch.input().execute(ctx, ctx.payload());
            ctx.onInputResult(inputResult);
        }
        if (inputResult.status() == Input.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch input");
        }
        ctx.beforeCondition();
        Condition.Result conditionResult = ctx.conditionResult();
        if (conditionResult == null) {
            conditionResult = watch.condition().execute(ctx);
            ctx.onConditionResult(conditionResult);
        }
        if (conditionResult.status() == Condition.Result.Status.FAILURE) {
            return ctx.abortFailedExecution("failed to execute watch condition");
        }
        if (conditionResult.met()) {
            if (watch.actions().size() > 0 && watch.transform() != null) {
                ctx.beforeWatchTransform();
                Transform.Result transformResult = watch.transform().execute(ctx, ctx.payload());
                ctx.onWatchTransformResult(transformResult);
                if (transformResult.status() == Transform.Result.Status.FAILURE) {
                    return ctx.abortFailedExecution("failed to execute watch transform");
                }
            }
            ctx.beforeActions();
            for (ActionWrapper action : watch.actions()) {
                long start = System.nanoTime();
                ActionWrapperResult actionResult = action.execute(ctx);
                long executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                String type = action.action().type();
                this.actionByTypeExecutionTime.putIfAbsent(type, new MeanMetric());
                this.actionByTypeExecutionTime.get(type).inc(executionTime);
                ctx.onActionResult(actionResult);
            }
        }
        WatchRecord record = ctx.finish();
        this.totalExecutionsTime.inc(record.result().executionDurationMs());
        return record;
    }

    public void executeTriggeredWatches(Collection<TriggeredWatch> triggeredWatches) {
        assert (triggeredWatches != null);
        int counter = 0;
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            GetResponse response = this.getWatch(triggeredWatch.id().watchId());
            if (!response.isExists()) {
                String message = "unable to find watch for record [" + triggeredWatch.id().watchId() + "]/[" + String.valueOf(triggeredWatch.id()) + "], perhaps it has been deleted, ignoring...";
                WatchRecord.MessageWatchRecord record = new WatchRecord.MessageWatchRecord(triggeredWatch.id(), triggeredWatch.triggerEvent(), ExecutionState.NOT_EXECUTED_WATCH_MISSING, message, this.clusterService.localNode().getId());
                this.historyStore.forcePut((WatchRecord)record);
                this.triggeredWatchStore.delete(triggeredWatch.id());
                continue;
            }
            ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
            TriggeredExecutionContext ctx = new TriggeredExecutionContext(triggeredWatch.id().watchId(), now, triggeredWatch.triggerEvent(), this.defaultThrottlePeriod, true);
            this.executeAsync(ctx, triggeredWatch);
            ++counter;
        }
        logger.debug("triggered execution of [{}] watches", (Object)counter);
    }

    private GetResponse getWatch(String id) {
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
            GetRequest getRequest = new GetRequest(".watches", id).preference(Preference.LOCAL.type()).realtime(true);
            PlainActionFuture future = new PlainActionFuture();
            this.client.get(getRequest, (ActionListener)future);
            GetResponse getResponse = (GetResponse)future.actionGet();
            return getResponse;
        }
    }

    public Counters executionTimes() {
        Counters counters = new Counters(new String[0]);
        counters.inc("execution.actions._all.total", this.totalExecutionsTime.count());
        counters.inc("execution.actions._all.total_time_in_ms", this.totalExecutionsTime.sum());
        for (Map.Entry<String, MeanMetric> entry : this.actionByTypeExecutionTime.entrySet()) {
            counters.inc("execution.actions." + entry.getKey() + ".total", entry.getValue().count());
            counters.inc("execution.actions." + entry.getKey() + ".total_time_in_ms", entry.getValue().sum());
        }
        return counters;
    }

    private void clearExecutions(Runnable stoppedListener) {
        assert (stoppedListener != null);
        CurrentExecutions currentExecutionsBeforeSetting = this.currentExecutions.getAndSet(new CurrentExecutions());
        this.genericExecutor.execute(() -> currentExecutionsBeforeSetting.sealAndAwaitEmpty(this.maxStopTimeout, stoppedListener));
    }

    static class WatchExecution {
        private final WatchExecutionContext context;
        private final Thread executionThread;

        WatchExecution(WatchExecutionContext context, Thread executionThread) {
            this.context = context;
            this.executionThread = executionThread;
        }

        WatchExecutionSnapshot createSnapshot() {
            return this.context.createSnapshot(this.executionThread);
        }
    }

    public static final class WatchExecutionTask
    implements Runnable {
        private final WatchExecutionContext ctx;
        private final Runnable runnable;

        public WatchExecutionTask(WatchExecutionContext ctx, Runnable runnable) {
            this.ctx = ctx;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

