/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public class SingletonOrdinalsBuilder
implements BlockLoader.SingletonOrdinalsBuilder,
Releasable,
Block.Builder {
    private final BlockFactory blockFactory;
    private final SortedDocValues docValues;
    private final int[] ords;
    private int count;

    public SingletonOrdinalsBuilder(BlockFactory blockFactory, SortedDocValues docValues, int count) {
        this.blockFactory = blockFactory;
        this.docValues = docValues;
        blockFactory.adjustBreaker(SingletonOrdinalsBuilder.ordsSize(count));
        this.ords = new int[count];
    }

    @Override
    public SingletonOrdinalsBuilder appendNull() {
        this.ords[this.count++] = -1;
        return this;
    }

    public SingletonOrdinalsBuilder appendOrd(int value) {
        this.ords[this.count++] = value;
        return this;
    }

    @Override
    public SingletonOrdinalsBuilder beginPositionEntry() {
        throw new UnsupportedOperationException("should only have one value per doc");
    }

    @Override
    public SingletonOrdinalsBuilder endPositionEntry() {
        throw new UnsupportedOperationException("should only have one value per doc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    BytesRefBlock buildOrdinal() {
        OrdinalBytesRefBlock ordinalBytesRefBlock;
        int valueCount = this.docValues.getValueCount();
        long breakerSize = SingletonOrdinalsBuilder.ordsSize(valueCount);
        this.blockFactory.adjustBreaker(breakerSize);
        BytesRefVector bytesVector = null;
        IntBlock ordinalBlock = null;
        try {
            void var9_12;
            int[] newOrds = new int[valueCount];
            Arrays.fill(newOrds, -1);
            int[] nArray = this.ords;
            int n = nArray.length;
            boolean bl = false;
            while (var9_12 < n) {
                int ord = nArray[var9_12];
                if (ord != -1) {
                    newOrds[ord] = 0;
                }
                ++var9_12;
            }
            int nextOrd = -1;
            try (BytesRefVector.Builder bytesBuilder = this.blockFactory.newBytesRefVectorBuilder(Math.min(valueCount, this.ords.length));){
                void var9_14;
                boolean object = false;
                while (var9_14 < newOrds.length) {
                    if (newOrds[var9_14] != -1) {
                        newOrds[var9_14] = ++nextOrd;
                        bytesBuilder.appendBytesRef(this.docValues.lookupOrd((int)var9_14));
                    }
                    ++var9_14;
                }
                bytesVector = bytesBuilder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException("error resolving ordinals", e);
            }
            try (IntBlock.Builder ordinalsBuilder = this.blockFactory.newIntBlockBuilder(this.ords.length);){
                for (int ord : this.ords) {
                    if (ord == -1) {
                        ordinalsBuilder.appendNull();
                        continue;
                    }
                    ordinalsBuilder.appendInt(newOrds[ord]);
                }
                ordinalBlock = ordinalsBuilder.build();
            }
            OrdinalBytesRefBlock result = new OrdinalBytesRefBlock(ordinalBlock, bytesVector);
            bytesVector = null;
            ordinalBlock = null;
            ordinalBytesRefBlock = result;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), ordinalBlock, bytesVector});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), ordinalBlock, bytesVector});
        return ordinalBytesRefBlock;
    }

    /*
     * Exception decompiling
     */
    BytesRefBlock buildRegularBlock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long estimatedBytes() {
        long overhead = this.shouldBuildOrdinalsBlock() ? 5L : 20L;
        return (long)this.ords.length * overhead;
    }

    @Override
    public BytesRefBlock build() {
        return this.shouldBuildOrdinalsBlock() ? this.buildOrdinal() : this.buildRegularBlock();
    }

    boolean shouldBuildOrdinalsBlock() {
        return this.ords.length >= 2 * this.docValues.getValueCount() && this.ords.length >= 32;
    }

    public void close() {
        this.blockFactory.adjustBreaker(-SingletonOrdinalsBuilder.ordsSize(this.ords.length));
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        throw new UnsupportedOperationException();
    }

    private static long ordsSize(int ordsCount) {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + ordsCount * 4;
    }

    static int compactToUnique(int[] sortedOrds) {
        Arrays.sort(sortedOrds);
        int uniqueSize = 0;
        int prev = -1;
        for (int i = 0; i < sortedOrds.length; ++i) {
            if (sortedOrds[i] == prev) continue;
            sortedOrds[uniqueSize++] = prev = sortedOrds[i];
        }
        return uniqueSize;
    }
}

