/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantFloatVector;
import org.elasticsearch.compute.data.FloatArrayVector;
import org.elasticsearch.compute.data.FloatVector;

final class FloatVectorFixedBuilder
implements FloatVector.FixedBuilder {
    private final BlockFactory blockFactory;
    private final float[] values;
    private final long preAdjustedBytes;
    private int nextIndex;
    private boolean closed;

    FloatVectorFixedBuilder(int size, BlockFactory blockFactory) {
        this.preAdjustedBytes = FloatVectorFixedBuilder.ramBytesUsed(size);
        blockFactory.adjustBreaker(this.preAdjustedBytes);
        this.blockFactory = blockFactory;
        this.values = new float[size];
    }

    @Override
    public FloatVectorFixedBuilder appendFloat(float value) {
        this.values[this.nextIndex++] = value;
        return this;
    }

    @Override
    public FloatVectorFixedBuilder appendFloat(int idx, float value) {
        this.values[idx] = value;
        return this;
    }

    private static long ramBytesUsed(int size) {
        return size == 1 ? ConstantFloatVector.RAM_BYTES_USED : FloatArrayVector.BASE_RAM_BYTES_USED + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)(size * 4)));
    }

    @Override
    public long estimatedBytes() {
        return FloatVectorFixedBuilder.ramBytesUsed(this.values.length);
    }

    @Override
    public FloatVector build() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        this.closed = true;
        FloatVector vector = this.values.length == 1 ? this.blockFactory.newConstantFloatBlockWith(this.values[0], 1, this.preAdjustedBytes).asVector() : this.blockFactory.newFloatArrayVector(this.values, this.values.length, this.preAdjustedBytes);
        assert (vector.ramBytesUsed() == this.preAdjustedBytes) : "fixed Builders should estimate the exact ram bytes used";
        return vector;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.blockFactory.adjustBreaker(-this.preAdjustedBytes);
        }
    }

    boolean isReleased() {
        return this.closed;
    }
}

