/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.spatial.CentroidPointAggregator;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;

class SpatialCentroidCartesianPointSourceValuesAggregator
extends CentroidPointAggregator {
    SpatialCentroidCartesianPointSourceValuesAggregator() {
    }

    public static CentroidPointAggregator.CentroidState initSingle() {
        return new CentroidPointAggregator.CentroidState();
    }

    public static CentroidPointAggregator.GroupingCentroidState initGrouping(BigArrays bigArrays) {
        return new CentroidPointAggregator.GroupingCentroidState(bigArrays);
    }

    public static void combine(CentroidPointAggregator.CentroidState current, BytesRef wkb) {
        Point point = SpatialCentroidCartesianPointSourceValuesAggregator.decode(wkb);
        current.add(point.getX(), point.getY());
    }

    public static void combine(CentroidPointAggregator.GroupingCentroidState current, int groupId, BytesRef wkb) {
        Point point = SpatialCentroidCartesianPointSourceValuesAggregator.decode(wkb);
        current.add(point.getX(), 0.0, point.getY(), 0.0, 1L, groupId);
    }

    private static Point decode(BytesRef wkb) {
        return (Point)WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
    }
}

