/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class CountDistinctBooleanAggregator {
    private static final byte BIT_FALSE = 1;
    private static final byte BIT_TRUE = 2;

    public static SingleState initSingle() {
        return new SingleState();
    }

    public static void combine(SingleState current, boolean v) {
        current.bits = (byte)(current.bits | (v ? 2 : 1));
    }

    public static void combineIntermediate(SingleState current, boolean fbit, boolean tbit) {
        if (fbit) {
            current.bits = (byte)(current.bits | 1);
        }
        if (tbit) {
            current.bits = (byte)(current.bits | 2);
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        long result = ((state.bits & 2) >> 1) + (state.bits & 1);
        return driverContext.blockFactory().newConstantLongBlockWith(result, 1);
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState current, int groupId, boolean v) {
        current.collect(groupId, v);
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        current.combineStates(currentGroupId, state);
    }

    public static void combineIntermediate(GroupingState current, int groupId, boolean fbit, boolean tbit) {
        if (fbit) {
            current.bits.set((long)(groupId * 2));
        }
        if (tbit) {
            current.bits.set((long)(groupId * 2 + 1));
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        LongBlock.Builder builder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
        for (int i = 0; i < selected.getPositionCount(); ++i) {
            int group = selected.getInt(i);
            long count = (state.bits.get((long)(2 * group)) ? 1 : 0) + (state.bits.get((long)(2 * group + 1)) ? 1 : 0);
            builder.appendLong(count);
        }
        return builder.build();
    }

    static class SingleState
    implements AggregatorState {
        byte bits;

        SingleState() {
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 2);
            blocks[offset + 0] = driverContext.blockFactory().newConstantBooleanBlockWith((this.bits & 1) != 0, 1);
            blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith((this.bits & 2) != 0, 1);
        }

        public void close() {
        }
    }

    static class GroupingState
    extends AbstractArrayState
    implements GroupingAggregatorState {
        final BitArray bits;

        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            boolean success = false;
            try {
                this.bits = new BitArray(2L, bigArrays);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        void collect(int groupId, boolean v) {
            this.bits.set((long)(groupId * 2 + (v ? 1 : 0)));
            this.trackGroupId(groupId);
        }

        void combineStates(int currentGroupId, GroupingState state) {
            this.bits.or(state.bits);
            this.trackGroupId(currentGroupId);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 2);
            try (BooleanBlock.Builder fbitBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());
                 BooleanBlock.Builder tbitBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int group = selected.getInt(i);
                    fbitBuilder.appendBoolean(this.bits.get((long)(2 * group + 0)));
                    tbitBuilder.appendBoolean(this.bits.get((long)(2 * group + 1)));
                }
                blocks[offset + 0] = fbitBuilder.build();
                blocks[offset + 1] = tbitBuilder.build();
            }
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.bits, () -> super.close()});
        }
    }
}

