/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public abstract class AbstractArrayState
implements Releasable,
GroupingAggregatorState {
    protected final BigArrays bigArrays;
    private BitArray seen;

    public AbstractArrayState(BigArrays bigArrays) {
        this.bigArrays = bigArrays;
    }

    boolean hasValue(int groupId) {
        return this.seen == null || this.seen.get((long)groupId);
    }

    final void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        if (this.seen == null) {
            this.seen = seenGroupIds.seenGroupIds(this.bigArrays);
        }
    }

    protected final void trackGroupId(int groupId) {
        if (this.trackingGroupIds()) {
            this.seen.set((long)groupId);
        }
    }

    protected final boolean trackingGroupIds() {
        return this.seen != null;
    }

    public void close() {
        Releasables.close((Releasable)this.seen);
    }
}

