/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.auth.AWSSessionCredentials;
import java.util.Objects;
import org.elasticsearch.repositories.s3.S3BasicCredentials;

final class S3BasicSessionCredentials
extends S3BasicCredentials
implements AWSSessionCredentials {
    private final String sessionToken;

    S3BasicSessionCredentials(String accessKey, String secretKey, String sessionToken) {
        super(accessKey, secretKey);
        this.sessionToken = sessionToken;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3BasicSessionCredentials that = (S3BasicSessionCredentials)o;
        return this.sessionToken.equals(that.sessionToken) && this.getAWSAccessKeyId().equals(that.getAWSAccessKeyId()) && this.getAWSSecretKey().equals(that.getAWSSecretKey());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sessionToken, this.getAWSAccessKeyId(), this.getAWSSecretKey());
    }
}

