/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Operate2D;

final class DirectASS
extends ActiveSetSolver {
    DirectASS(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected void performIteration() {
        Primitive64Store tmpXL;
        if (this.isLogDebug()) {
            this.log("\nPerformIteration {}", 1 + this.countIterations());
            this.log(this.toActivatorString(), new Object[0]);
        }
        this.getConstraintToInclude();
        this.setConstraintToInclude(-1);
        int[] incl = this.getIncluded();
        int[] excl = this.getExcluded();
        boolean solved = false;
        int numbConstr = this.countIterationConstraints();
        int numbVars = this.countVariables();
        Primitive64Store iterX = this.getIterationX();
        Primitive64Store iterL = (Primitive64Store)Primitive64Store.FACTORY.make((long)numbConstr, 1L);
        Primitive64Store soluL = this.getSolutionL();
        if (numbConstr <= numbVars && (solved = this.isSolvableQ())) {
            if ((long)numbConstr == 0L) {
                iterX.fillMatching(this.getInvQC());
            } else {
                MatrixStore<Double> iterA = this.getIterationA();
                MatrixStore<Double> iterB = this.getIterationB();
                MatrixStore<Double> iterC = this.getIterationC();
                MatrixStore<Double> tmpInvQAT = this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)iterA.transpose()));
                ElementsSupplier<Double> tmpS = tmpInvQAT.premultiply(iterA);
                if (this.isLogDebug()) {
                    // empty if block
                }
                if (solved = this.computeGeneral(tmpS)) {
                    Operate2D rhs = this.getInvQC().premultiply(iterA).onMatching((BinaryFunction)PrimitiveMath.SUBTRACT, iterB);
                    this.getSolutionGeneral((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)rhs), iterL);
                    if (this.isLogDebug()) {
                        this.log("RHS={}", new Object[]{((Primitive64Store)rhs.collect(Primitive64Store.FACTORY)).toRawCopy1D()});
                        this.log("Relative error {} in solution for L={}", Double.NaN, Arrays.toString(iterL.toRawCopy1D()));
                    }
                    Operate2D tmpRHS = iterL.premultiply(iterA.transpose()).onMatching((Access2D)iterC, (BinaryFunction)PrimitiveMath.SUBTRACT);
                    this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)tmpRHS), iterX);
                }
            }
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (Primitive64Store)Primitive64Store.FACTORY.make((long)(numbVars + numbConstr), 1L)))) {
            iterX.fillMatching((Access1D<?>)((Object)tmpXL.limits(numbVars, 1L)));
            iterL.fillMatching((Access1D<?>)((Object)tmpXL.offsets(numbVars, 0L)));
        }
        soluL.fillAll(0.0);
        if (solved) {
            int i;
            for (i = 0; i < this.countEqualityConstraints(); ++i) {
                soluL.set((long)i, iterL.doubleValue((long)i));
            }
            for (i = 0; i < incl.length; ++i) {
                soluL.set((long)(this.countEqualityConstraints() + incl[i]), iterL.doubleValue((long)(this.countEqualityConstraints() + i)));
            }
        }
        this.handleIterationResults(solved, iterX, incl, excl);
    }
}

