/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ojalgo.array.LongToNumberMap;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.netio.LineTerminator;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.context.NumberContext;

public final class TableData<R> {
    private static final NumberContext GENERAL = NumberContext.ofScale(8);
    private static final LongToNumberMap.MapFactory<Double> COLUMN_FACTORY = LongToNumberMap.factory(Primitive64Array.FACTORY);
    private final Map<String, LongToNumberMap<Double>> myColumns = new HashMap<String, LongToNumberMap<Double>>();
    private final Structure1D.IndexMapper<R> myRowIndexMapper;
    private final Set<R> myRows = new TreeSet<R>();

    public TableData(Structure1D.IndexMapper<R> rowIndexMapper) {
        this.myRowIndexMapper = rowIndexMapper;
    }

    public double doubleValue(R row, String col) {
        return this.myColumns.computeIfAbsent(col, c -> COLUMN_FACTORY.make()).doubleValue(this.myRowIndexMapper.toIndex(row));
    }

    public CharSequence print() {
        StringBuilder builder = new StringBuilder();
        Set<String> columnKeys = this.myColumns.keySet();
        builder.append("Dimension");
        for (String col : columnKeys) {
            builder.append(";");
            builder.append(col);
        }
        builder.append((Object)LineTerminator.UNIX);
        for (String row : this.myRows) {
            builder.append((Object)row);
            for (String col : columnKeys) {
                builder.append(";");
                double value = this.myColumns.get(col).doubleValue(this.myRowIndexMapper.toIndex(row));
                if (Double.isNaN(value)) continue;
                builder.append(GENERAL.format(value));
            }
            builder.append((Object)LineTerminator.UNIX);
        }
        return builder;
    }

    public void put(R row, String col, double value) {
        this.myRows.add(row);
        this.myColumns.computeIfAbsent(col, c -> COLUMN_FACTORY.make()).put(this.myRowIndexMapper.toIndex(row), value);
    }
}

