/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.xpack.core.ml.MlTasks;

public class TaskRetriever {
    public static void getDownloadTaskInfo(Client client, String modelId, boolean waitForCompletion, TimeValue timeout, Supplier<String> errorMessageOnWaitTimeout, ActionListener<TaskInfo> listener) {
        ((ListTasksRequestBuilder)((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/model_import[n]"})).setDetailed(true).setWaitForCompletion(waitForCompletion).setDescriptions(new String[]{MlTasks.downloadModelTaskDescription((String)modelId)}).setTimeout(timeout)).execute(ActionListener.wrap(response -> {
            List tasks = response.getTasks();
            if (tasks.size() > 0) {
                listener.onResponse((Object)((TaskInfo)tasks.get(0)));
            } else if (waitForCompletion && TaskRetriever.didItTimeout(response)) {
                listener.onFailure((Exception)TaskRetriever.taskDidNotCompleteException((String)errorMessageOnWaitTimeout.get()));
            } else {
                response.rethrowFailures("Checking model [" + modelId + "] download status");
                listener.onResponse(null);
            }
        }, e -> listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to retrieve task information for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId})))));
    }

    private static boolean didItTimeout(ListTasksResponse response) {
        if (!response.getNodeFailures().isEmpty()) {
            ElasticsearchException firstNodeFailure = (ElasticsearchException)response.getNodeFailures().get(0);
            if (firstNodeFailure.status() == RestStatus.REQUEST_TIMEOUT) {
                return true;
            }
            Throwable timeoutException = ExceptionsHelper.unwrap((Throwable)firstNodeFailure, (Class[])new Class[]{ElasticsearchTimeoutException.class, ReceiveTimeoutTransportException.class});
            if (timeoutException != null) {
                return true;
            }
        }
        return false;
    }

    private static ElasticsearchException taskDidNotCompleteException(String message) {
        return new ElasticsearchStatusException(message, RestStatus.REQUEST_TIMEOUT, new Object[0]);
    }

    private TaskRetriever() {
    }
}

